/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.renting;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.renting.ScanDocumentMapper;
import cz.airtoy.airshop.domains.renting.ScanDocumentDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ScanDocumentDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.contract_id,\n\t\tp.partner_id,\n\t\tp.type,\n\t\tp.name,\n\t\tp.description,\n\t\tp.data,\n\t\tp.path,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.scan_document p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.contract_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.data::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.scan_document p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.contract_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.data::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  ")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.id = :id")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.id = :id")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.contract_id = :contractId")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByContractId(@Bind(value="contractId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.contract_id = :contractId")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByContractId(@Bind(value="contractId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.contract_id = :contractId")
    public long findListByContractIdCount(@Bind(value="contractId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.contract_id = :contractId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByContractId(@Bind(value="contractId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.type = :type")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.type = :type")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.name = :name")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.name = :name")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.description = :description")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.description = :description")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.data = :data")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByData(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.data = :data")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByData(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.data = :data")
    public long findListByDataCount(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.data = :data ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByData(@Bind(value="data") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.path = :path")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.path = :path")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.path = :path")
    public long findListByPathCount(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.path = :path ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByPath(@Bind(value="path") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.note = :note")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.note = :note")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public ScanDocumentDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.scan_document p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.partner_id, p.type, p.name, p.description, p.data, p.path, p.date_changed, p.user_changed, p.note, p.date_created FROM renting.scan_document p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ScanDocumentMapper.class)
    public List<ScanDocumentDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO renting.scan_document (id, uid, contract_id, partner_id, type, name, description, data, path, date_changed, user_changed, note, date_created) VALUES (:id, :uid, :contractId, :partnerId, :type, :name, :description, :data, :path, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="contractId") Long var3, @Bind(value="partnerId") Long var4, @Bind(value="type") String var5, @Bind(value="name") String var6, @Bind(value="description") String var7, @Bind(value="data") String var8, @Bind(value="path") String var9, @Bind(value="dateChanged") Date var10, @Bind(value="userChanged") String var11, @Bind(value="note") String var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO renting.scan_document (contract_id, partner_id, type, name, description, data, path, date_changed, user_changed, note, date_created) VALUES (:e.contractId, :e.partnerId, :e.type, :e.name, :e.description, :e.data, :e.path, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ScanDocumentDomain var1);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE contract_id = :byContractId")
    public int updateByContractId(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byContractId") Long var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE data = :byData")
    public int updateByData(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byData") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE path = :byPath")
    public int updateByPath(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byPath") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE renting.scan_document SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, partner_id = :e.partnerId, type = :e.type, name = :e.name, description = :e.description, data = :e.data, path = :e.path, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ScanDocumentDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE contract_id = :contractId")
    public int deleteByContractId(@Bind(value="contractId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE data = :data")
    public int deleteByData(@Bind(value="data") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE path = :path")
    public int deleteByPath(@Bind(value="path") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM renting.scan_document WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

