/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.email;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.email.EmailRecipientsMapper;
import cz.airtoy.airshop.domains.email.EmailRecipientsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface EmailRecipientsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.email_id,\n\t\tp.type,\n\t\tp.recipient,\n\t\tp.recipient_id,\n\t\tp.cache_data,\n\t\tp.stat_email_recipients_sent,\n\t\tp.stat_email_recipients_refused,\n\t\tp.stat_email_recipients_viewed,\n\t\tp.ident,\n\t\tp.date_processing,\n\t\tp.date_processed,\n\t\tp.date_sent,\n\t\tp.date_failed,\n\t\tp.date_created\n FROM \n\t\temail.email_recipients p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.email_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.recipient::text ~* :mask \n\tOR \n\t\tp.recipient_id::text ~* :mask \n\tOR \n\t\tp.cache_data::text ~* :mask \n\tOR \n\t\tp.stat_email_recipients_sent::text ~* :mask \n\tOR \n\t\tp.stat_email_recipients_refused::text ~* :mask \n\tOR \n\t\tp.stat_email_recipients_viewed::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.date_processing::text ~* :mask \n\tOR \n\t\tp.date_processed::text ~* :mask \n\tOR \n\t\tp.date_sent::text ~* :mask \n\tOR \n\t\tp.date_failed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\temail.email_recipients p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.email_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.recipient::text ~* :mask \n\tOR \n\t\tp.recipient_id::text ~* :mask \n\tOR \n\t\tp.cache_data::text ~* :mask \n\tOR \n\t\tp.stat_email_recipients_sent::text ~* :mask \n\tOR \n\t\tp.stat_email_recipients_refused::text ~* :mask \n\tOR \n\t\tp.stat_email_recipients_viewed::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.date_processing::text ~* :mask \n\tOR \n\t\tp.date_processed::text ~* :mask \n\tOR \n\t\tp.date_sent::text ~* :mask \n\tOR \n\t\tp.date_failed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  ")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.id = :id")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.id = :id")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.email_id = :emailId")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByEmailId(@Bind(value="emailId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.email_id = :emailId")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByEmailId(@Bind(value="emailId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.email_id = :emailId")
    public long findListByEmailIdCount(@Bind(value="emailId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.email_id = :emailId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByEmailId(@Bind(value="emailId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.type = :type")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.type = :type")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.recipient = :recipient")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByRecipient(@Bind(value="recipient") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.recipient = :recipient")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByRecipient(@Bind(value="recipient") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.recipient = :recipient")
    public long findListByRecipientCount(@Bind(value="recipient") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.recipient = :recipient ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByRecipient(@Bind(value="recipient") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.recipient_id = :recipientId")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.recipient_id = :recipientId")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.recipient_id = :recipientId")
    public long findListByRecipientIdCount(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.recipient_id = :recipientId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByRecipientId(@Bind(value="recipientId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.cache_data = :cacheData")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByCacheData(@Bind(value="cacheData") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.cache_data = :cacheData")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByCacheData(@Bind(value="cacheData") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.cache_data = :cacheData")
    public long findListByCacheDataCount(@Bind(value="cacheData") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.cache_data = :cacheData ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByCacheData(@Bind(value="cacheData") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_sent = :statEmailRecipientsSent")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByStatEmailRecipientsSent(@Bind(value="statEmailRecipientsSent") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_sent = :statEmailRecipientsSent")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByStatEmailRecipientsSent(@Bind(value="statEmailRecipientsSent") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.stat_email_recipients_sent = :statEmailRecipientsSent")
    public long findListByStatEmailRecipientsSentCount(@Bind(value="statEmailRecipientsSent") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_sent = :statEmailRecipientsSent ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByStatEmailRecipientsSent(@Bind(value="statEmailRecipientsSent") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_refused = :statEmailRecipientsRefused")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByStatEmailRecipientsRefused(@Bind(value="statEmailRecipientsRefused") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_refused = :statEmailRecipientsRefused")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByStatEmailRecipientsRefused(@Bind(value="statEmailRecipientsRefused") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.stat_email_recipients_refused = :statEmailRecipientsRefused")
    public long findListByStatEmailRecipientsRefusedCount(@Bind(value="statEmailRecipientsRefused") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_refused = :statEmailRecipientsRefused ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByStatEmailRecipientsRefused(@Bind(value="statEmailRecipientsRefused") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_viewed = :statEmailRecipientsViewed")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByStatEmailRecipientsViewed(@Bind(value="statEmailRecipientsViewed") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_viewed = :statEmailRecipientsViewed")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByStatEmailRecipientsViewed(@Bind(value="statEmailRecipientsViewed") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.stat_email_recipients_viewed = :statEmailRecipientsViewed")
    public long findListByStatEmailRecipientsViewedCount(@Bind(value="statEmailRecipientsViewed") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.stat_email_recipients_viewed = :statEmailRecipientsViewed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByStatEmailRecipientsViewed(@Bind(value="statEmailRecipientsViewed") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_processing = :dateProcessing")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByDateProcessing(@Bind(value="dateProcessing") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_processing = :dateProcessing")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateProcessing(@Bind(value="dateProcessing") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.date_processing = :dateProcessing")
    public long findListByDateProcessingCount(@Bind(value="dateProcessing") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_processing = :dateProcessing ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateProcessing(@Bind(value="dateProcessing") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_processed = :dateProcessed")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_processed = :dateProcessed")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.date_processed = :dateProcessed")
    public long findListByDateProcessedCount(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_processed = :dateProcessed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateProcessed(@Bind(value="dateProcessed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_sent = :dateSent")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByDateSent(@Bind(value="dateSent") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_sent = :dateSent")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateSent(@Bind(value="dateSent") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.date_sent = :dateSent")
    public long findListByDateSentCount(@Bind(value="dateSent") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_sent = :dateSent ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateSent(@Bind(value="dateSent") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_failed = :dateFailed")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByDateFailed(@Bind(value="dateFailed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_failed = :dateFailed")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateFailed(@Bind(value="dateFailed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.date_failed = :dateFailed")
    public long findListByDateFailedCount(@Bind(value="dateFailed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_failed = :dateFailed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateFailed(@Bind(value="dateFailed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public EmailRecipientsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_recipients p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.type, p.recipient, p.recipient_id, p.cache_data, p.stat_email_recipients_sent, p.stat_email_recipients_refused, p.stat_email_recipients_viewed, p.ident, p.date_processing, p.date_processed, p.date_sent, p.date_failed, p.date_created FROM email.email_recipients p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailRecipientsMapper.class)
    public List<EmailRecipientsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO email.email_recipients (id, uid, email_id, type, recipient, recipient_id, cache_data, stat_email_recipients_sent, stat_email_recipients_refused, stat_email_recipients_viewed, ident, date_processing, date_processed, date_sent, date_failed, date_created) VALUES (:id, :uid, :emailId, :type, :recipient, :recipientId, :cacheData, :statEmailRecipientsSent, :statEmailRecipientsRefused, :statEmailRecipientsViewed, :ident, :dateProcessing, :dateProcessed, :dateSent, :dateFailed, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="emailId") Long var3, @Bind(value="type") String var4, @Bind(value="recipient") String var5, @Bind(value="recipientId") Long var6, @Bind(value="cacheData") String var7, @Bind(value="statEmailRecipientsSent") Integer var8, @Bind(value="statEmailRecipientsRefused") Integer var9, @Bind(value="statEmailRecipientsViewed") Integer var10, @Bind(value="ident") String var11, @Bind(value="dateProcessing") Date var12, @Bind(value="dateProcessed") Date var13, @Bind(value="dateSent") Date var14, @Bind(value="dateFailed") Date var15, @Bind(value="dateCreated") Date var16);

    @SqlUpdate(value="INSERT INTO email.email_recipients (email_id, type, recipient, recipient_id, cache_data, stat_email_recipients_sent, stat_email_recipients_refused, stat_email_recipients_viewed, ident, date_processing, date_processed, date_sent, date_failed, date_created) VALUES (:e.emailId, :e.type, :e.recipient, :e.recipientId, :e.cacheData, :e.statEmailRecipientsSent, :e.statEmailRecipientsRefused, :e.statEmailRecipientsViewed, :e.ident, :e.dateProcessing, :e.dateProcessed, :e.dateSent, :e.dateFailed, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") EmailRecipientsDomain var1);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE email_id = :byEmailId")
    public int updateByEmailId(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byEmailId") Long var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE recipient = :byRecipient")
    public int updateByRecipient(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byRecipient") String var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE recipient_id = :byRecipientId")
    public int updateByRecipientId(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byRecipientId") Long var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE cache_data = :byCacheData")
    public int updateByCacheData(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byCacheData") String var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE stat_email_recipients_sent = :byStatEmailRecipientsSent")
    public int updateByStatEmailRecipientsSent(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byStatEmailRecipientsSent") Integer var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE stat_email_recipients_refused = :byStatEmailRecipientsRefused")
    public int updateByStatEmailRecipientsRefused(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byStatEmailRecipientsRefused") Integer var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE stat_email_recipients_viewed = :byStatEmailRecipientsViewed")
    public int updateByStatEmailRecipientsViewed(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byStatEmailRecipientsViewed") Integer var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE date_processing = :byDateProcessing")
    public int updateByDateProcessing(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byDateProcessing") Date var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE date_processed = :byDateProcessed")
    public int updateByDateProcessed(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byDateProcessed") Date var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE date_sent = :byDateSent")
    public int updateByDateSent(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byDateSent") Date var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE date_failed = :byDateFailed")
    public int updateByDateFailed(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byDateFailed") Date var2);

    @SqlUpdate(value="UPDATE email.email_recipients SET id = :e.id, uid = :e.uid, email_id = :e.emailId, type = :e.type, recipient = :e.recipient, recipient_id = :e.recipientId, cache_data = :e.cacheData, stat_email_recipients_sent = :e.statEmailRecipientsSent, stat_email_recipients_refused = :e.statEmailRecipientsRefused, stat_email_recipients_viewed = :e.statEmailRecipientsViewed, ident = :e.ident, date_processing = :e.dateProcessing, date_processed = :e.dateProcessed, date_sent = :e.dateSent, date_failed = :e.dateFailed, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") EmailRecipientsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE email_id = :emailId")
    public int deleteByEmailId(@Bind(value="emailId") Long var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE recipient = :recipient")
    public int deleteByRecipient(@Bind(value="recipient") String var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE recipient_id = :recipientId")
    public int deleteByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE cache_data = :cacheData")
    public int deleteByCacheData(@Bind(value="cacheData") String var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE stat_email_recipients_sent = :statEmailRecipientsSent")
    public int deleteByStatEmailRecipientsSent(@Bind(value="statEmailRecipientsSent") Integer var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE stat_email_recipients_refused = :statEmailRecipientsRefused")
    public int deleteByStatEmailRecipientsRefused(@Bind(value="statEmailRecipientsRefused") Integer var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE stat_email_recipients_viewed = :statEmailRecipientsViewed")
    public int deleteByStatEmailRecipientsViewed(@Bind(value="statEmailRecipientsViewed") Integer var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE date_processing = :dateProcessing")
    public int deleteByDateProcessing(@Bind(value="dateProcessing") Date var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE date_processed = :dateProcessed")
    public int deleteByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE date_sent = :dateSent")
    public int deleteByDateSent(@Bind(value="dateSent") Date var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE date_failed = :dateFailed")
    public int deleteByDateFailed(@Bind(value="dateFailed") Date var1);

    @SqlUpdate(value="DELETE FROM email.email_recipients WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

