/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrderIncomingRulesMapper;
import cz.airtoy.airshop.domains.OrderIncomingRulesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrderIncomingRulesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.transportation_type_code,\n\t\tp.payment_code,\n\t\tp.currency_code,\n\t\tp.coupon_code,\n\t\tp.gift_code,\n\t\tp.target_store_id,\n\t\tp.target_transportation_type_id,\n\t\tp.ord,\n\t\tp.valid_from,\n\t\tp.valid_to,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tabra.order_incoming_rules p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.transportation_type_code::text ~* :mask \n\tOR \n\t\tp.payment_code::text ~* :mask \n\tOR \n\t\tp.currency_code::text ~* :mask \n\tOR \n\t\tp.coupon_code::text ~* :mask \n\tOR \n\t\tp.gift_code::text ~* :mask \n\tOR \n\t\tp.target_store_id::text ~* :mask \n\tOR \n\t\tp.target_transportation_type_id::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.valid_from::text ~* :mask \n\tOR \n\t\tp.valid_to::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.order_incoming_rules p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.transportation_type_code::text ~* :mask \n\tOR \n\t\tp.payment_code::text ~* :mask \n\tOR \n\t\tp.currency_code::text ~* :mask \n\tOR \n\t\tp.coupon_code::text ~* :mask \n\tOR \n\t\tp.gift_code::text ~* :mask \n\tOR \n\t\tp.target_store_id::text ~* :mask \n\tOR \n\t\tp.target_transportation_type_id::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.valid_from::text ~* :mask \n\tOR \n\t\tp.valid_to::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.view_order_incoming_rules_valid p ORDER BY p.ord ASC ")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListAllValidOrdAsc();

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.view_order_incoming_rules_valid p  ")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListAllValid();

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  ")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.source = :source")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.source = :source")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.transportation_type_code = :transportationTypeCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByTransportationTypeCode(@Bind(value="transportationTypeCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.transportation_type_code = :transportationTypeCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByTransportationTypeCode(@Bind(value="transportationTypeCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.transportation_type_code = :transportationTypeCode")
    public long findListByTransportationTypeCodeCount(@Bind(value="transportationTypeCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.transportation_type_code = :transportationTypeCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByTransportationTypeCode(@Bind(value="transportationTypeCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.payment_code = :paymentCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByPaymentCode(@Bind(value="paymentCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.payment_code = :paymentCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByPaymentCode(@Bind(value="paymentCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.payment_code = :paymentCode")
    public long findListByPaymentCodeCount(@Bind(value="paymentCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.payment_code = :paymentCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByPaymentCode(@Bind(value="paymentCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.currency_code = :currencyCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByCurrencyCode(@Bind(value="currencyCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.currency_code = :currencyCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByCurrencyCode(@Bind(value="currencyCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.currency_code = :currencyCode")
    public long findListByCurrencyCodeCount(@Bind(value="currencyCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.currency_code = :currencyCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByCurrencyCode(@Bind(value="currencyCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.coupon_code = :couponCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByCouponCode(@Bind(value="couponCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.coupon_code = :couponCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByCouponCode(@Bind(value="couponCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.coupon_code = :couponCode")
    public long findListByCouponCodeCount(@Bind(value="couponCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.coupon_code = :couponCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByCouponCode(@Bind(value="couponCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.gift_code = :giftCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByGiftCode(@Bind(value="giftCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.gift_code = :giftCode")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByGiftCode(@Bind(value="giftCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.gift_code = :giftCode")
    public long findListByGiftCodeCount(@Bind(value="giftCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.gift_code = :giftCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByGiftCode(@Bind(value="giftCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.target_store_id = :targetStoreId")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByTargetStoreId(@Bind(value="targetStoreId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.target_store_id = :targetStoreId")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByTargetStoreId(@Bind(value="targetStoreId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.target_store_id = :targetStoreId")
    public long findListByTargetStoreIdCount(@Bind(value="targetStoreId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.target_store_id = :targetStoreId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByTargetStoreId(@Bind(value="targetStoreId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.target_transportation_type_id = :targetTransportationTypeId")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByTargetTransportationTypeId(@Bind(value="targetTransportationTypeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.target_transportation_type_id = :targetTransportationTypeId")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByTargetTransportationTypeId(@Bind(value="targetTransportationTypeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.target_transportation_type_id = :targetTransportationTypeId")
    public long findListByTargetTransportationTypeIdCount(@Bind(value="targetTransportationTypeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.target_transportation_type_id = :targetTransportationTypeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByTargetTransportationTypeId(@Bind(value="targetTransportationTypeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.valid_from = :validFrom")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.valid_from = :validFrom")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.valid_from = :validFrom")
    public long findListByValidFromCount(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.valid_from = :validFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByValidFrom(@Bind(value="validFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.valid_to = :validTo")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByValidTo(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.valid_to = :validTo")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByValidTo(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.valid_to = :validTo")
    public long findListByValidToCount(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.valid_to = :validTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByValidTo(@Bind(value="validTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public OrderIncomingRulesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_incoming_rules p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.transportation_type_code, p.payment_code, p.currency_code, p.coupon_code, p.gift_code, p.target_store_id, p.target_transportation_type_id, p.ord, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.order_incoming_rules p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderIncomingRulesMapper.class)
    public List<OrderIncomingRulesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.order_incoming_rules (id, uid, source, transportation_type_code, payment_code, currency_code, coupon_code, gift_code, target_store_id, target_transportation_type_id, ord, valid_from, valid_to, note, date_created) VALUES (:id, :uid, :source, :transportationTypeCode, :paymentCode, :currencyCode, :couponCode, :giftCode, :targetStoreId, :targetTransportationTypeId, :ord, :validFrom, :validTo, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="source") String var3, @Bind(value="transportationTypeCode") String var4, @Bind(value="paymentCode") String var5, @Bind(value="currencyCode") String var6, @Bind(value="couponCode") String var7, @Bind(value="giftCode") String var8, @Bind(value="targetStoreId") Long var9, @Bind(value="targetTransportationTypeId") Long var10, @Bind(value="ord") Integer var11, @Bind(value="validFrom") Date var12, @Bind(value="validTo") Date var13, @Bind(value="note") String var14, @Bind(value="dateCreated") Date var15);

    @SqlUpdate(value="INSERT INTO abra.order_incoming_rules (source, transportation_type_code, payment_code, currency_code, coupon_code, gift_code, target_store_id, target_transportation_type_id, ord, valid_from, valid_to, note, date_created) VALUES (:e.source, :e.transportationTypeCode, :e.paymentCode, :e.currencyCode, :e.couponCode, :e.giftCode, :e.targetStoreId, :e.targetTransportationTypeId, :e.ord, :e.validFrom, :e.validTo, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrderIncomingRulesDomain var1);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE transportation_type_code = :byTransportationTypeCode")
    public int updateByTransportationTypeCode(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byTransportationTypeCode") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE payment_code = :byPaymentCode")
    public int updateByPaymentCode(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byPaymentCode") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE currency_code = :byCurrencyCode")
    public int updateByCurrencyCode(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byCurrencyCode") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE coupon_code = :byCouponCode")
    public int updateByCouponCode(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byCouponCode") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE gift_code = :byGiftCode")
    public int updateByGiftCode(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byGiftCode") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE target_store_id = :byTargetStoreId")
    public int updateByTargetStoreId(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byTargetStoreId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE target_transportation_type_id = :byTargetTransportationTypeId")
    public int updateByTargetTransportationTypeId(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byTargetTransportationTypeId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE valid_from = :byValidFrom")
    public int updateByValidFrom(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byValidFrom") Date var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE valid_to = :byValidTo")
    public int updateByValidTo(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byValidTo") Date var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.order_incoming_rules SET id = :e.id, uid = :e.uid, source = :e.source, transportation_type_code = :e.transportationTypeCode, payment_code = :e.paymentCode, currency_code = :e.currencyCode, coupon_code = :e.couponCode, gift_code = :e.giftCode, target_store_id = :e.targetStoreId, target_transportation_type_id = :e.targetTransportationTypeId, ord = :e.ord, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") OrderIncomingRulesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE transportation_type_code = :transportationTypeCode")
    public int deleteByTransportationTypeCode(@Bind(value="transportationTypeCode") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE payment_code = :paymentCode")
    public int deleteByPaymentCode(@Bind(value="paymentCode") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE currency_code = :currencyCode")
    public int deleteByCurrencyCode(@Bind(value="currencyCode") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE coupon_code = :couponCode")
    public int deleteByCouponCode(@Bind(value="couponCode") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE gift_code = :giftCode")
    public int deleteByGiftCode(@Bind(value="giftCode") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE target_store_id = :targetStoreId")
    public int deleteByTargetStoreId(@Bind(value="targetStoreId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE target_transportation_type_id = :targetTransportationTypeId")
    public int deleteByTargetTransportationTypeId(@Bind(value="targetTransportationTypeId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE valid_from = :validFrom")
    public int deleteByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE valid_to = :validTo")
    public int deleteByValidTo(@Bind(value="validTo") Date var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_incoming_rules WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

