/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.entity;

import cz.airtoy.airshop.entity.CategoryEntity;
import cz.airtoy.airshop.entity.CommodityEntity;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.codec.digest.DigestUtils;

@Table(name="commodity_category", schema="data")
@Entity
@NamedQueries(value={@NamedQuery(name="CommodityCategoryEntity.findById", query="SELECT p FROM CommodityCategoryEntity p WHERE p.id = :id"), @NamedQuery(name="CommodityCategoryEntity.findListById", query="SELECT p FROM CommodityCategoryEntity p WHERE p.id = :id"), @NamedQuery(name="CommodityCategoryEntity.findByIdCount", query="SELECT count(*) FROM CommodityCategoryEntity p WHERE p.id = :id"), @NamedQuery(name="CommodityCategoryEntity.findByUid", query="SELECT p FROM CommodityCategoryEntity p WHERE p.uid = :uid"), @NamedQuery(name="CommodityCategoryEntity.findListByUid", query="SELECT p FROM CommodityCategoryEntity p WHERE p.uid = :uid"), @NamedQuery(name="CommodityCategoryEntity.findByUidCount", query="SELECT count(*) FROM CommodityCategoryEntity p WHERE p.uid = :uid"), @NamedQuery(name="CommodityCategoryEntity.findByDateUpdated", query="SELECT p FROM CommodityCategoryEntity p WHERE p.dateUpdated = :dateUpdated"), @NamedQuery(name="CommodityCategoryEntity.findListByDateUpdated", query="SELECT p FROM CommodityCategoryEntity p WHERE p.dateUpdated = :dateUpdated"), @NamedQuery(name="CommodityCategoryEntity.findByDateUpdatedCount", query="SELECT count(*) FROM CommodityCategoryEntity p WHERE p.dateUpdated = :dateUpdated"), @NamedQuery(name="CommodityCategoryEntity.findByNote", query="SELECT p FROM CommodityCategoryEntity p WHERE p.note = :note"), @NamedQuery(name="CommodityCategoryEntity.findListByNote", query="SELECT p FROM CommodityCategoryEntity p WHERE p.note = :note"), @NamedQuery(name="CommodityCategoryEntity.findByNoteCount", query="SELECT count(*) FROM CommodityCategoryEntity p WHERE p.note = :note"), @NamedQuery(name="CommodityCategoryEntity.findByDateCreated", query="SELECT p FROM CommodityCategoryEntity p WHERE p.dateCreated = :dateCreated"), @NamedQuery(name="CommodityCategoryEntity.findListByDateCreated", query="SELECT p FROM CommodityCategoryEntity p WHERE p.dateCreated = :dateCreated"), @NamedQuery(name="CommodityCategoryEntity.findByDateCreatedCount", query="SELECT count(*) FROM CommodityCategoryEntity p WHERE p.dateCreated = :dateCreated")})
@NamedNativeQueries(value={@NamedNativeQuery(name="CommodityCategoryEntity.native.findByMask", query="SELECT e.* FROM data.commodity_category e  WHERE e.uid ~* :mask OR e.note ~* :mask ORDER BY :sort ", resultClass=CommodityCategoryEntity.class), @NamedNativeQuery(name="CommodityCategoryEntity.native.findByMaskCount", query="SELECT COUNT(e.*) FROM data.commodity_category e  WHERE e.uid ~* :mask OR e.note ~* :mask ")})
public class CommodityCategoryEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="commodity_category_id_seq")
    @SequenceGenerator(name="commodity_category_id_seq", sequenceName="commodity_category_id_seq", schema="data", allocationSize=1)
    @Column(name="id", columnDefinition="BIGSERIAL")
    private Long id;
    @Size(max=32)
    @NotNull
    @Column(name="uid", columnDefinition="VARCHAR(32) NOT NULL DEFAULT md5((((now()", length=32)
    private String uid;
    @JoinColumn(name="commodity_id", nullable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private CommodityEntity commodityEntity;
    @JoinColumn(name="category_id", nullable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private CategoryEntity categoryEntity;
    @Column(name="date_updated", columnDefinition="TIMESTAMP")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateUpdated;
    @Column(name="note", columnDefinition="TEXT")
    private String note;
    @NotNull
    @Column(name="date_created", columnDefinition="TIMESTAMP NOT NULL DEFAULT NOW()")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreated;

    @PrePersist
    @PreUpdate
    public void prePersist() {
        if (this.uid == null) {
            this.uid = DigestUtils.md5Hex((String)Long.toString(Calendar.getInstance().getTime().getTime() + (long)(Math.random() * 10.0) + (long)(Math.random() * 10.0) + (long)(Math.random() * 10.0)));
        }
        if (this.dateCreated == null) {
            this.dateCreated = Calendar.getInstance().getTime();
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getUid() {
        return this.uid;
    }

    public CommodityEntity getCommodityEntity() {
        return this.commodityEntity;
    }

    public CategoryEntity getCategoryEntity() {
        return this.categoryEntity;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public String getNote() {
        return this.note;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setCommodityEntity(CommodityEntity commodityEntity) {
        this.commodityEntity = commodityEntity;
    }

    public void setCategoryEntity(CategoryEntity categoryEntity) {
        this.categoryEntity = categoryEntity;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommodityCategoryEntity)) {
            return false;
        }
        CommodityCategoryEntity other = (CommodityCategoryEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        CommodityEntity this$commodityEntity = this.getCommodityEntity();
        CommodityEntity other$commodityEntity = other.getCommodityEntity();
        if (this$commodityEntity == null ? other$commodityEntity != null : !((Object)this$commodityEntity).equals(other$commodityEntity)) {
            return false;
        }
        CategoryEntity this$categoryEntity = this.getCategoryEntity();
        CategoryEntity other$categoryEntity = other.getCategoryEntity();
        if (this$categoryEntity == null ? other$categoryEntity != null : !((Object)this$categoryEntity).equals(other$categoryEntity)) {
            return false;
        }
        Date this$dateUpdated = this.getDateUpdated();
        Date other$dateUpdated = other.getDateUpdated();
        if (this$dateUpdated == null ? other$dateUpdated != null : !((Object)this$dateUpdated).equals(other$dateUpdated)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        Date this$dateCreated = this.getDateCreated();
        Date other$dateCreated = other.getDateCreated();
        return !(this$dateCreated == null ? other$dateCreated != null : !((Object)this$dateCreated).equals(other$dateCreated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommodityCategoryEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        CommodityEntity $commodityEntity = this.getCommodityEntity();
        result = result * 59 + ($commodityEntity == null ? 43 : ((Object)$commodityEntity).hashCode());
        CategoryEntity $categoryEntity = this.getCategoryEntity();
        result = result * 59 + ($categoryEntity == null ? 43 : ((Object)$categoryEntity).hashCode());
        Date $dateUpdated = this.getDateUpdated();
        result = result * 59 + ($dateUpdated == null ? 43 : ((Object)$dateUpdated).hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        Date $dateCreated = this.getDateCreated();
        result = result * 59 + ($dateCreated == null ? 43 : ((Object)$dateCreated).hashCode());
        return result;
    }

    public String toString() {
        return "CommodityCategoryEntity(id=" + this.getId() + ", uid=" + this.getUid() + ", commodityEntity=" + this.getCommodityEntity() + ", categoryEntity=" + this.getCategoryEntity() + ", dateUpdated=" + this.getDateUpdated() + ", note=" + this.getNote() + ", dateCreated=" + this.getDateCreated() + ")";
    }
}

