/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrderTemplatesMapper;
import cz.airtoy.airshop.domains.OrderTemplatesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrderTemplatesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.type,\n\t\tp.source,\n\t\tp.paymenttype_id,\n\t\tp.transportationtype_id,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.templates,\n\t\tp.date_created\n FROM \n\t\tabra.order_templates p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.paymenttype_id::text ~* :mask \n\tOR \n\t\tp.transportationtype_id::text ~* :mask \n\tOR \n\t\tp.abra_stav_objednavky_id::text ~* :mask \n\tOR \n\t\tp.templates::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.order_templates p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.paymenttype_id::text ~* :mask \n\tOR \n\t\tp.transportationtype_id::text ~* :mask \n\tOR \n\t\tp.abra_stav_objednavky_id::text ~* :mask \n\tOR \n\t\tp.templates::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.type = :type AND p.source = :source AND p.transportationtype_id = :transportationtypeId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByTypeSourceTransportationtypeId(@Bind(value="type") String var1, @Bind(value="source") String var2, @Bind(value="transportationtypeId") String var3);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.type = :type AND p.source = :source AND p.transportationtype_id = :transportationtypeId AND p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByTypeSourceTransportationtypeIdStavObjednavkyId(@Bind(value="type") String var1, @Bind(value="source") String var2, @Bind(value="transportationtypeId") String var3, @Bind(value="abraStavObjednavkyId") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.type = :type AND p.source = :source AND p.paymenttype_id = :paymenttypeId AND p.transportationtype_id = :transportationtypeId AND p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByTypeSourcePaymenttypeIdTransportationtypeIdStavObjednavkyId(@Bind(value="type") String var1, @Bind(value="source") String var2, @Bind(value="paymenttypeId") String var3, @Bind(value="transportationtypeId") String var4, @Bind(value="abraStavObjednavkyId") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.type = :type")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.type = :type")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.source = :source")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.source = :source")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.paymenttype_id = :paymenttypeId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByPaymenttypeId(@Bind(value="paymenttypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.paymenttype_id = :paymenttypeId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByPaymenttypeId(@Bind(value="paymenttypeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.paymenttype_id = :paymenttypeId")
    public long findListByPaymenttypeIdCount(@Bind(value="paymenttypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.paymenttype_id = :paymenttypeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByPaymenttypeId(@Bind(value="paymenttypeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.transportationtype_id = :transportationtypeId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByTransportationtypeId(@Bind(value="transportationtypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.transportationtype_id = :transportationtypeId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByTransportationtypeId(@Bind(value="transportationtypeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.transportationtype_id = :transportationtypeId")
    public long findListByTransportationtypeIdCount(@Bind(value="transportationtypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.transportationtype_id = :transportationtypeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByTransportationtypeId(@Bind(value="transportationtypeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByAbraStavObjednavkyId(@Bind(value="abraStavObjednavkyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByAbraStavObjednavkyId(@Bind(value="abraStavObjednavkyId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    public long findListByAbraStavObjednavkyIdCount(@Bind(value="abraStavObjednavkyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByAbraStavObjednavkyId(@Bind(value="abraStavObjednavkyId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.templates = :templates")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByTemplates(@Bind(value="templates") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.templates = :templates")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByTemplates(@Bind(value="templates") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.templates = :templates")
    public long findListByTemplatesCount(@Bind(value="templates") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.templates = :templates ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByTemplates(@Bind(value="templates") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public OrderTemplatesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_templates p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.source, p.paymenttype_id, p.transportationtype_id, p.abra_stav_objednavky_id, p.templates, p.date_created FROM abra.order_templates p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderTemplatesMapper.class)
    public List<OrderTemplatesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.order_templates (id, uid, type, source, paymenttype_id, transportationtype_id, abra_stav_objednavky_id, templates, date_created) VALUES (:id, :uid, :type, :source, :paymenttypeId, :transportationtypeId, :abraStavObjednavkyId, :templates, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="type") String var3, @Bind(value="source") String var4, @Bind(value="paymenttypeId") String var5, @Bind(value="transportationtypeId") String var6, @Bind(value="abraStavObjednavkyId") String var7, @Bind(value="templates") String var8, @Bind(value="dateCreated") Date var9);

    @SqlUpdate(value="INSERT INTO abra.order_templates (type, source, paymenttype_id, transportationtype_id, abra_stav_objednavky_id, templates, date_created) VALUES (:e.type, :e.source, :e.paymenttypeId, :e.transportationtypeId, :e.abraStavObjednavkyId, :e.templates, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrderTemplatesDomain var1);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE paymenttype_id = :byPaymenttypeId")
    public int updateByPaymenttypeId(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byPaymenttypeId") String var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE transportationtype_id = :byTransportationtypeId")
    public int updateByTransportationtypeId(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byTransportationtypeId") String var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE abra_stav_objednavky_id = :byAbraStavObjednavkyId")
    public int updateByAbraStavObjednavkyId(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byAbraStavObjednavkyId") String var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE templates = :byTemplates")
    public int updateByTemplates(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byTemplates") String var2);

    @SqlUpdate(value="UPDATE abra.order_templates SET id = :e.id, uid = :e.uid, type = :e.type, source = :e.source, paymenttype_id = :e.paymenttypeId, transportationtype_id = :e.transportationtypeId, abra_stav_objednavky_id = :e.abraStavObjednavkyId, templates = :e.templates, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") OrderTemplatesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE paymenttype_id = :paymenttypeId")
    public int deleteByPaymenttypeId(@Bind(value="paymenttypeId") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE transportationtype_id = :transportationtypeId")
    public int deleteByTransportationtypeId(@Bind(value="transportationtypeId") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE abra_stav_objednavky_id = :abraStavObjednavkyId")
    public int deleteByAbraStavObjednavkyId(@Bind(value="abraStavObjednavkyId") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE templates = :templates")
    public int deleteByTemplates(@Bind(value="templates") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_templates WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

