/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.abra.configuration;

import cz.airtoy.airshop.domains.AbraApiSetupDomain;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbraApiSetupItem {
    private static final Logger log = LoggerFactory.getLogger(AbraApiSetupItem.class);
    private AbraApiSetupDomain abraApiSetupDomain;
    private String key;
    private String value;
    private String type;
    private String object;
    private Date loaded = new Date();

    public AbraApiSetupItem(AbraApiSetupDomain abraApiSetupDomain) {
        this.abraApiSetupDomain = abraApiSetupDomain;
        this.key = abraApiSetupDomain.getKey();
        this.value = abraApiSetupDomain.getValue();
        this.type = abraApiSetupDomain.getType();
        this.object = abraApiSetupDomain.getObject();
        log.debug("Loaded key [" + this.key + "] value [" + this.value + "] type [" + this.type + "] object [" + this.object + "]");
    }

    public boolean isKey(String key) {
        return this.key.equals(key != null ? key : "");
    }

    public boolean isKey(String object, String key) {
        return this.object.equals(object != null ? object : "") && this.key.equals(key != null ? key : "");
    }

    public boolean isString() {
        return this.type != null && this.type.equals("STRING");
    }

    public boolean isInteger() {
        return this.type != null && this.type.equals("INT");
    }

    public boolean isDouble() {
        return this.type != null && this.type.equals("DOUBLE");
    }

    public String getAsString() {
        return this.value;
    }

    public Integer getAsInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Double getAsDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Object getObject() {
        if (this.type != null) {
            switch (this.type) {
                case "INT": {
                    return this.getAsInt();
                }
                case "DOUBLE": {
                    return this.getAsDouble();
                }
            }
            return this.getAsString();
        }
        return this.getAsString();
    }

    public AbraApiSetupDomain getAbraApiSetupDomain() {
        return this.abraApiSetupDomain;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Date getLoaded() {
        return this.loaded;
    }

    public void setAbraApiSetupDomain(AbraApiSetupDomain abraApiSetupDomain) {
        this.abraApiSetupDomain = abraApiSetupDomain;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setLoaded(Date loaded) {
        this.loaded = loaded;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbraApiSetupItem)) {
            return false;
        }
        AbraApiSetupItem other = (AbraApiSetupItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbraApiSetupDomain this$abraApiSetupDomain = this.getAbraApiSetupDomain();
        AbraApiSetupDomain other$abraApiSetupDomain = other.getAbraApiSetupDomain();
        if (this$abraApiSetupDomain == null ? other$abraApiSetupDomain != null : !((Object)this$abraApiSetupDomain).equals(other$abraApiSetupDomain)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Date this$loaded = this.getLoaded();
        Date other$loaded = other.getLoaded();
        return !(this$loaded == null ? other$loaded != null : !((Object)this$loaded).equals(other$loaded));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbraApiSetupItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbraApiSetupDomain $abraApiSetupDomain = this.getAbraApiSetupDomain();
        result = result * 59 + ($abraApiSetupDomain == null ? 43 : ((Object)$abraApiSetupDomain).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Date $loaded = this.getLoaded();
        result = result * 59 + ($loaded == null ? 43 : ((Object)$loaded).hashCode());
        return result;
    }

    public String toString() {
        return "AbraApiSetupItem(abraApiSetupDomain=" + this.getAbraApiSetupDomain() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", type=" + this.getType() + ", object=" + this.getObject() + ", loaded=" + this.getLoaded() + ")";
    }
}

