/*
 * Decompiled with CFR 0.152.
 */
package vectron.domains;

import java.util.ArrayList;
import java.util.List;
import vectron.domains.VectronRowPart;

public class VectronRowItem {
    private String commandType = "9301";
    private String vectorIndex = null;
    private Double quantity = null;
    private Double amount = null;
    private String plu = null;
    private List<VectronRowPart> dataParts = new ArrayList<VectronRowPart>();
    private String data = null;

    public static VectronRowItem parse(String line) {
        String[] parts;
        VectronRowItem vri = new VectronRowItem();
        vri.data = line;
        int i = 0;
        for (String part : parts = line.split(";")) {
            String code;
            VectronRowPart vrp = VectronRowPart.parse(i, part);
            if (i == 0) {
                String val3rd;
                vri.setCommandType(vrp.getDataItems().get(0));
                vri.setVectorIndex(vrp.getDataItems().get(1));
                if ("9301".equals(vri.getCommandType() != null ? vri.getCommandType() : "") && (val3rd = vrp.getDataItems().get(3)) != null) {
                    String[] split = val3rd.split("/");
                    if (split.length == 2) {
                        vri.setQuantity(Double.parseDouble(split[0]));
                    }
                    vri.setAmount(Double.parseDouble(split[1]));
                }
            } else if (i == 2) {
                code = vrp.getDataItems().get(0);
                if ("101".equals(code != null ? code : "")) {
                    vri.setPlu(vrp.getDataItems().get(1));
                }
            } else if (i == 3 && "101".equals((code = vrp.getDataItems().get(0)) != null ? code : "")) {
                vri.setPlu(vrp.getDataItems().get(1));
            }
            vri.dataParts.add(vrp);
            ++i;
        }
        return vri;
    }

    public String getPartValueByType(String type) {
        if (type != null && this.dataParts != null) {
            for (VectronRowPart dataPart : this.dataParts) {
                if (dataPart.getType() == null || !dataPart.getType().equalsIgnoreCase(type)) continue;
                return dataPart.getValue();
            }
        }
        return null;
    }

    public String getPartStrValueByType(String type) {
        String partValueByType = this.getPartValueByType(type);
        if (partValueByType != null) {
            return partValueByType.replaceAll("'", "");
        }
        return null;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public String getVectorIndex() {
        return this.vectorIndex;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public Double getAmount() {
        return this.amount;
    }

    public String getPlu() {
        return this.plu;
    }

    public List<VectronRowPart> getDataParts() {
        return this.dataParts;
    }

    public String getData() {
        return this.data;
    }

    public void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    public void setVectorIndex(String vectorIndex) {
        this.vectorIndex = vectorIndex;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public void setPlu(String plu) {
        this.plu = plu;
    }

    public void setDataParts(List<VectronRowPart> dataParts) {
        this.dataParts = dataParts;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectronRowItem)) {
            return false;
        }
        VectronRowItem other = (VectronRowItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$commandType = this.getCommandType();
        String other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType)) {
            return false;
        }
        String this$vectorIndex = this.getVectorIndex();
        String other$vectorIndex = other.getVectorIndex();
        if (this$vectorIndex == null ? other$vectorIndex != null : !this$vectorIndex.equals(other$vectorIndex)) {
            return false;
        }
        Double this$quantity = this.getQuantity();
        Double other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Double this$amount = this.getAmount();
        Double other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$plu = this.getPlu();
        String other$plu = other.getPlu();
        if (this$plu == null ? other$plu != null : !this$plu.equals(other$plu)) {
            return false;
        }
        List<VectronRowPart> this$dataParts = this.getDataParts();
        List<VectronRowPart> other$dataParts = other.getDataParts();
        if (this$dataParts == null ? other$dataParts != null : !((Object)this$dataParts).equals(other$dataParts)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectronRowItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        String $vectorIndex = this.getVectorIndex();
        result = result * 59 + ($vectorIndex == null ? 43 : $vectorIndex.hashCode());
        Double $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Double $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $plu = this.getPlu();
        result = result * 59 + ($plu == null ? 43 : $plu.hashCode());
        List<VectronRowPart> $dataParts = this.getDataParts();
        result = result * 59 + ($dataParts == null ? 43 : ((Object)$dataParts).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "VectronRowItem(commandType=" + this.getCommandType() + ", vectorIndex=" + this.getVectorIndex() + ", quantity=" + this.getQuantity() + ", amount=" + this.getAmount() + ", plu=" + this.getPlu() + ", dataParts=" + this.getDataParts() + ", data=" + this.getData() + ")";
    }
}

