/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.mappers.data.full;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import cz.airtoy.airshop.dao.mappers.common.BaseMapper;
import cz.airtoy.airshop.dao.mappers.data.CommodityMapper;
import cz.airtoy.airshop.domains.data.CategoryDomain;
import cz.airtoy.airshop.domains.data.CommodityDomain;
import cz.airtoy.airshop.domains.data.CommodityVariantDomain;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommodityFullMapper
extends BaseMapper
implements RowMapper<CommodityDomain> {
    private static final Logger log = LoggerFactory.getLogger(CommodityFullMapper.class);

    public CommodityDomain map(ResultSet resultSet, StatementContext ctx) throws SQLException {
        CommodityDomain d = new CommodityDomain();
        CommodityMapper.process(resultSet, d);
        d.setManufacturer(CommodityFullMapper.getString(resultSet, "manufacturer"));
        CommodityFullMapper.addVariants(resultSet, d);
        CommodityFullMapper.addCategories(resultSet, d);
        return d;
    }

    public static void addVariants(ResultSet resultSet, CommodityDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String variants = CommodityFullMapper.getString(resultSet, "variants");
            if (variants != null && !variants.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(variants, new TypeToken<List<CommodityVariantDomain>>(){}.getType())) != null) {
                d.setVariants(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }

    public static void addCategories(ResultSet resultSet, CommodityDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String categories = CommodityFullMapper.getString(resultSet, "categories");
            if (categories != null && !categories.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(categories, new TypeToken<List<CategoryDomain>>(){}.getType())) != null) {
                d.setCategories(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }
}

