/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.TransportationPacksMapper;
import cz.airtoy.airshop.domains.TransportationPacksDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TransportationPacksDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.partner_id,\n\t\tp.label_url,\n\t\tp.list_url,\n\t\tp.status,\n\t\tp.date_created\n FROM \n\t\tabra.transportation_packs p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.label_url::text ~* :mask \n\tOR \n\t\tp.list_url::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.transportation_packs p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.label_url::text ~* :mask \n\tOR \n\t\tp.list_url::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public TransportationPacksDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_packs p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public TransportationPacksDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_packs p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public TransportationPacksDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_packs p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.label_url = :labelUrl")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public TransportationPacksDomain findByLabelUrl(@Bind(value="labelUrl") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.label_url = :labelUrl")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByLabelUrl(@Bind(value="labelUrl") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_packs p  WHERE p.label_url = :labelUrl")
    public long findListByLabelUrlCount(@Bind(value="labelUrl") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.label_url = :labelUrl ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByLabelUrl(@Bind(value="labelUrl") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.list_url = :listUrl")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public TransportationPacksDomain findByListUrl(@Bind(value="listUrl") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.list_url = :listUrl")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByListUrl(@Bind(value="listUrl") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_packs p  WHERE p.list_url = :listUrl")
    public long findListByListUrlCount(@Bind(value="listUrl") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.list_url = :listUrl ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByListUrl(@Bind(value="listUrl") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.status = :status")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public TransportationPacksDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.status = :status")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_packs p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public TransportationPacksDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_packs p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.label_url, p.list_url, p.status, p.date_created FROM abra.transportation_packs p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPacksMapper.class)
    public List<TransportationPacksDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.transportation_packs (id, uid, partner_id, label_url, list_url, status, date_created) VALUES (:id, :uid, :partnerId, :labelUrl, :listUrl, :status, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="partnerId") Long var3, @Bind(value="labelUrl") String var4, @Bind(value="listUrl") String var5, @Bind(value="status") String var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO abra.transportation_packs (partner_id, label_url, list_url, status, date_created) VALUES (:e.partnerId, :e.labelUrl, :e.listUrl, :e.status, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TransportationPacksDomain var1);

    @SqlUpdate(value="UPDATE abra.transportation_packs SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, label_url = :e.labelUrl, list_url = :e.listUrl, status = :e.status, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TransportationPacksDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.transportation_packs SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, label_url = :e.labelUrl, list_url = :e.listUrl, status = :e.status, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TransportationPacksDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_packs SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, label_url = :e.labelUrl, list_url = :e.listUrl, status = :e.status, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") TransportationPacksDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE abra.transportation_packs SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, label_url = :e.labelUrl, list_url = :e.listUrl, status = :e.status, date_created = :e.dateCreated WHERE label_url = :byLabelUrl")
    public int updateByLabelUrl(@BindBean(value="e") TransportationPacksDomain var1, @Bind(value="byLabelUrl") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_packs SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, label_url = :e.labelUrl, list_url = :e.listUrl, status = :e.status, date_created = :e.dateCreated WHERE list_url = :byListUrl")
    public int updateByListUrl(@BindBean(value="e") TransportationPacksDomain var1, @Bind(value="byListUrl") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_packs SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, label_url = :e.labelUrl, list_url = :e.listUrl, status = :e.status, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") TransportationPacksDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_packs SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, label_url = :e.labelUrl, list_url = :e.listUrl, status = :e.status, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TransportationPacksDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.transportation_packs WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_packs WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_packs WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_packs WHERE label_url = :labelUrl")
    public int deleteByLabelUrl(@Bind(value="labelUrl") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_packs WHERE list_url = :listUrl")
    public int deleteByListUrl(@Bind(value="listUrl") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_packs WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_packs WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

