/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.DivisionsMapper;
import cz.airtoy.airshop.domains.DivisionsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface DivisionsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.address_id,\n\t\tp.classid,\n\t\tp.code,\n\t\tp.comment,\n\t\tp.displayaddress,\n\t\tp.displayname,\n\t\tp.displayparent,\n\t\tp.district_id,\n\t\tp.hidden,\n\t\tp.name,\n\t\tp.note,\n\t\tp.objversion,\n\t\tp.parent_id,\n\t\tp.updated,\n\t\tp.date_created\n FROM \n\t\tabra.divisions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.address_id::text ~* :mask \n\tOR \n\t\tp.classid::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.comment::text ~* :mask \n\tOR \n\t\tp.displayaddress::text ~* :mask \n\tOR \n\t\tp.displayname::text ~* :mask \n\tOR \n\t\tp.displayparent::text ~* :mask \n\tOR \n\t\tp.district_id::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.parent_id::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.divisions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.address_id::text ~* :mask \n\tOR \n\t\tp.classid::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.comment::text ~* :mask \n\tOR \n\t\tp.displayaddress::text ~* :mask \n\tOR \n\t\tp.displayname::text ~* :mask \n\tOR \n\t\tp.displayparent::text ~* :mask \n\tOR \n\t\tp.district_id::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.parent_id::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.id = :id")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.id = :id")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.address_id = :addressId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByAddressId(@Bind(value="addressId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.address_id = :addressId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByAddressId(@Bind(value="addressId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.address_id = :addressId")
    public long findListByAddressIdCount(@Bind(value="addressId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.address_id = :addressId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByAddressId(@Bind(value="addressId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.classid = :classid")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByClassid(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.classid = :classid")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByClassid(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.classid = :classid")
    public long findListByClassidCount(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.classid = :classid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByClassid(@Bind(value="classid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.code = :code")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.code = :code")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.comment = :comment")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByComment(@Bind(value="comment") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.comment = :comment")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByComment(@Bind(value="comment") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.comment = :comment")
    public long findListByCommentCount(@Bind(value="comment") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.comment = :comment ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByComment(@Bind(value="comment") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayaddress = :displayaddress")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByDisplayaddress(@Bind(value="displayaddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayaddress = :displayaddress")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDisplayaddress(@Bind(value="displayaddress") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.displayaddress = :displayaddress")
    public long findListByDisplayaddressCount(@Bind(value="displayaddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayaddress = :displayaddress ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDisplayaddress(@Bind(value="displayaddress") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayname = :displayname")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByDisplayname(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayname = :displayname")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDisplayname(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.displayname = :displayname")
    public long findListByDisplaynameCount(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayname = :displayname ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDisplayname(@Bind(value="displayname") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayparent = :displayparent")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByDisplayparent(@Bind(value="displayparent") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayparent = :displayparent")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDisplayparent(@Bind(value="displayparent") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.displayparent = :displayparent")
    public long findListByDisplayparentCount(@Bind(value="displayparent") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.displayparent = :displayparent ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDisplayparent(@Bind(value="displayparent") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.district_id = :districtId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByDistrictId(@Bind(value="districtId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.district_id = :districtId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDistrictId(@Bind(value="districtId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.district_id = :districtId")
    public long findListByDistrictIdCount(@Bind(value="districtId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.district_id = :districtId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDistrictId(@Bind(value="districtId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.hidden = :hidden")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByHidden(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.hidden = :hidden")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByHidden(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.hidden = :hidden")
    public long findListByHiddenCount(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.hidden = :hidden ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByHidden(@Bind(value="hidden") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.name = :name")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.name = :name")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.note = :note")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.note = :note")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.objversion = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.objversion = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.parent_id = :parentId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.parent_id = :parentId")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.parent_id = :parentId")
    public long findListByParentIdCount(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.parent_id = :parentId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByParentId(@Bind(value="parentId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.updated = :updated")
    public long findListByUpdatedCount(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.updated = :updated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByUpdated(@Bind(value="updated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public DivisionsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.divisions p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.address_id, p.classid, p.code, p.comment, p.displayaddress, p.displayname, p.displayparent, p.district_id, p.hidden, p.name, p.note, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.divisions p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DivisionsMapper.class)
    public List<DivisionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.divisions (id, uid, abra_id, address_id, classid, code, comment, displayaddress, displayname, displayparent, district_id, hidden, name, note, objversion, parent_id, updated, date_created) VALUES (:id, :uid, :abraId, :addressId, :classid, :code, :comment, :displayaddress, :displayname, :displayparent, :districtId, :hidden, :name, :note, :objversion, :parentId, :updated, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="abraId") String var3, @Bind(value="addressId") String var4, @Bind(value="classid") String var5, @Bind(value="code") String var6, @Bind(value="comment") String var7, @Bind(value="displayaddress") String var8, @Bind(value="displayname") String var9, @Bind(value="displayparent") String var10, @Bind(value="districtId") String var11, @Bind(value="hidden") Boolean var12, @Bind(value="name") String var13, @Bind(value="note") String var14, @Bind(value="objversion") Integer var15, @Bind(value="parentId") String var16, @Bind(value="updated") Date var17, @Bind(value="dateCreated") Date var18);

    @SqlUpdate(value="INSERT INTO abra.divisions (abra_id, address_id, classid, code, comment, displayaddress, displayname, displayparent, district_id, hidden, name, note, objversion, parent_id, updated, date_created) VALUES (:e.abraId, :e.addressId, :e.classid, :e.code, :e.comment, :e.displayaddress, :e.displayname, :e.displayparent, :e.districtId, :e.hidden, :e.name, :e.note, :e.objversion, :e.parentId, :e.updated, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") DivisionsDomain var1);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE address_id = :byAddressId")
    public int updateByAddressId(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byAddressId") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE classid = :byClassid")
    public int updateByClassid(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byClassid") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE comment = :byComment")
    public int updateByComment(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byComment") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE displayaddress = :byDisplayaddress")
    public int updateByDisplayaddress(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byDisplayaddress") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE displayname = :byDisplayname")
    public int updateByDisplayname(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byDisplayname") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE displayparent = :byDisplayparent")
    public int updateByDisplayparent(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byDisplayparent") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE district_id = :byDistrictId")
    public int updateByDistrictId(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byDistrictId") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE hidden = :byHidden")
    public int updateByHidden(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byHidden") Boolean var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE objversion = :byObjversion")
    public int updateByObjversion(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byObjversion") Integer var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE parent_id = :byParentId")
    public int updateByParentId(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byParentId") String var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE updated = :byUpdated")
    public int updateByUpdated(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byUpdated") Date var2);

    @SqlUpdate(value="UPDATE abra.divisions SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, address_id = :e.addressId, classid = :e.classid, code = :e.code, comment = :e.comment, displayaddress = :e.displayaddress, displayname = :e.displayname, displayparent = :e.displayparent, district_id = :e.districtId, hidden = :e.hidden, name = :e.name, note = :e.note, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") DivisionsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE address_id = :addressId")
    public int deleteByAddressId(@Bind(value="addressId") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE classid = :classid")
    public int deleteByClassid(@Bind(value="classid") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE comment = :comment")
    public int deleteByComment(@Bind(value="comment") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE displayaddress = :displayaddress")
    public int deleteByDisplayaddress(@Bind(value="displayaddress") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE displayname = :displayname")
    public int deleteByDisplayname(@Bind(value="displayname") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE displayparent = :displayparent")
    public int deleteByDisplayparent(@Bind(value="displayparent") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE district_id = :districtId")
    public int deleteByDistrictId(@Bind(value="districtId") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE hidden = :hidden")
    public int deleteByHidden(@Bind(value="hidden") Boolean var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE objversion = :objversion")
    public int deleteByObjversion(@Bind(value="objversion") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE parent_id = :parentId")
    public int deleteByParentId(@Bind(value="parentId") String var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE updated = :updated")
    public int deleteByUpdated(@Bind(value="updated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.divisions WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

