/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.abra.configuration;

import cz.airtoy.airshop.abra.configuration.AbraApiSetupItem;
import cz.airtoy.airshop.dao.dbi.AbraApiSetupDbiDao;
import cz.airtoy.airshop.domains.AbraApiSetupDomain;
import cz.airtoy.airshop.domains.AbraCommandsDomain;
import cz.airtoy.airshop.utils.InternalApiCallResponse;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbraApiSetup {
    private static final Logger log = LoggerFactory.getLogger(AbraApiSetup.class);
    private static volatile AbraApiSetup instance = null;
    private static AbraApiSetupDbiDao abraApiSetupDbiDao = null;
    private static List<AbraApiSetupItem> itemList = new ArrayList<AbraApiSetupItem>();

    public AbraApiSetup(AbraApiSetupDbiDao abraApiSetupDbiDao) {
        AbraApiSetup.abraApiSetupDbiDao = abraApiSetupDbiDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbraApiSetup getInstance(AbraApiSetupDbiDao abraApiSetupDbiDao) {
        AbraApiSetup result = instance;
        if (result != null) return result;
        Class<AbraApiSetup> clazz = AbraApiSetup.class;
        synchronized (AbraApiSetup.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new AbraApiSetup(abraApiSetupDbiDao);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public void load() {
        this.loadFromDb();
    }

    public void refresh() {
        this.loadFromDb();
    }

    private void loadFromDb() {
        if (abraApiSetupDbiDao != null) {
            itemList = new ArrayList<AbraApiSetupItem>();
            List<AbraApiSetupDomain> abraApiSetupDomainList = abraApiSetupDbiDao.findListAll();
            if (abraApiSetupDomainList != null) {
                for (AbraApiSetupDomain abraApiSetupDomain : abraApiSetupDomainList) {
                    itemList.add(this.addItemList(abraApiSetupDomain));
                }
            }
        }
    }

    public boolean has(String object, String key) {
        for (AbraApiSetupItem abraApiSetupItem : itemList) {
            if (!abraApiSetupItem.isKey(object, key)) continue;
            return true;
        }
        return false;
    }

    public boolean add(String object, String key, InternalApiCallResponse callResponse, AbraCommandsDomain abraCommandsDomain) {
        if (!this.has(object, key)) {
            AbraApiSetupDomain abraApiSetupDomain = new AbraApiSetupDomain();
            abraApiSetupDomain.setKey(key);
            abraApiSetupDomain.setObject(object);
            abraApiSetupDomain.setCode(callResponse.getAbraApiResponse().getErrorCode() != null ? callResponse.getAbraApiResponse().getErrorCode().toString() : callResponse.getStatusCode().toString());
            abraApiSetupDomain.setValue(null);
            abraApiSetupDomain.setType(null);
            abraApiSetupDomain.setConfig(null);
            abraApiSetupDomain.setReson(callResponse.getAbraApiResponse().getDescription());
            abraApiSetupDomain.setNote("NEW");
            try {
                long id = abraApiSetupDbiDao.insert(abraApiSetupDomain);
                if (id > 0L) {
                    log.info("Successfully inserted AbraApiSetupDomain " + abraApiSetupDomain);
                    itemList.add(this.addItemList(abraApiSetupDomain));
                    return true;
                }
                log.error("Cannot insert AbraApiSetupDomain " + abraApiSetupDomain);
                return false;
            }
            catch (Exception e) {
                log.error("Exception adding AbraApiSetupDomain " + e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    @NotNull
    private AbraApiSetupItem addItemList(AbraApiSetupDomain abraApiSetupDomain) {
        return new AbraApiSetupItem(abraApiSetupDomain);
    }

    public AbraApiSetupItem get(String key) {
        for (AbraApiSetupItem abraApiSetupItem : itemList) {
            if (!abraApiSetupItem.isKey(key)) continue;
            return abraApiSetupItem;
        }
        return null;
    }

    public Object getValue(String key, Object def) {
        Object res = this.getValue(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Object getValue(String key) {
        for (AbraApiSetupItem abraApiSetupItem : itemList) {
            if (!abraApiSetupItem.isKey(key)) continue;
            return abraApiSetupItem.getObject();
        }
        return null;
    }

    public Integer getAsInteger(String key, Integer def) {
        Integer res = this.getAsInteger(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Integer getAsInteger(String key) {
        for (AbraApiSetupItem abraApiSetupItem : itemList) {
            if (!abraApiSetupItem.isKey(key)) continue;
            return abraApiSetupItem.getAsInt();
        }
        return null;
    }

    public Double getAsDouble(String key, Double def) {
        Double res = this.getAsDouble(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Double getAsDouble(String key) {
        for (AbraApiSetupItem abraApiSetupItem : itemList) {
            if (!abraApiSetupItem.isKey(key)) continue;
            return abraApiSetupItem.getAsDouble();
        }
        return null;
    }

    public String getAsString(String key, String def) {
        String res = this.getAsString(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public String getAsString(String key) {
        for (AbraApiSetupItem abraApiSetupItem : itemList) {
            if (!abraApiSetupItem.isKey(key)) continue;
            return abraApiSetupItem.getAsString();
        }
        return null;
    }
}

