/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.integration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cz.airtoy.airshop.domains.FirmsDomain;
import cz.airtoy.airshop.domains.GastroDomain;
import cz.airtoy.airshop.domains.GastroItemsDomain;
import cz.airtoy.airshop.integration.FirmsIntegration;
import cz.airtoy.airshop.integration.GastroItemsIntegration;
import cz.airtoy.airshop.integration.common.BaseIntegration;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GastroIntegration
extends BaseIntegration {
    private static final Logger log = LoggerFactory.getLogger(GastroIntegration.class);

    public static GastroDomain convert(JsonObject data) {
        GastroDomain d = new GastroDomain();
        d.setAbraId(GastroIntegration.getAsString(data, "id"));
        d.setAmount(GastroIntegration.getAsDouble(data, "amount"));
        d.setBusorderId(GastroIntegration.getAsString(data, "busorder_id"));
        d.setBusprojectId(GastroIntegration.getAsString(data, "busproject_id"));
        d.setBustransactionId(GastroIntegration.getAsString(data, "bustransaction_id"));
        d.setCalculated(GastroIntegration.getAsBoolean(data, "calculated"));
        d.setClassid(GastroIntegration.getAsString(data, "classid"));
        d.setCompletedbyId(GastroIntegration.getAsString(data, "completedby_id"));
        d.setDateCompleteddate(GastroIntegration.getAsTimestamp(data, "completeddate$date"));
        d.setCorrectedbyId(GastroIntegration.getAsString(data, "correctedby_id"));
        d.setDateCorrecteddate(GastroIntegration.getAsTimestamp(data, "correcteddate$date"));
        d.setCreatedbyId(GastroIntegration.getAsString(data, "createdby_id"));
        d.setCurrencyId(GastroIntegration.getAsString(data, "currency_id"));
        d.setDescription(GastroIntegration.getAsString(data, "description"));
        d.setDisplayname(GastroIntegration.getAsString(data, "displayname"));
        d.setDivisionId(GastroIntegration.getAsString(data, "division_id"));
        d.setDateDocdate(GastroIntegration.getAsTimestamp(data, "docdate$date"));
        d.setDocqueueId(GastroIntegration.getAsString(data, "docqueue_id"));
        d.setFinallyprice(GastroIntegration.getAsDouble(data, "finallyprice"));
        d.setIncomingtransferId(GastroIntegration.getAsString(data, "incomingtransfer_id"));
        d.setMaterialdistributionId(GastroIntegration.getAsString(data, "materialdistribution_id"));
        d.setDateMaterialdistributiondate(GastroIntegration.getAsTimestamp(data, "materialdistributiondate$date"));
        d.setMaterialinsufficiency(GastroIntegration.getAsInt(data, "materialinsufficiency"));
        d.setNewrelateddocumentId(GastroIntegration.getAsString(data, "newrelateddocument_id"));
        d.setNewrelatedtype(GastroIntegration.getAsInt(data, "newrelatedtype"));
        d.setObjversion(GastroIntegration.getAsInt(data, "objversion"));
        d.setOperatingstoreId(GastroIntegration.getAsString(data, "operatingstore_id"));
        d.setOrdnumber(GastroIntegration.getAsInt(data, "ordnumber"));
        d.setOriginalprice(GastroIntegration.getAsDouble(data, "originalprice"));
        d.setOutgoingtransferId(GastroIntegration.getAsString(data, "outgoingtransfer_id"));
        d.setPeriodId(GastroIntegration.getAsString(data, "period_id"));
        d.setDatePlaneddate(GastroIntegration.getAsTimestamp(data, "planeddate$date"));
        d.setPrice(GastroIntegration.getAsDouble(data, "price"));
        d.setPricestatus(GastroIntegration.getAsInt(data, "pricestatus"));
        d.setProductreceptionId(GastroIntegration.getAsString(data, "productreception_id"));
        d.setRefreshalcopybynorms(GastroIntegration.getAsBoolean(data, "refreshalcopybynorms"));
        d.setSdfirmId(GastroIntegration.getAsString(data, "sdfirm_id"));
        d.setStatus(GastroIntegration.getAsInt(data, "status"));
        d.setStoreId(GastroIntegration.getAsString(data, "store_id"));
        d.setWarnings(GastroIntegration.getAsString(data, "warnings"));
        return d;
    }

    public static GastroDomain convertComplete(JsonObject data) {
        JsonArray rowsAsJsonArray;
        GastroDomain d = new GastroDomain();
        d.setAbraId(GastroIntegration.getAsString(data, "id"));
        d.setAmount(GastroIntegration.getAsDouble(data, "amount"));
        d.setBusorderId(GastroIntegration.getAsString(data, "busorder_id"));
        d.setBusprojectId(GastroIntegration.getAsString(data, "busproject_id"));
        d.setBustransactionId(GastroIntegration.getAsString(data, "bustransaction_id"));
        d.setCalculated(GastroIntegration.getAsBoolean(data, "calculated"));
        d.setClassid(GastroIntegration.getAsString(data, "classid"));
        d.setCompletedbyId(GastroIntegration.getAsString(data, "completedby_id"));
        d.setDateCompleteddate(GastroIntegration.getAsTimestamp(data, "completeddate$date"));
        d.setCorrectedbyId(GastroIntegration.getAsString(data, "correctedby_id"));
        d.setDateCorrecteddate(GastroIntegration.getAsTimestamp(data, "correcteddate$date"));
        d.setCreatedbyId(GastroIntegration.getAsString(data, "createdby_id"));
        d.setCurrencyId(GastroIntegration.getAsString(data, "currency_id"));
        d.setDescription(GastroIntegration.getAsString(data, "description"));
        d.setDisplayname(GastroIntegration.getAsString(data, "displayname"));
        d.setDivisionId(GastroIntegration.getAsString(data, "division_id"));
        d.setDateDocdate(GastroIntegration.getAsTimestamp(data, "docdate$date"));
        d.setDocqueueId(GastroIntegration.getAsString(data, "docqueue_id"));
        d.setFinallyprice(GastroIntegration.getAsDouble(data, "finallyprice"));
        d.setIncomingtransferId(GastroIntegration.getAsString(data, "incomingtransfer_id"));
        d.setMaterialdistributionId(GastroIntegration.getAsString(data, "materialdistribution_id"));
        d.setDateMaterialdistributiondate(GastroIntegration.getAsTimestamp(data, "materialdistributiondate$date"));
        d.setMaterialinsufficiency(GastroIntegration.getAsInt(data, "materialinsufficiency"));
        d.setNewrelateddocumentId(GastroIntegration.getAsString(data, "newrelateddocument_id"));
        d.setNewrelatedtype(GastroIntegration.getAsInt(data, "newrelatedtype"));
        d.setObjversion(GastroIntegration.getAsInt(data, "objversion"));
        d.setOperatingstoreId(GastroIntegration.getAsString(data, "operatingstore_id"));
        d.setOrdnumber(GastroIntegration.getAsInt(data, "ordnumber"));
        d.setOriginalprice(GastroIntegration.getAsDouble(data, "originalprice"));
        d.setOutgoingtransferId(GastroIntegration.getAsString(data, "outgoingtransfer_id"));
        d.setPeriodId(GastroIntegration.getAsString(data, "period_id"));
        d.setDatePlaneddate(GastroIntegration.getAsTimestamp(data, "planeddate$date"));
        d.setPrice(GastroIntegration.getAsDouble(data, "price"));
        d.setPricestatus(GastroIntegration.getAsInt(data, "pricestatus"));
        d.setProductreceptionId(GastroIntegration.getAsString(data, "productreception_id"));
        d.setRefreshalcopybynorms(GastroIntegration.getAsBoolean(data, "refreshalcopybynorms"));
        d.setSdfirmId(GastroIntegration.getAsString(data, "sdfirm_id"));
        try {
            d.setSdfirmId(GastroIntegration.getAsString(data, "sdfirm_id"));
            FirmsDomain firmId = FirmsIntegration.convertFromOrder("sdfirm_id", data);
            d.setSdfirm(firmId);
        }
        catch (Exception e) {
            d.setSdfirmId(GastroIntegration.getAsString(data, "sdfirm_id"));
        }
        d.setStatus(GastroIntegration.getAsInt(data, "status"));
        d.setStoreId(GastroIntegration.getAsString(data, "store_id"));
        d.setWarnings(GastroIntegration.getAsString(data, "warnings"));
        d.setRows(new ArrayList<GastroItemsDomain>());
        JsonElement rows = data.get("rows");
        if (rows != null && (rowsAsJsonArray = rows.getAsJsonArray()) != null) {
            for (JsonElement jsonElement : rowsAsJsonArray) {
                JsonObject obj = jsonElement.getAsJsonObject();
                d.getRows().add(GastroItemsIntegration.convert(obj));
            }
        }
        return d;
    }
}

