/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.app;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.app.TranslationsDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationsDomainCodec
implements MessageCodec<TranslationsDomain, TranslationsDomain> {
    private static final Logger log = LoggerFactory.getLogger(TranslationsDomainCodec.class);

    public void encodeToWire(Buffer buffer, TranslationsDomain translationsDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)translationsDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public TranslationsDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (TranslationsDomain)gson.fromJson(jsonStr, TranslationsDomain.class);
    }

    public TranslationsDomain transform(TranslationsDomain translationsDomain) {
        return translationsDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

