/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.shops;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.shops.ShopsMapper;
import cz.airtoy.airshop.domains.shops.ShopsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ShopsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.code,\n\t\tp.name,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tshops.shops p\n\t\n\t\tWHERE \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tshops.shops p\n\t\n\t\tWHERE \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  ")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListAll();

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.code = :code")
    @RegisterRowMapper(value=ShopsMapper.class)
    public ShopsDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.code = :code")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.shops p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.name = :name")
    @RegisterRowMapper(value=ShopsMapper.class)
    public ShopsDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.name = :name")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.shops p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ShopsMapper.class)
    public ShopsDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.shops p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=ShopsMapper.class)
    public ShopsDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.shops p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.note = :note")
    @RegisterRowMapper(value=ShopsMapper.class)
    public ShopsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.note = :note")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.shops p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ShopsMapper.class)
    public ShopsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.shops p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.code, p.name, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.shops p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ShopsMapper.class)
    public List<ShopsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO shops.shops (code, name, date_changed, user_changed, note, date_created) VALUES (:code, :name, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public int insert(@Bind(value="code") String var1, @Bind(value="name") String var2, @Bind(value="dateChanged") Date var3, @Bind(value="userChanged") String var4, @Bind(value="note") String var5, @Bind(value="dateCreated") Date var6);

    @SqlUpdate(value="INSERT INTO shops.shops (code, name, date_changed, user_changed, note, date_created) VALUES (:e.code, :e.name, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public int insert(@BindBean(value="e") ShopsDomain var1);

    @SqlUpdate(value="UPDATE shops.shops SET code = :e.code, name = :e.name, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") ShopsDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE shops.shops SET code = :e.code, name = :e.name, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") ShopsDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE shops.shops SET code = :e.code, name = :e.name, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") ShopsDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE shops.shops SET code = :e.code, name = :e.name, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") ShopsDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE shops.shops SET code = :e.code, name = :e.name, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") ShopsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE shops.shops SET code = :e.code, name = :e.name, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ShopsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM shops.shops WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM shops.shops WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM shops.shops WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM shops.shops WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM shops.shops WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM shops.shops WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

