/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.TargetCommodityMapper;
import cz.airtoy.airshop.dao.mappers.data.full.TargetCommodityFullMapper;
import cz.airtoy.airshop.dao.mappers.data.full.TargetCommodityRentalMapper;
import cz.airtoy.airshop.domains.data.TargetCommodityDomain;
import cz.airtoy.airshop.domains.data.full.TargetCommodityRentalDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TargetCommodityDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tp.manufacturer_id,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.commodity_keg_size_id,\n\t\tp.price_amount_purchase_retail,\n\t\tp.price_amount_purchase_wholesale,\n\t\tp.price_amount_sale_retail,\n\t\tp.price_amount_sale_wholesale,\n\t\tp.volume,\n\t\tp.on_order,\n\t\tp.date_order,\n\t\tp.date_delivery,\n\t\tp.auto_prolong,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.target_commodity p\n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.commodity_keg_size_id::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="disabled") String var2, @Bind(value="offset") int var3, @Bind(value="limit") int var4, @Define(value="order") String var5, @Define(value="sort") String var6);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_commodity p\n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.commodity_keg_size_id::text ~* :mask \n\tOR \n\t\tp.price_amount_purchase_retail::text ~* :mask \n\tOR \n\t\tp.price_amount_purchase_wholesale::text ~* :mask \n\tOR \n\t\tp.price_amount_sale_retail::text ~* :mask \n\tOR \n\t\tp.price_amount_sale_wholesale::text ~* :mask \n\tOR \n\t\tp.volume::text ~* :mask \n\tOR \n\t\tp.on_order::text ~* :mask \n\tOR \n\t\tp.date_order::text ~* :mask \n\tOR \n\t\tp.date_delivery::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1, @Bind(value="disabled") String var2);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\tp.disabled,\n\t\trp.ord,\n\t\tp.manufacturer_id,\n\t\tmf.name as manufacturer,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.commodity_keg_size_id,\n\t\tp.price_amount_purchase_retail,\n\t\tp.price_amount_purchase_wholesale,\n\t\tp.price_amount_sale_retail,\n\t\tp.price_amount_sale_wholesale,\n\t\tp.volume,\n\t\tp.on_order,\n\t\tp.date_order,\n\t\tp.date_delivery,\n\t\tp.auto_prolong,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t\trp.cnt,\n\t\trp.deposit_amount\n FROM \n\t\tdata.target_commodity p\n\t\tINNER JOIN renting.rental_portfolio rp ON (p.id = rp.target_commodity_id) \n   LEFT OUTER JOIN data.manufacturer mf ON (mf.id = p.manufacturer_id) \n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.commodity_keg_size_id::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetCommodityRentalMapper.class)
    public List<TargetCommodityRentalDomain> findByMaskForRental(@Bind(value="mask") String var1, @Bind(value="disabled") String var2, @Bind(value="offset") int var3, @Bind(value="limit") int var4, @Define(value="order") String var5, @Define(value="sort") String var6);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_commodity p\n\t\tINNER JOIN renting.rental_portfolio rp ON (p.id = rp.target_commodity_id) \n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.commodity_keg_size_id::text ~* :mask \n\tOR \n\t\tp.price_amount_purchase_retail::text ~* :mask \n\tOR \n\t\tp.price_amount_purchase_wholesale::text ~* :mask \n\tOR \n\t\tp.price_amount_sale_retail::text ~* :mask \n\tOR \n\t\tp.price_amount_sale_wholesale::text ~* :mask \n\tOR \n\t\tp.volume::text ~* :mask \n\tOR \n\t\tp.on_order::text ~* :mask \n\tOR \n\t\tp.date_order::text ~* :mask \n\tOR \n\t\tp.date_delivery::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\n")
    public long findByMaskForRentalCount(@Bind(value="mask") String var1, @Bind(value="disabled") String var2);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\ttct.disabled,\n\t\tp.ord,\n\t\tp.manufacturer_id,\n\t\tmf.name as manufacturer,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.commodity_keg_size_id,\n\t\tp.price_amount_purchase_retail,\n\t\tp.price_amount_purchase_wholesale,\n\t\tp.price_amount_sale_retail,\n\t\tp.price_amount_sale_wholesale,\n\t\tp.volume,\n\t\tp.on_order,\n\t\tp.date_order,\n\t\tp.date_delivery,\n\t\tp.auto_prolong,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t\tsc.abra_alkohol,\n\t\tsc.abra_plato,\n\t\tsc.abra_objemlitry,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcvfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t                dcv.id,\n\t            \t  dcv.uid,\n\t            \t  dcv.target_commodity_id AS \"targetCommodityId\",\n\t            \t  dcv.manufacturer_id as \"manufacturerId\",\n\t            \t  dcv.vat,\n\t            \t  dcv.language_name AS \"languageName\",\n\t            \t  dcv.name,\n\t            \t  dcv.alternative_name AS \"alternativeName\",\n\t            \t  dcv.annotation,\n\t            \t  dcv.description,\n\t            \t  dcv.meta_title AS \"metaTitle\",\n\t            \t  dcv.meta_description AS \"metaDescription\",\n\t            \t  dcv.meta_key_words AS \"metaKeyWords\",\n\t            \t  dcv.path,\n\t            \t  dcv.date_updated AS \"dateUpdated\",\n\t            \t  dcv.note,\n\t            \t  dcv.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_commodity_variant dcv\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcv.target_commodity_id = p.id\n        \t\t\t\t\t) dcvfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS variants,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n             \t  dc.id,\n             \t\tdc.uid,\n             \t\tdc.source,\n             \t\tdc.disabled,\n             \t\tdc.ord,\n             \t\tdc.external_record_id AS \"externalRecordId\",\n             \t\tdc.external_record_parent_id AS \"externalRecordParentId\",\n             \t\tdc.mall_id AS \"mallId\",\n             \t\tdc.language_name AS \"languageName\",\n             \t\tdc.parent_category_id AS \"parentCategoryId\",\n             \t\tdc.depth,\n             \t\tdc.ident,\n             \t\tdc.name,\n             \t\tdc.alternative_name AS \"alternativeName\",\n             \t\tdc.description,\n             \t\tdc.alternative_description AS \"alternativeDescription\",\n             \t\tdc.rank,\n             \t\tdc.meta_title AS \"metaTitle\",\n             \t\tdc.meta_description AS \"metaDescription\",\n             \t\tdc.meta_key_words AS \"metaKeyWords\",\n             \t\tdc.enabled,\n             \t\tdc.date_updated AS \"dateUpdated\",\n             \t\tdc.note,\n             \t\tdc.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_category dc\n\t\t              JOIN data.target_commodity_category dcc ON (dc.id = dcc.target_category_id)\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcc.target_commodity_id = p.id\n        \t\t\t\t\t) dcfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS categories\n FROM \n\t\tdata.target_commodity p\n\t\tJOIN data.target_commodity_target tct ON (tct.target_commodity_id = p.id) \n LEFT OUTER JOIN data.target_commodity_category cc ON (cc.target_commodity_id = p.id)  LEFT OUTER JOIN abra.store_cards sc ON (sc.code = (CASE WHEN LENGTH(p.plu) = 6 THEN RIGHT(p.plu, 4) ELSE p.plu END))  LEFT OUTER JOIN data.manufacturer mf ON (mf.id = p.manufacturer_id) \n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( tct.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND \t  (CASE WHEN :onOrder = '-1' THEN TRUE ELSE p.on_order = :onOrder END) \n AND \t  (CASE WHEN :categoryId = '-1' THEN TRUE ELSE cc.target_category_id = :categoryId END) \n AND    tct.target_id = :targetId  AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetCommodityFullMapper.class)
    public List<TargetCommodityDomain> findByTargetIdMask(@Bind(value="targetId") Long var1, @Bind(value="mask") String var2, @Bind(value="disabled") String var3, @Bind(value="onOrder") Integer var4, @Bind(value="categoryId") Long var5, @Bind(value="offset") int var6, @Bind(value="limit") int var7, @Define(value="order") String var8, @Define(value="sort") String var9);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_commodity p\n\t\tJOIN data.target_commodity_target tct ON (tct.target_commodity_id = p.id) \n   LEFT OUTER JOIN data.target_commodity_category cc ON (cc.target_commodity_id = p.id) \t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND \t  (CASE WHEN :onOrder = '-1' THEN TRUE ELSE p.on_order = :onOrder END) \n AND \t  (CASE WHEN :categoryId = '-1' THEN TRUE ELSE cc.target_category_id = :categoryId END) \n AND    tct.target_id = :targetId  AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n ) \n")
    public long findByTargetIdMaskCount(@Bind(value="targetId") Long var1, @Bind(value="mask") String var2, @Bind(value="disabled") String var3, @Bind(value="onOrder") Integer var4, @Bind(value="categoryId") Long var5);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\ttct.disabled,\n\t\tp.ord,\n\t\tp.manufacturer_id,\n\t\tmf.name as manufacturer,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.commodity_keg_size_id,\n\t\tp.price_amount_purchase_retail,\n\t\tp.price_amount_purchase_wholesale,\n\t\tp.price_amount_sale_retail,\n\t\tp.price_amount_sale_wholesale,\n\t\tp.volume,\n\t\tp.on_order,\n\t\tp.date_order,\n\t\tp.date_delivery,\n\t\tp.auto_prolong,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t\tsc.abra_alkohol,\n\t\tsc.abra_plato,\n\t\tsc.abra_objemlitry,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcvfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t                dcv.id,\n\t            \t  dcv.uid,\n\t            \t  dcv.target_commodity_id AS \"targetCommodityId\",\n\t            \t  dcv.manufacturer_id as \"manufacturerId\",\n\t            \t  dcv.vat,\n\t            \t  dcv.language_name AS \"languageName\",\n\t            \t  dcv.name,\n\t            \t  dcv.alternative_name AS \"alternativeName\",\n\t            \t  dcv.annotation,\n\t            \t  dcv.description,\n\t            \t  dcv.meta_title AS \"metaTitle\",\n\t            \t  dcv.meta_description AS \"metaDescription\",\n\t            \t  dcv.meta_key_words AS \"metaKeyWords\",\n\t            \t  dcv.path,\n\t            \t  dcv.date_updated AS \"dateUpdated\",\n\t            \t  dcv.note,\n\t            \t  dcv.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_commodity_variant dcv\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcv.target_commodity_id = p.id\n        \t\t\t\t\t) dcvfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS variants,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n             \t  dc.id,\n             \t\tdc.uid,\n             \t\tdc.source,\n             \t\tdc.disabled,\n             \t\tdc.ord,\n             \t\tdc.external_record_id AS \"externalRecordId\",\n             \t\tdc.external_record_parent_id AS \"externalRecordParentId\",\n             \t\tdc.mall_id AS \"mallId\",\n             \t\tdc.language_name AS \"languageName\",\n             \t\tdc.parent_category_id AS \"parentCategoryId\",\n             \t\tdc.depth,\n             \t\tdc.ident,\n             \t\tdc.name,\n             \t\tdc.alternative_name AS \"alternativeName\",\n             \t\tdc.description,\n             \t\tdc.alternative_description AS \"alternativeDescription\",\n             \t\tdc.rank,\n             \t\tdc.meta_title AS \"metaTitle\",\n             \t\tdc.meta_description AS \"metaDescription\",\n             \t\tdc.meta_key_words AS \"metaKeyWords\",\n             \t\tdc.enabled,\n             \t\tdc.date_updated AS \"dateUpdated\",\n             \t\tdc.note,\n             \t\tdc.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_category dc\n\t\t              JOIN data.target_commodity_category dcc ON (dc.id = dcc.target_category_id)\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcc.target_commodity_id = p.id\n        \t\t\t\t\t) dcfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS categories\n FROM \n\t\tdata.target_commodity p\n\t\tJOIN data.target_commodity_target tct ON (tct.target_commodity_id = p.id) \n   LEFT OUTER JOIN data.target_commodity_category cc ON (cc.target_commodity_id = p.id)    LEFT OUTER JOIN abra.store_cards sc ON (sc.code = (CASE WHEN LENGTH(p.plu) = 6 THEN RIGHT(p.plu, 4) ELSE p.plu END))    LEFT OUTER JOIN data.manufacturer mf ON (mf.id = p.manufacturer_id) \n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( tct.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND \t  (CASE WHEN :onOrder = 'ALL' THEN TRUE ELSE ( p.on_order = (CASE WHEN :onOrder = '1' THEN 1 ELSE 0 END) ) END) \n AND    tct.target_id = :targetId  AND    p.manufacturer_id = :manufacturerId  AND    cc.target_category_id = :categoryId  AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetCommodityFullMapper.class)
    public List<TargetCommodityDomain> findByTargetManufacturerCategoryIdMask(@Bind(value="targetId") Long var1, @Bind(value="manufacturerId") Long var2, @Bind(value="categoryId") Long var3, @Bind(value="mask") String var4, @Bind(value="disabled") String var5, @Bind(value="onOrder") String var6, @Bind(value="offset") int var7, @Bind(value="limit") int var8, @Define(value="order") String var9, @Define(value="sort") String var10);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_commodity p\n\t\tJOIN data.target_commodity_target tct ON (tct.target_commodity_id = p.id) \n   LEFT OUTER JOIN data.target_commodity_category cc ON (cc.target_commodity_id = p.id) \t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND \t  (CASE WHEN :onOrder = 'ALL' THEN TRUE ELSE ( p.on_order = (CASE WHEN :onOrder = '1' THEN 1 ELSE 0 END) ) END) \n AND    tct.target_id = :targetId  AND    p.manufacturer_id = :manufacturerId  AND    cc.target_category_id = :categoryId  AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n ) \n")
    public long findByTargetManufacturerCategoryIdMaskCount(@Bind(value="targetId") Long var1, @Bind(value="manufacturerId") Long var2, @Bind(value="categoryId") Long var3, @Bind(value="mask") String var4, @Bind(value="disabled") String var5, @Bind(value="onOrder") String var6);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  ")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT \t  p.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tmf.name as manufacturer,\n\t\tp.manufacturer_id,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.commodity_keg_size_id,\n\t\tp.price_amount_purchase_retail,\n\t\tp.price_amount_purchase_wholesale,\n\t\tp.price_amount_sale_retail,\n\t\tp.price_amount_sale_wholesale,\n\t\tp.volume,\n\t\tp.on_order,\n\t\tp.date_order,\n\t\tp.date_delivery,\n\t\tp.auto_prolong,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t\tsc.abra_alkohol,\n\t\tsc.abra_plato,\n\t\tsc.abra_objemlitry,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcvfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t                dcv.id,\n\t            \t  dcv.uid,\n\t            \t  dcv.target_commodity_id AS \"targetCommodityId\",\n\t            \t  dcv.manufacturer_id as \"manufacturerId\",\n\t            \t  dcv.vat,\n\t            \t  dcv.language_name AS \"languageName\",\n\t            \t  dcv.name,\n\t            \t  dcv.alternative_name AS \"alternativeName\",\n\t            \t  dcv.annotation,\n\t            \t  dcv.description,\n\t            \t  dcv.meta_title AS \"metaTitle\",\n\t            \t  dcv.meta_description AS \"metaDescription\",\n\t            \t  dcv.meta_key_words AS \"metaKeyWords\",\n\t            \t  dcv.path,\n\t            \t  dcv.date_updated AS \"dateUpdated\",\n\t            \t  dcv.note,\n\t            \t  dcv.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_commodity_variant dcv\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcv.target_commodity_id = p.id\n        \t\t\t\t\t) dcvfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS variants,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n             \t  dc.id,\n             \t\tdc.uid,\n             \t\tdc.source,\n             \t\tdc.disabled,\n             \t\tdc.ord,\n             \t\tdc.external_record_id AS \"externalRecordId\",\n             \t\tdc.external_record_parent_id AS \"externalRecordParentId\",\n             \t\tdc.mall_id AS \"mallId\",\n             \t\tdc.language_name AS \"languageName\",\n             \t\tdc.parent_category_id AS \"parentCategoryId\",\n             \t\tdc.depth,\n             \t\tdc.ident,\n             \t\tdc.name,\n             \t\tdc.alternative_name AS \"alternativeName\",\n             \t\tdc.description,\n             \t\tdc.alternative_description AS \"alternativeDescription\",\n             \t\tdc.rank,\n             \t\tdc.meta_title AS \"metaTitle\",\n             \t\tdc.meta_description AS \"metaDescription\",\n             \t\tdc.meta_key_words AS \"metaKeyWords\",\n             \t\tdc.enabled,\n             \t\tdc.date_updated AS \"dateUpdated\",\n             \t\tdc.note,\n             \t\tdc.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_category dc\n\t\t              JOIN data.target_commodity_category dcc ON (dc.id = dcc.target_category_id)\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcc.target_commodity_id = p.id\n        \t\t\t\t\t) dcfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS categories\n FROM data.target_commodity p \n LEFT OUTER JOIN abra.store_cards sc ON (sc.code = (CASE WHEN LENGTH(p.plu) = 6 THEN RIGHT(p.plu, 4) ELSE p.plu END))  LEFT OUTER JOIN data.manufacturer mf ON (mf.id = p.manufacturer_id) \n WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCommodityFullMapper.class)
    public TargetCommodityDomain findByIdFull(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT  p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created  FROM data.target_commodity p  JOIN data.target_commodity_category cc ON (cc.target_commodity_id = p.id)  WHERE cc.target_category_id = :targetCategoryId AND \t  (CASE WHEN :onOrder = '-1' THEN TRUE ELSE p.on_order = :onOrder END) ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByTargetCategoryId(@Bind(value="targetCategoryId") Long var1, @Bind(value="onOrder") Integer var2, @Bind(value="offset") int var3, @Bind(value="limit") int var4, @Define(value="order") String var5, @Define(value="sort") String var6);

    @SqlQuery(value="SELECT \t  p.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tmf.name as manufacturer,\n\t\tp.manufacturer_id,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.commodity_keg_size_id,\n\t\tp.price_amount_purchase_retail,\n\t\tp.price_amount_purchase_wholesale,\n\t\tp.price_amount_sale_retail,\n\t\tp.price_amount_sale_wholesale,\n\t\tp.volume,\n\t\tp.on_order,\n\t\tp.date_order,\n\t\tp.date_delivery,\n\t\tp.auto_prolong,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t\tsc.abra_alkohol,\n\t\tsc.abra_plato,\n\t\tsc.abra_objemlitry,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcvfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t                dcv.id,\n\t            \t  dcv.uid,\n\t            \t  dcv.target_commodity_id AS \"targetCommodityId\",\n\t            \t  dcv.manufacturer_id as \"manufacturerId\",\n\t            \t  dcv.vat,\n\t            \t  dcv.language_name AS \"languageName\",\n\t            \t  dcv.name,\n\t            \t  dcv.alternative_name AS \"alternativeName\",\n\t            \t  dcv.annotation,\n\t            \t  dcv.description,\n\t            \t  dcv.meta_title AS \"metaTitle\",\n\t            \t  dcv.meta_description AS \"metaDescription\",\n\t            \t  dcv.meta_key_words AS \"metaKeyWords\",\n\t            \t  dcv.path,\n\t            \t  dcv.date_updated AS \"dateUpdated\",\n\t            \t  dcv.note,\n\t            \t  dcv.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_commodity_variant dcv\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcv.target_commodity_id = p.id\n        \t\t\t\t\t) dcvfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS variants,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n             \t  dc.id,\n             \t\tdc.uid,\n             \t\tdc.source,\n             \t\tdc.disabled,\n             \t\tdc.ord,\n             \t\tdc.external_record_id AS \"externalRecordId\",\n             \t\tdc.external_record_parent_id AS \"externalRecordParentId\",\n             \t\tdc.mall_id AS \"mallId\",\n             \t\tdc.language_name AS \"languageName\",\n             \t\tdc.parent_category_id AS \"parentCategoryId\",\n             \t\tdc.depth,\n             \t\tdc.ident,\n             \t\tdc.name,\n             \t\tdc.alternative_name AS \"alternativeName\",\n             \t\tdc.description,\n             \t\tdc.alternative_description AS \"alternativeDescription\",\n             \t\tdc.rank,\n             \t\tdc.meta_title AS \"metaTitle\",\n             \t\tdc.meta_description AS \"metaDescription\",\n             \t\tdc.meta_key_words AS \"metaKeyWords\",\n             \t\tdc.enabled,\n             \t\tdc.date_updated AS \"dateUpdated\",\n             \t\tdc.note,\n             \t\tdc.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.target_category dc\n\t\t              JOIN data.target_commodity_category dcc ON (dc.id = dcc.target_category_id)\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcc.target_commodity_id = p.id\n        \t\t\t\t\t) dcfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS categories\n FROM data.target_commodity p  JOIN data.target_commodity_category cc ON (cc.target_commodity_id = p.id)  LEFT OUTER JOIN abra.store_cards sc ON (sc.code = (CASE WHEN LENGTH(p.plu) = 6 THEN RIGHT(p.plu, 4) ELSE p.plu END))  LEFT OUTER JOIN data.manufacturer mf ON (mf.id = p.manufacturer_id) \n WHERE cc.target_category_id = :targetCategoryId AND \t  (CASE WHEN :onOrder = '-1' THEN TRUE ELSE p.on_order = :onOrder END) \n ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityFullMapper.class)
    public List<TargetCommodityDomain> findListByTargetCategoryIdFull(@Bind(value="targetCategoryId") Long var1, @Bind(value="onOrder") Integer var2, @Bind(value="offset") int var3, @Bind(value="limit") int var4, @Define(value="order") String var5, @Define(value="sort") String var6);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  JOIN data.target_commodity_category cc ON (cc.target_commodity_id = p.id)  WHERE cc.target_category_id = :targetCategoryId AND \t  (CASE WHEN :onOrder = '-1' THEN TRUE ELSE p.on_order = :onOrder END) \n")
    public long findListByTargetCategoryIdCount(@Bind(value="targetCategoryId") Long var1, @Bind(value="onOrder") Integer var2);

    @SqlUpdate(value="UPDATE data.target_commodity_target SET disabled = 1 WHERE target_commodity_id IN (SELECT id FROM data.target_commodity WHERE on_order = 1 AND date_order IS NOT NULL AND date_order < NOW()) AND disabled = 0 AND target_id = 4")
    public int dataTargetCommodityDisabledPassDateOrderPass();

    @SqlUpdate(value="UPDATE data.target_commodity SET date_order = date_order + COALESCE( auto_prolong, 0) * INTERVAL '1 day', date_delivery = COALESCE(date_delivery, NOW()) + COALESCE( auto_prolong, 0) * INTERVAL '1 day' WHERE auto_prolong IS NOT NULL AND auto_prolong > 0 AND on_order = 1 AND date_order IS NOT NULL AND date_order < NOW() AND disabled = 0 AND id IN( SELECT target_commodity_id FROM data.target_commodity_target WHERE target_id = 4)")
    public int dataTargetCommodityAutoProlong();

    @SqlUpdate(value="UPDATE data.target_commodity SET disabled = 1, on_order = 0 WHERE on_order = 1 AND date_order IS NOT NULL AND date_order < NOW() AND disabled = 0 AND id IN( SELECT target_commodity_id FROM data.target_commodity_target WHERE target_id = 4)")
    public int dataTargetCommodityDisabledPassDateOrderPass1();

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.source = :source")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.source = :source")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.code = :code")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.code = :code")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.shipping_weight = :shippingWeight")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByShippingWeight(@Bind(value="shippingWeight") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.shipping_weight = :shippingWeight")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByShippingWeight(@Bind(value="shippingWeight") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.shipping_weight = :shippingWeight")
    public long findListByShippingWeightCount(@Bind(value="shippingWeight") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.shipping_weight = :shippingWeight ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByShippingWeight(@Bind(value="shippingWeight") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_record_id = :externalRecordId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_record_id = :externalRecordId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.external_record_id = :externalRecordId")
    public long findListByExternalRecordIdCount(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_record_id = :externalRecordId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByExternalRecordId(@Bind(value="externalRecordId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.disabled = :disabled")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByDisabled(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.disabled = :disabled")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDisabled(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.disabled = :disabled")
    public long findListByDisabledCount(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.disabled = :disabled ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDisabled(@Bind(value="disabled") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.manufacturer_id = :manufacturerId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByManufacturer(@Bind(value="manufacturerId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.manufacturer_id = :manufacturerId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByManufacturer(@Bind(value="manufacturerId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.manufacturer_id = :manufacturerId")
    public long findListByEanCount(@Bind(value="manufacturerId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.manufacturer_id = :manufacturerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByManufacturer(@Bind(value="manufacturerId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId")
    public long findListByExternalStockAvailabilityIdCount(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_charge_id = :externalChargeId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByExternalChargeId(@Bind(value="externalChargeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_charge_id = :externalChargeId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByExternalChargeId(@Bind(value="externalChargeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.external_charge_id = :externalChargeId")
    public long findListByExternalChargeIdCount(@Bind(value="externalChargeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.external_charge_id = :externalChargeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByExternalChargeId(@Bind(value="externalChargeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.vat = :vat")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByVat(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.vat = :vat")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByVat(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.vat = :vat")
    public long findListByVatCount(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.vat = :vat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByVat(@Bind(value="vat") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.alternative_name = :alternativeName")
    public long findListByAlternativeNameCount(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.alternative_name = :alternativeName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.annotation = :annotation")
    public long findListByAnnotationCount(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.annotation = :annotation ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByAnnotation(@Bind(value="annotation") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.description = :description")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.description = :description")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.meta_title = :metaTitle")
    public long findListByMetaTitleCount(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_title = :metaTitle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.meta_description = :metaDescription")
    public long findListByMetaDescriptionCount(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_description = :metaDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.meta_key_words = :metaKeyWords")
    public long findListByMetaKeyWordsCount(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.meta_key_words = :metaKeyWords ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.path = :path")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.path = :path")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.path = :path")
    public long findListByPathCount(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.path = :path ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPath(@Bind(value="path") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.enabled = :enabled")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByEnabled(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.enabled = :enabled")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByEnabled(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.enabled = :enabled")
    public long findListByEnabledCount(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.enabled = :enabled ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByEnabled(@Bind(value="enabled") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.commodity_keg_size_id = :commodityKegSizeId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByCommodityKegSizeId(@Bind(value="commodityKegSizeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.commodity_keg_size_id = :commodityKegSizeId")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByCommodityKegSizeId(@Bind(value="commodityKegSizeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.commodity_keg_size_id = :commodityKegSizeId")
    public long findListByCommodityKegSizeIdCount(@Bind(value="commodityKegSizeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.commodity_keg_size_id = :commodityKegSizeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByCommodityKegSizeId(@Bind(value="commodityKegSizeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_purchase_retail = :priceAmountPurchaseRetail")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByPriceAmountPurchaseRetail(@Bind(value="priceAmountPurchaseRetail") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_purchase_retail = :priceAmountPurchaseRetail")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountPurchaseRetail(@Bind(value="priceAmountPurchaseRetail") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.price_amount_purchase_retail = :priceAmountPurchaseRetail")
    public long findListByPriceAmountPurchaseRetailCount(@Bind(value="priceAmountPurchaseRetail") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_purchase_retail = :priceAmountPurchaseRetail ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountPurchaseRetail(@Bind(value="priceAmountPurchaseRetail") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_purchase_wholesale = :priceAmountPurchaseWholesale")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByPriceAmountPurchaseWholesale(@Bind(value="priceAmountPurchaseWholesale") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_purchase_wholesale = :priceAmountPurchaseWholesale")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountPurchaseWholesale(@Bind(value="priceAmountPurchaseWholesale") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.price_amount_purchase_wholesale = :priceAmountPurchaseWholesale")
    public long findListByPriceAmountPurchaseWholesaleCount(@Bind(value="priceAmountPurchaseWholesale") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_purchase_wholesale = :priceAmountPurchaseWholesale ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountPurchaseWholesale(@Bind(value="priceAmountPurchaseWholesale") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_sale_retail = :priceAmountSaleRetail")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByPriceAmountSaleRetail(@Bind(value="priceAmountSaleRetail") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_sale_retail = :priceAmountSaleRetail")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountSaleRetail(@Bind(value="priceAmountSaleRetail") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.price_amount_sale_retail = :priceAmountSaleRetail")
    public long findListByPriceAmountSaleRetailCount(@Bind(value="priceAmountSaleRetail") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_sale_retail = :priceAmountSaleRetail ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountSaleRetail(@Bind(value="priceAmountSaleRetail") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_sale_wholesale = :priceAmountSaleWholesale")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByPriceAmountSaleWholesale(@Bind(value="priceAmountSaleWholesale") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_sale_wholesale = :priceAmountSaleWholesale")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountSaleWholesale(@Bind(value="priceAmountSaleWholesale") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.price_amount_sale_wholesale = :priceAmountSaleWholesale")
    public long findListByPriceAmountSaleWholesaleCount(@Bind(value="priceAmountSaleWholesale") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.price_amount_sale_wholesale = :priceAmountSaleWholesale ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByPriceAmountSaleWholesale(@Bind(value="priceAmountSaleWholesale") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.volume = :volume")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByVolume(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.volume = :volume")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByVolume(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.volume = :volume")
    public long findListByVolumeCount(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.volume = :volume ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByVolume(@Bind(value="volume") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.on_order = :onOrder")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByOnOrder(@Bind(value="onOrder") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.on_order = :onOrder")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByOnOrder(@Bind(value="onOrder") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.on_order = :onOrder")
    public long findListByOnOrderCount(@Bind(value="onOrder") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.on_order = :onOrder ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByOnOrder(@Bind(value="onOrder") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_order = :dateOrder")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByDateOrder(@Bind(value="dateOrder") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_order = :dateOrder")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateOrder(@Bind(value="dateOrder") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.date_order = :dateOrder")
    public long findListByDateOrderCount(@Bind(value="dateOrder") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_order = :dateOrder ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateOrder(@Bind(value="dateOrder") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_delivery = :dateDelivery")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByDateDelivery(@Bind(value="dateDelivery") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_delivery = :dateDelivery")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateDelivery(@Bind(value="dateDelivery") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.date_delivery = :dateDelivery")
    public long findListByDateDeliveryCount(@Bind(value="dateDelivery") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_delivery = :dateDelivery ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateDelivery(@Bind(value="dateDelivery") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public TargetCommodityDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.commodity_keg_size_id, p.price_amount_purchase_retail, p.price_amount_purchase_wholesale, p.price_amount_sale_retail, p.price_amount_sale_wholesale, p.volume, p.on_order, p.date_order, p.date_delivery, p.auto_prolong, p.date_updated, p.note, p.date_created FROM data.target_commodity p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityMapper.class)
    public List<TargetCommodityDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.target_commodity (id, uid, source, abra_id, plu, code, shipping_weight, external_record_id, disabled, ord, manufacturer_id, external_stock_availability_id, external_charge_id, vat, language_name, name, alternative_name, annotation, description, meta_title, meta_description, meta_key_words, path, enabled, commodity_keg_size_id, price_amount_purchase_retail, price_amount_purchase_wholesale, price_amount_sale_retail, price_amount_sale_wholesale, volume, on_order, date_order, date_delivery, auto_prolong, date_updated, note, date_created) VALUES (:id, :uid, :source, :abraId, :plu, :code, :shippingWeight, :externalRecordId, :disabled, :ord, :manufacturerId, :externalStockAvailabilityId, :externalChargeId, :vat, :languageName, :name, :alternativeName, :annotation, :description, :metaTitle, :metaDescription, :metaKeyWords, :path, :enabled, :commodityKegSizeId, :priceAmountPurchaseRetail, :priceAmountPurchaseWholesale, :priceAmountSaleRetail, :priceAmountSaleWholesale, :volume, :onOrder, :dateOrder, :dateDelivery, :autoProlong, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="source") String var3, @Bind(value="abraId") String var4, @Bind(value="plu") String var5, @Bind(value="code") String var6, @Bind(value="shippingWeight") Double var7, @Bind(value="externalRecordId") String var8, @Bind(value="disabled") Integer var9, @Bind(value="ord") Integer var10, @Bind(value="manufacturerId") String var11, @Bind(value="externalStockAvailabilityId") String var12, @Bind(value="externalChargeId") String var13, @Bind(value="vat") Double var14, @Bind(value="languageName") String var15, @Bind(value="name") String var16, @Bind(value="alternativeName") String var17, @Bind(value="annotation") String var18, @Bind(value="description") String var19, @Bind(value="metaTitle") String var20, @Bind(value="metaDescription") String var21, @Bind(value="metaKeyWords") String var22, @Bind(value="path") String var23, @Bind(value="enabled") Integer var24, @Bind(value="commodityKegSizeId") Long var25, @Bind(value="priceAmountPurchaseRetail") Double var26, @Bind(value="priceAmountPurchaseWholesale") Double var27, @Bind(value="priceAmountSaleRetail") Double var28, @Bind(value="priceAmountSaleWholesale") Double var29, @Bind(value="volume") Double var30, @Bind(value="onOrder") Integer var31, @Bind(value="dateOrder") Date var32, @Bind(value="dateDelivery") Date var33, @Bind(value="autoProlong") Integer var34, @Bind(value="dateUpdated") Date var35, @Bind(value="note") String var36, @Bind(value="dateCreated") Date var37);

    @SqlUpdate(value="INSERT INTO data.target_commodity (source, abra_id, plu, code, shipping_weight, external_record_id, disabled, ord, manufacturer_id, external_stock_availability_id, external_charge_id, vat, language_name, name, alternative_name, annotation, description, meta_title, meta_description, meta_key_words, path, enabled, commodity_keg_size_id, price_amount_purchase_retail, price_amount_purchase_wholesale, price_amount_sale_retail, price_amount_sale_wholesale, volume, on_order, date_order, date_delivery, auto_prolong, date_updated, note, date_created) VALUES (:e.source, :e.abraId, :e.plu, :e.code, :e.shippingWeight, :e.externalRecordId, :e.disabled, :e.ord, :e.manufacturerId, :e.externalStockAvailabilityId, :e.externalChargeId, :e.vat, :e.languageName, :e.name, :e.alternativeName, :e.annotation, :e.description, :e.metaTitle, :e.metaDescription, :e.metaKeyWords, :e.path, :e.enabled, :e.commodityKegSizeId, :e.priceAmountPurchaseRetail, :e.priceAmountPurchaseWholesale, :e.priceAmountSaleRetail, :e.priceAmountSaleWholesale, :e.volume, :e.onOrder, :e.dateOrder, :e.dateDelivery, :e.autoProlong, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TargetCommodityDomain var1);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE shipping_weight = :byShippingWeight")
    public int updateByShippingWeight(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byShippingWeight") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE external_record_id = :byExternalRecordId")
    public int updateByExternalRecordId(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byExternalRecordId") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE disabled = :byDisabled")
    public int updateByDisabled(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byDisabled") Integer var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE manufacturer = :byEan")
    public int updateByManufacturer(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE external_stock_availability_id = :byExternalStockAvailabilityId")
    public int updateByExternalStockAvailabilityId(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byExternalStockAvailabilityId") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE external_charge_id = :byExternalChargeId")
    public int updateByExternalChargeId(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byExternalChargeId") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE vat = :byVat")
    public int updateByVat(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byVat") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_name = :byAlternativeName")
    public int updateByAlternativeName(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byAlternativeName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE annotation = :byAnnotation")
    public int updateByAnnotation(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byAnnotation") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_title = :byMetaTitle")
    public int updateByMetaTitle(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byMetaTitle") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_description = :byMetaDescription")
    public int updateByMetaDescription(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byMetaDescription") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_key_words = :byMetaKeyWords")
    public int updateByMetaKeyWords(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byMetaKeyWords") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE path = :byPath")
    public int updateByPath(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byPath") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE enabled = :byEnabled")
    public int updateByEnabled(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byEnabled") Integer var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE commodity_keg_size_id = :byCommodityKegSizeId")
    public int updateByCommodityKegSizeId(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byCommodityKegSizeId") Long var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE price_amount_purchase_retail = :byPriceAmountPurchaseRetail")
    public int updateByPriceAmountPurchaseRetail(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byPriceAmountPurchaseRetail") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE price_amount_purchase_wholesale = :byPriceAmountPurchaseWholesale")
    public int updateByPriceAmountPurchaseWholesale(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byPriceAmountPurchaseWholesale") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE price_amount_sale_retail = :byPriceAmountSaleRetail")
    public int updateByPriceAmountSaleRetail(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byPriceAmountSaleRetail") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE price_amount_sale_wholesale = :byPriceAmountSaleWholesale")
    public int updateByPriceAmountSaleWholesale(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byPriceAmountSaleWholesale") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE volume = :byVolume")
    public int updateByVolume(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byVolume") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE on_order = :byOnOrder")
    public int updateByOnOrder(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byOnOrder") Integer var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_order = :byDateOrder")
    public int updateByDateOrder(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byDateOrder") Date var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_delivery = :byDateDelivery")
    public int updateByDateDelivery(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byDateDelivery") Date var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, commodity_keg_size_id = :e.commodityKegSizeId, price_amount_purchase_retail = :e.priceAmountPurchaseRetail, price_amount_purchase_wholesale = :e.priceAmountPurchaseWholesale, price_amount_sale_retail = :e.priceAmountSaleRetail, price_amount_sale_wholesale = :e.priceAmountSaleWholesale, volume = :e.volume, on_order = :e.onOrder, date_order = :e.dateOrder, date_delivery = :e.dateDelivery, auto_prolong = :e.autoProlong, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TargetCommodityDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE shipping_weight = :shippingWeight")
    public int deleteByShippingWeight(@Bind(value="shippingWeight") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE external_record_id = :externalRecordId")
    public int deleteByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE disabled = :disabled")
    public int deleteByDisabled(@Bind(value="disabled") Integer var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE manufacturer = :manufacturerId")
    public int deleteByManufacturer(@Bind(value="manufacturerId") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE external_stock_availability_id = :externalStockAvailabilityId")
    public int deleteByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE external_charge_id = :externalChargeId")
    public int deleteByExternalChargeId(@Bind(value="externalChargeId") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE vat = :vat")
    public int deleteByVat(@Bind(value="vat") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE alternative_name = :alternativeName")
    public int deleteByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE annotation = :annotation")
    public int deleteByAnnotation(@Bind(value="annotation") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE meta_title = :metaTitle")
    public int deleteByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE meta_description = :metaDescription")
    public int deleteByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE meta_key_words = :metaKeyWords")
    public int deleteByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE path = :path")
    public int deleteByPath(@Bind(value="path") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE enabled = :enabled")
    public int deleteByEnabled(@Bind(value="enabled") Integer var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE commodity_keg_size_id = :commodityKegSizeId")
    public int deleteByCommodityKegSizeId(@Bind(value="commodityKegSizeId") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE price_amount_purchase_retail = :priceAmountPurchaseRetail")
    public int deleteByPriceAmountPurchaseRetail(@Bind(value="priceAmountPurchaseRetail") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE price_amount_purchase_wholesale = :priceAmountPurchaseWholesale")
    public int deleteByPriceAmountPurchaseWholesale(@Bind(value="priceAmountPurchaseWholesale") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE price_amount_sale_retail = :priceAmountSaleRetail")
    public int deleteByPriceAmountSaleRetail(@Bind(value="priceAmountSaleRetail") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE price_amount_sale_wholesale = :priceAmountSaleWholesale")
    public int deleteByPriceAmountSaleWholesale(@Bind(value="priceAmountSaleWholesale") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE volume = :volume")
    public int deleteByVolume(@Bind(value="volume") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE on_order = :onOrder")
    public int deleteByOnOrder(@Bind(value="onOrder") Integer var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE date_order = :dateOrder")
    public int deleteByDateOrder(@Bind(value="dateOrder") Date var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE date_delivery = :dateDelivery")
    public int deleteByDateDelivery(@Bind(value="dateDelivery") Date var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

