/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.TransferQueueItemsMapper;
import cz.airtoy.airshop.dao.mappers.app.TransferQueueItemsExportMapper;
import cz.airtoy.airshop.dao.mappers.full.TransferQueueItemsFullMapper;
import cz.airtoy.airshop.domains.TransferQueueItemsDomain;
import cz.airtoy.airshop.domains.app.TransferQueueItemsExportDomain;
import cz.airtoy.airshop.domains.full.TransferQueueItemsFullDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TransferQueueItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.transfer_queue_id,\n\t\tp.order_id,\n\t\tp.order_item_id,\n\t\tp.ean,\n\t\tp.plu,\n\t\tp.store_cards_id,\n\t\tp.quantity,\n\t\tp.mainunitcode,\n\t\tp.status,\n\t\tp.processing,\n\t\tp.processed,\n\t\tp.date_created,\n\t\tp.note\n FROM \n\t\tabra.transfer_queue_items p\n\t\n\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.transfer_queue_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_item_id::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.mainunitcode::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.processing::text ~* :mask \n\tOR \n\t\tp.processed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.transfer_queue_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.transfer_queue_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_item_id::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.mainunitcode::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.processing::text ~* :mask \n\tOR \n\t\tp.processed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT\n\tsc.plu,\n\tsc.ean,\n\tsc.name,\n\tSUM(si.quantity) as quantity\nFROM\n\tabra.transfer_queue_items si\n\tLEFT OUTER JOIN abra.store_cards sc ON (sc.id = si.store_cards_id)\nWHERE\n\tsi.transfer_queue_id = :transferQueueId\nGROUP BY\n\tsc.plu,\n\tsc.ean,\n\tsc.name\nORDER BY \n\tsc.name ASC \n")
    @RegisterRowMapper(value=TransferQueueItemsExportMapper.class)
    public List<TransferQueueItemsExportDomain> exportByTransferQueueId(@Bind(value="transferQueueId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.transfer_queue_id = :transferQueueId AND p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByTransferQueueIdStoreCardsId(@Bind(value="transferQueueId") Long var1, @Bind(value="storeCardsId") Long var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note,\t  abra_store_cards.id AS sc_id,\n\t\tabra_store_cards.uid AS sc_uid,\n\t\tabra_store_cards.abra_id AS sc_abra_id,\n\t\tabra_store_cards.manufacturer AS sc_manufacturer,\n\t\tabra_store_cards.date_authorized_at AS sc_date_authorized_at,\n\t\tabra_store_cards.authorizedby_id AS sc_authorizedby_id,\n\t\tabra_store_cards.bodycode AS sc_bodycode,\n\t\tabra_store_cards.category AS sc_category,\n\t\tabra_store_cards.classid AS sc_classid,\n\t\tabra_store_cards.code AS sc_code,\n\t\tabra_store_cards.comment AS sc_comment,\n\t\tabra_store_cards.date_correctedat AS sc_date_correctedat,\n\t\tabra_store_cards.correctedby_id AS sc_correctedby_id,\n\t\tabra_store_cards.country_id AS sc_country_id,\n\t\tabra_store_cards.date_createdat AS sc_date_createdat,\n\t\tabra_store_cards.createdby_id AS sc_createdby_id,\n\t\tabra_store_cards.customstariff AS sc_customstariff,\n\t\tabra_store_cards.customstariffnumber AS sc_customstariffnumber,\n\t\tabra_store_cards.date_dateofchange AS sc_date_dateofchange,\n\t\tabra_store_cards.dealerdiscount_id AS sc_dealerdiscount_id,\n\t\tabra_store_cards.discountsexcluded AS sc_discountsexcluded,\n\t\tabra_store_cards.displayname AS sc_displayname,\n\t\tabra_store_cards.ean AS sc_ean,\n\t\tabra_store_cards.expirationdue AS sc_expirationdue,\n\t\tabra_store_cards.foreignname AS sc_foreignname,\n\t\tabra_store_cards.guaranteelength AS sc_guaranteelength,\n\t\tabra_store_cards.guaranteelengthcorporate AS sc_guaranteelengthcorporate,\n\t\tabra_store_cards.guaranteeunitname AS sc_guaranteeunitname,\n\t\tabra_store_cards.guaranteeunitnamecorporate AS sc_guaranteeunitnamecorporate,\n\t\tabra_store_cards.hidden AS sc_hidden,\n\t\tabra_store_cards.incometype_id AS sc_incometype_id,\n\t\tabra_store_cards.intrastatcommodity_id AS sc_intrastatcommodity_id,\n\t\tabra_store_cards.intrastatcurrentprice AS sc_intrastatcurrentprice,\n\t\tabra_store_cards.intrastatcurrentpricelimit AS sc_intrastatcurrentpricelimit,\n\t\tabra_store_cards.intrastatextratype_id AS sc_intrastatextratype_id,\n\t\tabra_store_cards.intrastatinputstatistic_id AS sc_intrastatinputstatistic_id,\n\t\tabra_store_cards.intrastatoutputstatistic_id AS sc_intrastatoutputstatistic_id,\n\t\tabra_store_cards.intrastatregion_id AS sc_intrastatregion_id,\n\t\tabra_store_cards.intrastatunitcode AS sc_intrastatunitcode,\n\t\tabra_store_cards.intrastatunitrate AS sc_intrastatunitrate,\n\t\tabra_store_cards.intrastatunitrateref AS sc_intrastatunitrateref,\n\t\tabra_store_cards.intrastatweight AS sc_intrastatweight,\n\t\tabra_store_cards.intrastatweightunit AS sc_intrastatweightunit,\n\t\tabra_store_cards.isproduct AS sc_isproduct,\n\t\tabra_store_cards.isscalable AS sc_isscalable,\n\t\tabra_store_cards.mainsupplier_id AS sc_mainsupplier_id,\n\t\tabra_store_cards.mainunitcode AS sc_mainunitcode,\n\t\tabra_store_cards.mainunitrate AS sc_mainunitrate,\n\t\tabra_store_cards.mossservice_id AS sc_mossservice_id,\n\t\tabra_store_cards.name AS sc_name,\n\t\tabra_store_cards.nonstocktype AS sc_nonstocktype,\n\t\tabra_store_cards.note AS sc_note,\n\t\tabra_store_cards.objversion AS sc_objversion,\n\t\tabra_store_cards.outofstockbatchdelivery AS sc_outofstockbatchdelivery,\n\t\tabra_store_cards.outofstockdelivery AS sc_outofstockdelivery,\n\t\tabra_store_cards.picture_id AS sc_picture_id,\n\t\tabra_store_cards.plu AS sc_plu,\n\t\tabra_store_cards.prefixcode AS sc_prefixcode,\n\t\tabra_store_cards.producer_id AS sc_producer_id,\n\t\tabra_store_cards.quantitydiscount_id AS sc_quantitydiscount_id,\n\t\tabra_store_cards.serialnumberstructure AS sc_serialnumberstructure,\n\t\tabra_store_cards.shortname AS sc_shortname,\n\t\tabra_store_cards.specification AS sc_specification,\n\t\tabra_store_cards.specification2 AS sc_specification2,\n\t\tabra_store_cards.spendingtaxtariff AS sc_spendingtaxtariff,\n\t\tabra_store_cards.storeassortmentgroup_id AS sc_storeassortmentgroup_id,\n\t\tabra_store_cards.storebatchstructure_id AS sc_storebatchstructure_id,\n\t\tabra_store_cards.storecardcategory_id AS sc_storecardcategory_id,\n\t\tabra_store_cards.storemenuitem_id AS sc_storemenuitem_id,\n\t\tabra_store_cards.suffixcode AS sc_suffixcode,\n\t\tabra_store_cards.toleranceminus AS sc_toleranceminus,\n\t\tabra_store_cards.toleranceplus AS sc_toleranceplus,\n\t\tabra_store_cards.tolerancetype AS sc_tolerancetype,\n\t\tabra_store_cards.useoutofstockbatchdelivery AS sc_useoutofstockbatchdelivery,\n\t\tabra_store_cards.useoutofstockdelivery AS sc_useoutofstockdelivery,\n\t\tabra_store_cards.usualgrossprofit AS sc_usualgrossprofit,\n\t\tabra_store_cards.vatrate AS sc_vatrate,\n\t\tabra_store_cards.vatrate_id AS sc_vatrate_id,\n\t\tabra_store_cards.withcontainers AS sc_withcontainers,\n\t\tabra_store_cards.abra_autobeershop AS sc_abra_autobeershop,\n\t\tabra_store_cards.abra_autodelikatesy AS sc_abra_autodelikatesy,\n\t\tabra_store_cards.abra_barva AS sc_abra_barva,\n\t\tabra_store_cards.abra_carovy_kod AS sc_abra_carovy_kod,\n\t\tabra_store_cards.abra_cas_exportu AS sc_abra_cas_exportu,\n\t\tabra_store_cards.abra_clo AS sc_abra_clo,\n\t\tabra_store_cards.abra_datum_trvamlivosti AS sc_abra_datum_trvamlivosti,\n\t\tabra_store_cards.abra_dostupnost AS sc_abra_dostupnost,\n\t\tabra_store_cards.abra_dovozce AS sc_abra_dovozce,\n\t\tabra_store_cards.abra_nazev_eshop AS sc_abra_nazev_eshop,\n\t\tabra_store_cards.abra_nazev_vyrobku AS sc_abra_nazev_vyrobku,\n\t\tabra_store_cards.abra_params AS sc_abra_params,\n\t\tabra_store_cards.abra_placeofshop AS sc_abra_placeofshop,\n\t\tabra_store_cards.abra_popis_produktu AS sc_abra_popis_produktu,\n\t\tabra_store_cards.abra_skladovani AS sc_abra_skladovani,\n\t\tabra_store_cards.abra_slozeni AS sc_abra_slozeni,\n\t\tabra_store_cards.abra_slozeni_stitek AS sc_abra_slozeni_stitek,\n\t\tabra_store_cards.abra_stateonshop AS sc_abra_stateonshop,\n\t\tabra_store_cards.abra_stitek_text AS sc_abra_stitek_text,\n\t\tabra_store_cards.abra_umistneni_sklad AS sc_abra_umistneni_sklad,\n\t\tabra_store_cards.abra_vaha AS sc_abra_vaha,\n\t\tabra_store_cards.abra_vecny_popis AS sc_abra_vecny_popis,\n\t\tabra_store_cards.abra_vyrobce AS sc_abra_vyrobce,\n\t\tabra_store_cards.abra_zeme_puvodu_id AS sc_abra_zeme_puvodu_id,\n\t\tabra_store_cards.abra_znacka AS sc_abra_znacka,\n\t\tabra_store_cards.abra_zobrazeno AS sc_abra_zobrazeno,\n\t\tabra_store_cards.abra_exportnullquantity AS sc_abra_exportnullquantity,\n\t\tabra_store_cards.abra_alkohol AS sc_abra_alkohol,\n\t\tabra_store_cards.abra_plato AS sc_abra_plato,\n\t\tabra_store_cards.abra_objemlitry AS sc_abra_objemlitry,\n\t\tabra_store_cards.abra_sazbaspotrdane AS sc_abra_sazbaspotrdane,\n\t\tabra_store_cards.abra_typlahve AS sc_abra_typlahve,\n\t\tabra_store_cards.quantity AS sc_quantity,\n\t\tabra_store_cards.price_qunit AS sc_price_qunit,\n\t\tabra_store_cards.price_unitrate AS sc_price_unitrate,\n\t\tabra_store_cards.price_amount AS sc_price_amount,\n\t\tabra_store_cards.date_created AS sc_date_created,\n\t\tabra_store_cards.abra_showin_eshop AS sc_abra_showin_eshop,\n\t\tabra_store_cards.abra_showin_bshop AS sc_abra_showin_bshop,\n\t\tabra_store_cards.abra_nazev_bshop AS sc_abra_nazev_bshop,\n\t\tabra_store_cards.abra_nazev_uctenka AS sc_abra_nazev_uctenka,\n\t\tabra_store_cards.abra_export_vectron AS sc_abra_export_vectron,\n\t\tabra_store_cards.abra_change_gastro_on_pda AS sc_abra_change_gastro_on_pda,\n\t\tabra_store_cards.abra_export_prices_eshop AS sc_abra_export_prices_eshop,\n\t\tabra_store_cards.abra_export_prices_bshop AS sc_abra_export_prices_bshop,\n\t\tabra_store_cards.abra_fc_hash_deli AS sc_abra_fc_hash_deli,\n\t\tabra_store_cards.abra_fc_hash_beer AS sc_abra_fc_hash_beer,\n\t\tabra_store_cards.abra_vratna_zaloha_id AS sc_abra_vratna_zaloha_id,\n\t\tabra_store_cards.abra_fc_stockid_deli AS sc_abra_fc_stockid_deli,\n\t\tabra_store_cards.abra_fc_stockid_beer AS sc_abra_fc_stockid_beer,\n   abra_store_cards.abra_autobeershop_eu AS sc_abra_autobeershop_eu,\n   abra_store_cards.abra_fc_hash_beer_eu AS sc_abra_fc_hash_beer_eu,\n   abra_store_cards.abra_showin_bshop_eu AS sc_abra_showin_bshop_eu,\n   abra_store_cards.abra_nazev_bshop_eu AS sc_abra_nazev_bshop_eu,\n   abra_store_cards.abra_bshop_exists AS sc_abra_bshop_exists,\n   abra_store_cards.abra_deli_exists AS sc_abra_deli_exists,\n   abra_store_cards.abra_fc_stockid_beer_eu AS sc_abra_fc_stockid_beer_eu,\n   abra_store_cards.abra_doporucovat AS sc_abra_doporucovat\n FROM abra.transfer_queue_items p  LEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id)  WHERE p.id = :id")
    @RegisterRowMapper(value=TransferQueueItemsFullMapper.class)
    public TransferQueueItemsFullDomain findByIdFull(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE transfer_queue_id = :transferQueueId AND processing IS NULL")
    public int deleteByTransferQueueIdProcessingIsNull(@Bind(value="transferQueueId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  ")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.transfer_queue_id = :transferQueueId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByTransferQueueId(@Bind(value="transferQueueId") Long var1);

    @SqlQuery(value="SELECT  p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note  FROM  abra.transfer_queue_items p  LEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id)  WHERE p.transfer_queue_id = :transferQueueId  ORDER BY abra_store_cards.name ASC ")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByTransferQueueId(@Bind(value="transferQueueId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.transfer_queue_id = :transferQueueId")
    public long findListByTransferQueueIdCount(@Bind(value="transferQueueId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note, \t  abra_store_cards.id AS sc_id,\n\t\tabra_store_cards.uid AS sc_uid,\n\t\tabra_store_cards.abra_id AS sc_abra_id,\n\t\tabra_store_cards.manufacturer AS sc_manufacturer,\n\t\tabra_store_cards.date_authorized_at AS sc_date_authorized_at,\n\t\tabra_store_cards.authorizedby_id AS sc_authorizedby_id,\n\t\tabra_store_cards.bodycode AS sc_bodycode,\n\t\tabra_store_cards.category AS sc_category,\n\t\tabra_store_cards.classid AS sc_classid,\n\t\tabra_store_cards.code AS sc_code,\n\t\tabra_store_cards.comment AS sc_comment,\n\t\tabra_store_cards.date_correctedat AS sc_date_correctedat,\n\t\tabra_store_cards.correctedby_id AS sc_correctedby_id,\n\t\tabra_store_cards.country_id AS sc_country_id,\n\t\tabra_store_cards.date_createdat AS sc_date_createdat,\n\t\tabra_store_cards.createdby_id AS sc_createdby_id,\n\t\tabra_store_cards.customstariff AS sc_customstariff,\n\t\tabra_store_cards.customstariffnumber AS sc_customstariffnumber,\n\t\tabra_store_cards.date_dateofchange AS sc_date_dateofchange,\n\t\tabra_store_cards.dealerdiscount_id AS sc_dealerdiscount_id,\n\t\tabra_store_cards.discountsexcluded AS sc_discountsexcluded,\n\t\tabra_store_cards.displayname AS sc_displayname,\n\t\tabra_store_cards.ean AS sc_ean,\n\t\tabra_store_cards.expirationdue AS sc_expirationdue,\n\t\tabra_store_cards.foreignname AS sc_foreignname,\n\t\tabra_store_cards.guaranteelength AS sc_guaranteelength,\n\t\tabra_store_cards.guaranteelengthcorporate AS sc_guaranteelengthcorporate,\n\t\tabra_store_cards.guaranteeunitname AS sc_guaranteeunitname,\n\t\tabra_store_cards.guaranteeunitnamecorporate AS sc_guaranteeunitnamecorporate,\n\t\tabra_store_cards.hidden AS sc_hidden,\n\t\tabra_store_cards.incometype_id AS sc_incometype_id,\n\t\tabra_store_cards.intrastatcommodity_id AS sc_intrastatcommodity_id,\n\t\tabra_store_cards.intrastatcurrentprice AS sc_intrastatcurrentprice,\n\t\tabra_store_cards.intrastatcurrentpricelimit AS sc_intrastatcurrentpricelimit,\n\t\tabra_store_cards.intrastatextratype_id AS sc_intrastatextratype_id,\n\t\tabra_store_cards.intrastatinputstatistic_id AS sc_intrastatinputstatistic_id,\n\t\tabra_store_cards.intrastatoutputstatistic_id AS sc_intrastatoutputstatistic_id,\n\t\tabra_store_cards.intrastatregion_id AS sc_intrastatregion_id,\n\t\tabra_store_cards.intrastatunitcode AS sc_intrastatunitcode,\n\t\tabra_store_cards.intrastatunitrate AS sc_intrastatunitrate,\n\t\tabra_store_cards.intrastatunitrateref AS sc_intrastatunitrateref,\n\t\tabra_store_cards.intrastatweight AS sc_intrastatweight,\n\t\tabra_store_cards.intrastatweightunit AS sc_intrastatweightunit,\n\t\tabra_store_cards.isproduct AS sc_isproduct,\n\t\tabra_store_cards.isscalable AS sc_isscalable,\n\t\tabra_store_cards.mainsupplier_id AS sc_mainsupplier_id,\n\t\tabra_store_cards.mainunitcode AS sc_mainunitcode,\n\t\tabra_store_cards.mainunitrate AS sc_mainunitrate,\n\t\tabra_store_cards.mossservice_id AS sc_mossservice_id,\n\t\tabra_store_cards.name AS sc_name,\n\t\tabra_store_cards.nonstocktype AS sc_nonstocktype,\n\t\tabra_store_cards.note AS sc_note,\n\t\tabra_store_cards.objversion AS sc_objversion,\n\t\tabra_store_cards.outofstockbatchdelivery AS sc_outofstockbatchdelivery,\n\t\tabra_store_cards.outofstockdelivery AS sc_outofstockdelivery,\n\t\tabra_store_cards.picture_id AS sc_picture_id,\n\t\tabra_store_cards.plu AS sc_plu,\n\t\tabra_store_cards.prefixcode AS sc_prefixcode,\n\t\tabra_store_cards.producer_id AS sc_producer_id,\n\t\tabra_store_cards.quantitydiscount_id AS sc_quantitydiscount_id,\n\t\tabra_store_cards.serialnumberstructure AS sc_serialnumberstructure,\n\t\tabra_store_cards.shortname AS sc_shortname,\n\t\tabra_store_cards.specification AS sc_specification,\n\t\tabra_store_cards.specification2 AS sc_specification2,\n\t\tabra_store_cards.spendingtaxtariff AS sc_spendingtaxtariff,\n\t\tabra_store_cards.storeassortmentgroup_id AS sc_storeassortmentgroup_id,\n\t\tabra_store_cards.storebatchstructure_id AS sc_storebatchstructure_id,\n\t\tabra_store_cards.storecardcategory_id AS sc_storecardcategory_id,\n\t\tabra_store_cards.storemenuitem_id AS sc_storemenuitem_id,\n\t\tabra_store_cards.suffixcode AS sc_suffixcode,\n\t\tabra_store_cards.toleranceminus AS sc_toleranceminus,\n\t\tabra_store_cards.toleranceplus AS sc_toleranceplus,\n\t\tabra_store_cards.tolerancetype AS sc_tolerancetype,\n\t\tabra_store_cards.useoutofstockbatchdelivery AS sc_useoutofstockbatchdelivery,\n\t\tabra_store_cards.useoutofstockdelivery AS sc_useoutofstockdelivery,\n\t\tabra_store_cards.usualgrossprofit AS sc_usualgrossprofit,\n\t\tabra_store_cards.vatrate AS sc_vatrate,\n\t\tabra_store_cards.vatrate_id AS sc_vatrate_id,\n\t\tabra_store_cards.withcontainers AS sc_withcontainers,\n\t\tabra_store_cards.abra_autobeershop AS sc_abra_autobeershop,\n\t\tabra_store_cards.abra_autodelikatesy AS sc_abra_autodelikatesy,\n\t\tabra_store_cards.abra_barva AS sc_abra_barva,\n\t\tabra_store_cards.abra_carovy_kod AS sc_abra_carovy_kod,\n\t\tabra_store_cards.abra_cas_exportu AS sc_abra_cas_exportu,\n\t\tabra_store_cards.abra_clo AS sc_abra_clo,\n\t\tabra_store_cards.abra_datum_trvamlivosti AS sc_abra_datum_trvamlivosti,\n\t\tabra_store_cards.abra_dostupnost AS sc_abra_dostupnost,\n\t\tabra_store_cards.abra_dovozce AS sc_abra_dovozce,\n\t\tabra_store_cards.abra_nazev_eshop AS sc_abra_nazev_eshop,\n\t\tabra_store_cards.abra_nazev_vyrobku AS sc_abra_nazev_vyrobku,\n\t\tabra_store_cards.abra_params AS sc_abra_params,\n\t\tabra_store_cards.abra_placeofshop AS sc_abra_placeofshop,\n\t\tabra_store_cards.abra_popis_produktu AS sc_abra_popis_produktu,\n\t\tabra_store_cards.abra_skladovani AS sc_abra_skladovani,\n\t\tabra_store_cards.abra_slozeni AS sc_abra_slozeni,\n\t\tabra_store_cards.abra_slozeni_stitek AS sc_abra_slozeni_stitek,\n\t\tabra_store_cards.abra_stateonshop AS sc_abra_stateonshop,\n\t\tabra_store_cards.abra_stitek_text AS sc_abra_stitek_text,\n\t\tabra_store_cards.abra_umistneni_sklad AS sc_abra_umistneni_sklad,\n\t\tabra_store_cards.abra_vaha AS sc_abra_vaha,\n\t\tabra_store_cards.abra_vecny_popis AS sc_abra_vecny_popis,\n\t\tabra_store_cards.abra_vyrobce AS sc_abra_vyrobce,\n\t\tabra_store_cards.abra_zeme_puvodu_id AS sc_abra_zeme_puvodu_id,\n\t\tabra_store_cards.abra_znacka AS sc_abra_znacka,\n\t\tabra_store_cards.abra_zobrazeno AS sc_abra_zobrazeno,\n\t\tabra_store_cards.abra_exportnullquantity AS sc_abra_exportnullquantity,\n\t\tabra_store_cards.abra_alkohol AS sc_abra_alkohol,\n\t\tabra_store_cards.abra_plato AS sc_abra_plato,\n\t\tabra_store_cards.abra_objemlitry AS sc_abra_objemlitry,\n\t\tabra_store_cards.abra_sazbaspotrdane AS sc_abra_sazbaspotrdane,\n\t\tabra_store_cards.abra_typlahve AS sc_abra_typlahve,\n\t\tabra_store_cards.quantity AS sc_quantity,\n\t\tabra_store_cards.price_qunit AS sc_price_qunit,\n\t\tabra_store_cards.price_unitrate AS sc_price_unitrate,\n\t\tabra_store_cards.price_amount AS sc_price_amount,\n\t\tabra_store_cards.date_created AS sc_date_created,\n\t\tabra_store_cards.abra_showin_eshop AS sc_abra_showin_eshop,\n\t\tabra_store_cards.abra_showin_bshop AS sc_abra_showin_bshop,\n\t\tabra_store_cards.abra_nazev_bshop AS sc_abra_nazev_bshop,\n\t\tabra_store_cards.abra_nazev_uctenka AS sc_abra_nazev_uctenka,\n\t\tabra_store_cards.abra_export_vectron AS sc_abra_export_vectron,\n\t\tabra_store_cards.abra_change_gastro_on_pda AS sc_abra_change_gastro_on_pda,\n\t\tabra_store_cards.abra_export_prices_eshop AS sc_abra_export_prices_eshop,\n\t\tabra_store_cards.abra_export_prices_bshop AS sc_abra_export_prices_bshop,\n\t\tabra_store_cards.abra_fc_hash_deli AS sc_abra_fc_hash_deli,\n\t\tabra_store_cards.abra_fc_hash_beer AS sc_abra_fc_hash_beer,\n\t\tabra_store_cards.abra_vratna_zaloha_id AS sc_abra_vratna_zaloha_id,\n\t\tabra_store_cards.abra_fc_stockid_deli AS sc_abra_fc_stockid_deli,\n\t\tabra_store_cards.abra_fc_stockid_beer AS sc_abra_fc_stockid_beer,\n   abra_store_cards.abra_autobeershop_eu AS sc_abra_autobeershop_eu,\n   abra_store_cards.abra_fc_hash_beer_eu AS sc_abra_fc_hash_beer_eu,\n   abra_store_cards.abra_showin_bshop_eu AS sc_abra_showin_bshop_eu,\n   abra_store_cards.abra_nazev_bshop_eu AS sc_abra_nazev_bshop_eu,\n   abra_store_cards.abra_bshop_exists AS sc_abra_bshop_exists,\n   abra_store_cards.abra_deli_exists AS sc_abra_deli_exists,\n   abra_store_cards.abra_fc_stockid_beer_eu AS sc_abra_fc_stockid_beer_eu,\n   abra_store_cards.abra_doporucovat AS sc_abra_doporucovat\n FROM abra.transfer_queue_items p  LEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id)  WHERE  p.transfer_queue_id = :transferQueueId  AND abra_store_cards.plu::text ~* :filterEanPlu \tAND abra_store_cards.name::text ~* :mask  ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsFullMapper.class)
    public List<TransferQueueItemsFullDomain> findListByTransferQueueIdFilter(@Bind(value="transferQueueId") Long var1, @Bind(value="mask") String var2, @Bind(value="filterEanPlu") String var3, @Bind(value="offset") int var4, @Bind(value="limit") int var5, @Define(value="order") String var6, @Define(value="sort") String var7);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p LEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id) WHERE p.transfer_queue_id = :transferQueueId AND abra_store_cards.plu::text ~* :filterEanPlu\tAND abra_store_cards.name::text ~* :mask ")
    public long findListByTransferQueueIdFilterCount(@Bind(value="transferQueueId") Long var1, @Bind(value="mask") String var2, @Bind(value="filterEanPlu") String var3);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.transfer_queue_id = :transferQueueId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByTransferQueueId(@Bind(value="transferQueueId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.order_item_id = :orderItemId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByOrderItemId(@Bind(value="orderItemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.order_item_id = :orderItemId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByOrderItemId(@Bind(value="orderItemId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.order_item_id = :orderItemId")
    public long findListByOrderItemIdCount(@Bind(value="orderItemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.order_item_id = :orderItemId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByOrderItemId(@Bind(value="orderItemId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.ean = :ean")
    public long findListByEanCount(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.ean = :ean ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByEan(@Bind(value="ean") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByQuantity(@Bind(value="quantity") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByQuantity(@Bind(value="quantity") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.quantity = :quantity")
    public long findListByQuantityCount(@Bind(value="quantity") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.quantity = :quantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByQuantity(@Bind(value="quantity") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.mainunitcode = :mainunitcode")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByMainunitcode(@Bind(value="mainunitcode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.mainunitcode = :mainunitcode")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByMainunitcode(@Bind(value="mainunitcode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.mainunitcode = :mainunitcode")
    public long findListByMainunitcodeCount(@Bind(value="mainunitcode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.mainunitcode = :mainunitcode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByMainunitcode(@Bind(value="mainunitcode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.processing = :processing")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByProcessing(@Bind(value="processing") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.processing = :processing")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByProcessing(@Bind(value="processing") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.processing = :processing")
    public long findListByProcessingCount(@Bind(value="processing") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.processing = :processing ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByProcessing(@Bind(value="processing") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.processed = :processed")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByProcessed(@Bind(value="processed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.processed = :processed")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByProcessed(@Bind(value="processed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.processed = :processed")
    public long findListByProcessedCount(@Bind(value="processed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.processed = :processed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByProcessed(@Bind(value="processed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public TransferQueueItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_queue_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transfer_queue_id, p.order_id, p.order_item_id, p.ean, p.plu, p.store_cards_id, p.quantity, p.mainunitcode, p.status, p.processing, p.processed, p.date_created, p.note FROM abra.transfer_queue_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferQueueItemsMapper.class)
    public List<TransferQueueItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.transfer_queue_items (id, uid, transfer_queue_id, order_id, order_item_id, ean, plu, store_cards_id, quantity, mainunitcode, status, processing, processed, date_created) VALUES (:id, :uid, :transferQueueId, :orderId, :orderItemId, :ean, :plu, :storeCardsId, :quantity, :mainunitcode, :status, :processing, :processed, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="transferQueueId") Long var3, @Bind(value="orderId") Long var4, @Bind(value="orderItemId") Long var5, @Bind(value="ean") String var6, @Bind(value="plu") String var7, @Bind(value="storeCardsId") Long var8, @Bind(value="quantity") Integer var9, @Bind(value="mainunitcode") String var10, @Bind(value="status") String var11, @Bind(value="processing") Date var12, @Bind(value="processed") Date var13, @Bind(value="dateCreated") Date var14);

    @SqlUpdate(value="INSERT INTO abra.transfer_queue_items (transfer_queue_id, order_id, order_item_id, ean, plu, store_cards_id, quantity, mainunitcode, status, processing, processed, date_created, note) VALUES (:e.transferQueueId, :e.orderId, :e.orderItemId, :e.ean, :e.plu, :e.storeCardsId, :e.quantity, :e.mainunitcode, :e.status, :e.processing, :e.processed, :e.dateCreated, :e.note)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TransferQueueItemsDomain var1);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE id = :byId")
    public int updateById(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE transfer_queue_id = :byTransferQueueId")
    public int updateByTransferQueueId(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byTransferQueueId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE order_item_id = :byOrderItemId")
    public int updateByOrderItemId(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byOrderItemId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE ean = :byEan")
    public int updateByEan(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE quantity = :byQuantity")
    public int updateByQuantity(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byQuantity") Integer var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE mainunitcode = :byMainunitcode")
    public int updateByMainunitcode(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byMainunitcode") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE processing = :byProcessing")
    public int updateByProcessing(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byProcessing") Date var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE processed = :byProcessed")
    public int updateByProcessed(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byProcessed") Date var2);

    @SqlUpdate(value="UPDATE abra.transfer_queue_items SET id = :e.id, uid = :e.uid, transfer_queue_id = :e.transferQueueId, order_id = :e.orderId, order_item_id = :e.orderItemId, ean = :e.ean, plu = :e.plu, store_cards_id = :e.storeCardsId, quantity = :e.quantity, mainunitcode = :e.mainunitcode, status = :e.status, processing = :e.processing, processed = :e.processed, date_created = :e.dateCreated, note = :e.note WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TransferQueueItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE transfer_queue_id = :transferQueueId")
    public int deleteByTransferQueueId(@Bind(value="transferQueueId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE order_item_id = :orderItemId")
    public int deleteByOrderItemId(@Bind(value="orderItemId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE ean = :ean")
    public int deleteByEan(@Bind(value="ean") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE quantity = :quantity")
    public int deleteByQuantity(@Bind(value="quantity") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE mainunitcode = :mainunitcode")
    public int deleteByMainunitcode(@Bind(value="mainunitcode") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE processing = :processing")
    public int deleteByProcessing(@Bind(value="processing") Date var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE processed = :processed")
    public int deleteByProcessed(@Bind(value="processed") Date var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_queue_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

