/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.SubscriptionsMapper;
import cz.airtoy.airshop.domains.SubscriptionsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SubscriptionsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.name,\n\t\tp.description,\n\t\tp.store_cards_id,\n\t\tp.index,\n\t\tp.frequency,\n\t\tp.cnt,\n\t\tp.img,\n\t\tp.valid_from,\n\t\tp.valid_to,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tabra.subscriptions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.index::text ~* :mask \n\tOR \n\t\tp.frequency::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.valid_from::text ~* :mask \n\tOR \n\t\tp.valid_to::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.subscriptions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.index::text ~* :mask \n\tOR \n\t\tp.frequency::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.valid_from::text ~* :mask \n\tOR \n\t\tp.valid_to::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  ")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.id = :id")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.id = :id")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.name = :name")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.name = :name")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.description = :description")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.description = :description")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.index = :index")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByIndex(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.index = :index")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByIndex(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.index = :index")
    public long findListByIndexCount(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.index = :index ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByIndex(@Bind(value="index") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.frequency = :frequency")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByFrequency(@Bind(value="frequency") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.frequency = :frequency")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByFrequency(@Bind(value="frequency") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.frequency = :frequency")
    public long findListByFrequencyCount(@Bind(value="frequency") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.frequency = :frequency ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByFrequency(@Bind(value="frequency") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.cnt = :cnt")
    public long findListByCntCount(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.cnt = :cnt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByCnt(@Bind(value="cnt") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.img = :img")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByImg(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.img = :img")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByImg(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.img = :img")
    public long findListByImgCount(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.img = :img ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByImg(@Bind(value="img") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.valid_from = :validFrom")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.valid_from = :validFrom")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.valid_from = :validFrom")
    public long findListByValidFromCount(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.valid_from = :validFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByValidFrom(@Bind(value="validFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.valid_to = :validTo")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByValidTo(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.valid_to = :validTo")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByValidTo(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.valid_to = :validTo")
    public long findListByValidToCount(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.valid_to = :validTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByValidTo(@Bind(value="validTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.note = :note")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.note = :note")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public SubscriptionsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscriptions p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.store_cards_id, p.index, p.frequency, p.cnt, p.img, p.valid_from, p.valid_to, p.note, p.date_created FROM abra.subscriptions p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionsMapper.class)
    public List<SubscriptionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.subscriptions (id, uid, name, description, store_cards_id, index, frequency, cnt, img, valid_from, valid_to, note, date_created) VALUES (:id, :uid, :name, :description, :storeCardsId, :index, :frequency, :cnt, :img, :validFrom, :validTo, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="name") String var3, @Bind(value="description") String var4, @Bind(value="storeCardsId") Long var5, @Bind(value="index") Integer var6, @Bind(value="frequency") Integer var7, @Bind(value="cnt") Integer var8, @Bind(value="img") String var9, @Bind(value="validFrom") Date var10, @Bind(value="validTo") Date var11, @Bind(value="note") String var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO abra.subscriptions (name, description, store_cards_id, index, frequency, cnt, img, valid_from, valid_to, note, date_created) VALUES (:e.name, :e.description, :e.storeCardsId, :e.index, :e.frequency, :e.cnt, :e.img, :e.validFrom, :e.validTo, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SubscriptionsDomain var1);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE index = :byIndex")
    public int updateByIndex(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byIndex") Integer var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE frequency = :byFrequency")
    public int updateByFrequency(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byFrequency") Integer var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE cnt = :byCnt")
    public int updateByCnt(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byCnt") Integer var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE img = :byImg")
    public int updateByImg(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byImg") String var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE valid_from = :byValidFrom")
    public int updateByValidFrom(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byValidFrom") Date var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE valid_to = :byValidTo")
    public int updateByValidTo(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byValidTo") Date var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.subscriptions SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, store_cards_id = :e.storeCardsId, index = :e.index, frequency = :e.frequency, cnt = :e.cnt, img = :e.img, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SubscriptionsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE index = :index")
    public int deleteByIndex(@Bind(value="index") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE frequency = :frequency")
    public int deleteByFrequency(@Bind(value="frequency") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE cnt = :cnt")
    public int deleteByCnt(@Bind(value="cnt") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE img = :img")
    public int deleteByImg(@Bind(value="img") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE valid_from = :validFrom")
    public int deleteByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE valid_to = :validTo")
    public int deleteByValidTo(@Bind(value="validTo") Date var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscriptions WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

