/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrdersMapper;
import cz.airtoy.airshop.dao.mappers.full.OrdersFullMapper;
import cz.airtoy.airshop.dao.mappers.help.OrderWithInfosMapper;
import cz.airtoy.airshop.dao.mappers.help.OrderWithInfosOrderProcessMapper;
import cz.airtoy.airshop.dao.mappers.stats.help.OrderStavObjednavkyInfoMapper;
import cz.airtoy.airshop.domains.OrdersDomain;
import cz.airtoy.airshop.domains.help.OrderWithInfosDomain;
import cz.airtoy.airshop.domains.help.OrderWithInfosOrderProcessDomain;
import cz.airtoy.airshop.domains.stats.help.StavObjednavkyStatsInfoDomain;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrdersDbiDao
extends BaseDao {
    @SqlUpdate(value="REFRESH MATERIALIZED VIEW abra.view_orders_find_all_oiscnt")
    public void refreshMaterializedViewOrdersFindAllOiscnt();

    @SqlQuery(value="SELECT \n   p.abra_stav_objednavky_id,\n   COUNT( p.id ) as cnt_all \n FROM \n   abra.orders p\n\tWHERE \n   p.date_created >= NOW() - '2 months'::INTERVAL \n\tGROUP BY \n   p.abra_stav_objednavky_id \n \n")
    @RegisterRowMapper(value=OrderStavObjednavkyInfoMapper.class)
    public List<StavObjednavkyStatsInfoDomain> findStatsForStavObjednavky();

    @SqlQuery(value="SELECT \n   COUNT( p.id ) as cnt \n FROM \n   abra.orders p\n\tWHERE \n\t\t(CASE WHEN :email = 'ALL' THEN TRUE ELSE (p.order_email = :email) END) \n\tAND \n\t\t(CASE WHEN :source = 'ALL' THEN TRUE ELSE (p.source = :source) END) \n \n")
    public long findCountOrderByEmailSource(@Bind(value="email") String var1, @Bind(value="source") String var2);

    @SqlQuery(value="SELECT \n foo.* \n\tFROM (\n SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.accountingtype,\n\t\tp.address_id,\n\t\tp.amount,\n\t\tp.amountwithoutvat,\n\t\tp.bankaccount_id,\n\t\tp.capacity,\n\t\tp.capacityunit,\n\t\tp.classid,\n\t\tp.closed,\n\t\tp.coef,\n\t\tp.confirmed,\n\t\tp.constsymbol_id,\n\t\tp.date_correctedat,\n\t\tp.correctedby_id,\n\t\tp.country_id,\n\t\tp.date_createdat,\n\t\tp.createdby_id,\n\t\tp.currency_id,\n\t\tp.currrate,\n\t\tp.currrateinfo,\n\t\tp.dealercategory_id,\n\t\tp.dealerdiscount,\n\t\tp.dealerdiscountkind,\n\t\tp.description,\n\t\tp.dirty,\n\t\tp.discountcalckind,\n\t\tp.displayname,\n\t\tp.date_docdate,\n\t\tp.docqueue_id,\n\t\tp.documentdiscount,\n\t\tp.donotrecalculateunitprice,\n\t\tp.externalnumber,\n\t\tp.financialdiscount,\n\t\tp.firm_id,\n\t\tp.firmoffice_id,\n\t\tp.frozendiscounts,\n\t\tp.intrastatdeliveryterm_id,\n\t\tp.intrastattransactiontype_id,\n\t\tp.intrastattransportationtype_id,\n\t\tp.isaccounted,\n\t\tp.isaccountedlatervat,\n\t\tp.isavailablefordelivery,\n\t\tp.isfinancialdiscount,\n\t\tp.isreversechargedeclared,\n\t\tp.isrowdiscount,\n\t\tp.localamount,\n\t\tp.localamountwithoutvat,\n\t\tp.localcoef,\n\t\tp.localrefcurrency_id,\n\t\tp.localroundingamount,\n\t\tp.localvatamount,\n\t\tp.localzone_id,\n\t\tp.margin,\n\t\tp.newrelateddocument_id,\n\t\tp.newrelatedtype,\n\t\tp.objversion,\n\t\tp.onlywholeorder,\n\t\tp.ordnumber,\n\t\tp.paymenttype_id,\n\t\tp.period_id,\n\t\tp.person_id,\n\t\tp.priceprecision,\n\t\tp.pricesbyref,\n\t\tp.priceswithvat,\n\t\tp.quantitydiscountkind,\n\t\tp.refcurrency_id,\n\t\tp.refcurrrate,\n\t\tp.revided_id,\n\t\tp.revision,\n\t\tp.revisionauthor_id,\n\t\tp.date_revisiondate,\n\t\tp.revisiondescription,\n\t\tp.roundingamount,\n\t\tp.storeprice,\n\t\tp.totaldiscountamount,\n\t\tp.totalrounding,\n\t\tp.tradetype,\n\t\tp.tradetypedescription,\n\t\tp.transportationtype_id,\n\t\tp.vatamount,\n\t\tp.vatcountry_id,\n\t\tp.vatdocument,\n\t\tp.vatfromaboveprecision,\n\t\tp.vatfromabovetype,\n\t\tp.vatrounding,\n\t\tp.weight,\n\t\tp.weightunit,\n\t\tp.abra_address1_id,\n\t\tp.abra_address2_id,\n\t\tp.abra_contacted,\n\t\tp.abra_endeddate,\n\t\tp.abra_params,\n\t\tp.abra_pd_bb_branches,\n\t\tp.abra_pd_bb_modul,\n\t\tp.abra_pd_bb_services,\n\t\tp.abra_pd_status,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.abra_storno,\n\t\tp.abra_uloz_nazev_pobocky,\n\t\tp.abra_uloz_pobocka,\n\t\tp.abra_uloz_prepravni_sluzba,\n\t\tp.zone_id,\n\t\tp.balikobot_url,\n\t\tp.balikobot_package_data,\n\t\tp.order_firstname,\n\t\tp.order_lastname,\n\t\tp.order_phone,\n\t\tp.order_email,\n\t\tp.pmstate_id,\n\t\tp.responsibleuser_id,\n\t\tp.responsiblerole_id,\n\t\tp.abra_zasilk_pobocka,\n\t\tp.abra_zasilk_adresa_pobocky,\n\t\tp.abra_email_sent,\n\t\tp.abra_paid,\n\t\tp.abra_paiddate,\n\t\tp.abra_billofdelivery_id,\n\t\tp.source,\n\t\tp.store_id,\n\t\tp.date_created,\n   COALESCE(messunrdcnt.cnt, 0) AS mess_unrd_count,\n   COALESCE(prntthermoordcnt.cnt, 0) AS prnt_therm_ord_count,\n   COALESCE(balordcnt.cnt, 0) AS balikobot_order_count,\n   COALESCE(subordcnt.cnt, 0) AS subscription_order_count,\n   COALESCE(subsubordcnt.cnt, 0) AS subscription_sub_order_count,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(fsubord.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\tSELECT\n           \t  osub.id AS \"id\",\n           \t\tosub.uid AS \"uid\",\n           \t\tosub.source_order_id AS \"sourceOrderId\",\n           \t\tosub.order_id AS \"orderId\",\n           \t\tosub.index AS \"index\",\n           \t\tosub.frequency AS \"frequency\",\n           \t\tosub.externalnumber AS \"externalnumber\",\n           \t\tosub.opened AS \"opened\",\n           \t\tosub.ordered_again AS \"orderedAgain\",\n           \t\tosub.ordered_again_cnt AS \"orderedAgainCnt\",\n           \t\tosub.send_on AS \"sendOn\",\n           \t\tosub.firm AS \"firm\",\n           \t\tosub.city AS \"city\",\n           \t\tosub.house_number AS \"houseNumber\",\n           \t\tosub.street AS \"street\",\n           \t\tosub.postcode AS \"postcode\",\n           \t\tosub.country AS \"country\",\n           \t\tosub.country_code AS \"countryCode\",\n           \t\tosub.email AS \"email\",\n           \t\tosub.phone AS \"phone\",\n           \t\tosub.phone2 AS \"phone2\",\n           \t\tosub.data_box AS \"dataBox\",\n           \t\tosub.display_name AS \"displayName\",\n           \t\tosub.gps AS \"gps\",\n           \t\tosub.location AS \"location\",\n           \t\tosub.recipient AS \"recipient\",\n           \t\tosub.short_address AS \"shortAddress\",\n           \t\tosub.zip AS \"zip\",\n           \t\tosub.note AS \"note\",\n           \t\tosub.date_created AS \"dateCreated\"\n            FROM \n           \t\tabra.order_subscription osub\n\t\t\t\t\t\tWHERE\n\t\t\t\t\t\t\t\tosub.order_id = p.id\n        \t\t\t\t\t) fsubord\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS order_subscriptions\n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       pm.order_id,\n       COUNT(*) AS cnt\n     FROM\n       adm.partner_message pm\n     WHERE\n       pm.read IS NULL\n     GROUP BY\n       pm.order_id\n   ) messunrdcnt ON (messunrdcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       pa.document_id,\n       COUNT(*) AS cnt\n     FROM\n       system.printer_action pa\n     WHERE\n       pa.type = 'PRINT_THERMO' \n       AND \n       pa.document_type = 'BALIKOBOT_PACKAGE' \n     GROUP BY\n       pa.document_id\n   ) prntthermoordcnt ON (prntthermoordcnt.document_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       bo.order_id,\n       COUNT(*) AS cnt\n     FROM\n       balikobot.balikobot_order bo\n     GROUP BY\n       bo.order_id\n   ) balordcnt ON (balordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.order_id\n   ) subordcnt ON (subordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.source_order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.source_order_id\n   ) subsubordcnt ON (subsubordcnt.source_order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.date_created >= NOW() - '12 MONTHS'::INTERVAL \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n\t) \n\t) foo \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderWithInfosMapper.class)
    public List<OrderWithInfosDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14, @Bind(value="offset") int var15, @Bind(value="limit") int var16, @Define(value="order") String var17, @Define(value="sort") String var18);

    @SqlQuery(value="SELECT \n foo.* \n\tFROM (\n SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.accountingtype,\n\t\tp.address_id,\n\t\tp.amount,\n\t\tp.amountwithoutvat,\n\t\tp.bankaccount_id,\n\t\tp.capacity,\n\t\tp.capacityunit,\n\t\tp.classid,\n\t\tp.closed,\n\t\tp.coef,\n\t\tp.confirmed,\n\t\tp.constsymbol_id,\n\t\tp.date_correctedat,\n\t\tp.correctedby_id,\n\t\tp.country_id,\n\t\tp.date_createdat,\n\t\tp.createdby_id,\n\t\tp.currency_id,\n\t\tFLOOR(p.currrate) as currrate,\n\t\tp.currrateinfo,\n\t\tp.dealercategory_id,\n\t\tp.dealerdiscount,\n\t\tp.dealerdiscountkind,\n\t\tp.description,\n\t\tp.dirty,\n\t\tp.discountcalckind,\n\t\tp.displayname,\n\t\tp.date_docdate,\n\t\tp.docqueue_id,\n\t\tp.documentdiscount,\n\t\tp.donotrecalculateunitprice,\n\t\tp.externalnumber,\n\t\tp.financialdiscount,\n\t\tp.firm_id,\n\t\tp.firmoffice_id,\n\t\tp.frozendiscounts,\n\t\tp.intrastatdeliveryterm_id,\n\t\tp.intrastattransactiontype_id,\n\t\tp.intrastattransportationtype_id,\n\t\tp.isaccounted,\n\t\tp.isaccountedlatervat,\n\t\tp.isavailablefordelivery,\n\t\tp.isfinancialdiscount,\n\t\tp.isreversechargedeclared,\n\t\tp.isrowdiscount,\n\t\tp.localamount,\n\t\tp.localamountwithoutvat,\n\t\tp.localcoef,\n\t\tp.localrefcurrency_id,\n\t\tp.localroundingamount,\n\t\tp.localvatamount,\n\t\tp.localzone_id,\n\t\tp.margin,\n\t\tp.newrelateddocument_id,\n\t\tp.newrelatedtype,\n\t\tp.objversion,\n\t\tp.onlywholeorder,\n\t\tp.ordnumber,\n\t\tp.paymenttype_id,\n\t\tp.period_id,\n\t\tp.person_id,\n\t\tp.priceprecision,\n\t\tp.pricesbyref,\n\t\tp.priceswithvat,\n\t\tp.quantitydiscountkind,\n\t\tp.refcurrency_id,\n\t\tp.refcurrrate,\n\t\tp.revided_id,\n\t\tp.revision,\n\t\tp.revisionauthor_id,\n\t\tp.date_revisiondate,\n\t\tp.revisiondescription,\n\t\tp.roundingamount,\n\t\tp.storeprice,\n\t\tp.totaldiscountamount,\n\t\tp.totalrounding,\n\t\tp.tradetype,\n\t\tp.tradetypedescription,\n\t\tp.transportationtype_id,\n\t\tp.vatamount,\n\t\tp.vatcountry_id,\n\t\tp.vatdocument,\n\t\tp.vatfromaboveprecision,\n\t\tp.vatfromabovetype,\n\t\tp.vatrounding,\n\t\tp.weight,\n\t\tp.weightunit,\n\t\tp.abra_address1_id,\n\t\tp.abra_address2_id,\n\t\tp.abra_contacted,\n\t\tp.abra_endeddate,\n\t\tp.abra_params,\n\t\tp.abra_pd_bb_branches,\n\t\tp.abra_pd_bb_modul,\n\t\tp.abra_pd_bb_services,\n\t\tp.abra_pd_status,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.abra_storno,\n\t\tp.abra_uloz_nazev_pobocky,\n\t\tp.abra_uloz_pobocka,\n\t\tp.abra_uloz_prepravni_sluzba,\n\t\tp.zone_id,\n\t\tp.balikobot_url,\n\t\tp.balikobot_package_data,\n\t\tp.order_firstname,\n\t\tp.order_lastname,\n\t\tp.order_phone,\n\t\tp.order_email,\n\t\tp.pmstate_id,\n\t\tp.responsibleuser_id,\n\t\tp.responsiblerole_id,\n\t\tp.abra_zasilk_pobocka,\n\t\tp.abra_zasilk_adresa_pobocky,\n\t\tp.abra_email_sent,\n\t\tp.abra_paid,\n\t\tp.abra_paiddate,\n\t\tp.abra_billofdelivery_id,\n\t\tp.source,\n\t\tp.store_id,\n\t\tp.date_created,\n   COALESCE(messunrdcnt.cnt, 0) AS mess_unrd_count,\n   COALESCE(prntthermoordcnt.cnt, 0) AS prnt_therm_ord_count,\n   COALESCE(balordcnt.cnt, 0) AS balikobot_order_count,\n   COALESCE(subordcnt.cnt, 0) AS subscription_order_count,\n   COALESCE(subsubordcnt.cnt, 0) AS subscription_sub_order_count,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(fsubord.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\tSELECT\n           \t  osub.id AS \"id\",\n           \t\tosub.uid AS \"uid\",\n           \t\tosub.source_order_id AS \"sourceOrderId\",\n           \t\tosub.order_id AS \"orderId\",\n           \t\tosub.index AS \"index\",\n           \t\tosub.frequency AS \"frequency\",\n           \t\tosub.externalnumber AS \"externalnumber\",\n           \t\tosub.opened AS \"opened\",\n           \t\tosub.ordered_again AS \"orderedAgain\",\n           \t\tosub.ordered_again_cnt AS \"orderedAgainCnt\",\n           \t\tosub.send_on AS \"sendOn\",\n           \t\tosub.firm AS \"firm\",\n           \t\tosub.city AS \"city\",\n           \t\tosub.house_number AS \"houseNumber\",\n           \t\tosub.street AS \"street\",\n           \t\tosub.postcode AS \"postcode\",\n           \t\tosub.country AS \"country\",\n           \t\tosub.country_code AS \"countryCode\",\n           \t\tosub.email AS \"email\",\n           \t\tosub.phone AS \"phone\",\n           \t\tosub.phone2 AS \"phone2\",\n           \t\tosub.data_box AS \"dataBox\",\n           \t\tosub.display_name AS \"displayName\",\n           \t\tosub.gps AS \"gps\",\n           \t\tosub.location AS \"location\",\n           \t\tosub.recipient AS \"recipient\",\n           \t\tosub.short_address AS \"shortAddress\",\n           \t\tosub.zip AS \"zip\",\n           \t\tosub.note AS \"note\",\n           \t\tosub.date_created AS \"dateCreated\"\n            FROM \n           \t\tabra.order_subscription osub\n\t\t\t\t\t\tWHERE\n\t\t\t\t\t\t\t\tosub.order_id = p.id\n        \t\t\t\t\t) fsubord\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS order_subscriptions\n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       pm.order_id,\n       COUNT(*) AS cnt\n     FROM\n       adm.partner_message pm\n     WHERE\n       pm.read IS NULL\n     GROUP BY\n       pm.order_id\n   ) messunrdcnt ON (messunrdcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       pa.document_id,\n       COUNT(*) AS cnt\n     FROM\n       system.printer_action pa\n     WHERE\n       pa.type = 'PRINT_THERMO' \n       AND \n       pa.document_type = 'BALIKOBOT_PACKAGE' \n     GROUP BY\n       pa.document_id\n   ) prntthermoordcnt ON (prntthermoordcnt.document_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       bo.order_id,\n       COUNT(*) AS cnt\n     FROM\n       balikobot.balikobot_order bo\n     GROUP BY\n       bo.order_id\n   ) balordcnt ON (balordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.order_id\n   ) subordcnt ON (subordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.source_order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.source_order_id\n   ) subsubordcnt ON (subsubordcnt.source_order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.date_created >= NOW() - '12 MONTHS'::INTERVAL \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n\t) \n\t) foo \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderWithInfosMapper.class)
    public List<OrderWithInfosDomain> findByMaskAppNASRAT(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14, @Bind(value="offset") int var15, @Bind(value="limit") int var16, @Define(value="order") String var17, @Define(value="sort") String var18);

    @SqlQuery(value="SELECT \n foo.* \n\tFROM (\n SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.accountingtype,\n\t\tp.address_id,\n\t\tp.amount,\n\t\tp.amountwithoutvat,\n\t\tp.bankaccount_id,\n\t\tp.capacity,\n\t\tp.capacityunit,\n\t\tp.classid,\n\t\tp.closed,\n\t\tp.coef,\n\t\tp.confirmed,\n\t\tp.constsymbol_id,\n\t\tp.date_correctedat,\n\t\tp.correctedby_id,\n\t\tp.country_id,\n\t\tp.date_createdat,\n\t\tp.createdby_id,\n\t\tp.currency_id,\n\t\tp.currrate,\n\t\tp.currrateinfo,\n\t\tp.dealercategory_id,\n\t\tp.dealerdiscount,\n\t\tp.dealerdiscountkind,\n\t\tp.description,\n\t\tp.dirty,\n\t\tp.discountcalckind,\n\t\tp.displayname,\n\t\tp.date_docdate,\n\t\tp.docqueue_id,\n\t\tp.documentdiscount,\n\t\tp.donotrecalculateunitprice,\n\t\tp.externalnumber,\n\t\tp.financialdiscount,\n\t\tp.firm_id,\n\t\tp.firmoffice_id,\n\t\tp.frozendiscounts,\n\t\tp.intrastatdeliveryterm_id,\n\t\tp.intrastattransactiontype_id,\n\t\tp.intrastattransportationtype_id,\n\t\tp.isaccounted,\n\t\tp.isaccountedlatervat,\n\t\tp.isavailablefordelivery,\n\t\tp.isfinancialdiscount,\n\t\tp.isreversechargedeclared,\n\t\tp.isrowdiscount,\n\t\tp.localamount,\n\t\tp.localamountwithoutvat,\n\t\tp.localcoef,\n\t\tp.localrefcurrency_id,\n\t\tp.localroundingamount,\n\t\tp.localvatamount,\n\t\tp.localzone_id,\n\t\tp.margin,\n\t\tp.newrelateddocument_id,\n\t\tp.newrelatedtype,\n\t\tp.objversion,\n\t\tp.onlywholeorder,\n\t\tp.ordnumber,\n\t\tp.paymenttype_id,\n\t\tp.period_id,\n\t\tp.person_id,\n\t\tp.priceprecision,\n\t\tp.pricesbyref,\n\t\tp.priceswithvat,\n\t\tp.quantitydiscountkind,\n\t\tp.refcurrency_id,\n\t\tp.refcurrrate,\n\t\tp.revided_id,\n\t\tp.revision,\n\t\tp.revisionauthor_id,\n\t\tp.date_revisiondate,\n\t\tp.revisiondescription,\n\t\tp.roundingamount,\n\t\tp.storeprice,\n\t\tp.totaldiscountamount,\n\t\tp.totalrounding,\n\t\tp.tradetype,\n\t\tp.tradetypedescription,\n\t\tp.transportationtype_id,\n\t\tp.vatamount,\n\t\tp.vatcountry_id,\n\t\tp.vatdocument,\n\t\tp.vatfromaboveprecision,\n\t\tp.vatfromabovetype,\n\t\tp.vatrounding,\n\t\tp.weight,\n\t\tp.weightunit,\n\t\tp.abra_address1_id,\n\t\tp.abra_address2_id,\n\t\tp.abra_contacted,\n\t\tp.abra_endeddate,\n\t\tp.abra_params,\n\t\tp.abra_pd_bb_branches,\n\t\tp.abra_pd_bb_modul,\n\t\tp.abra_pd_bb_services,\n\t\tp.abra_pd_status,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.abra_storno,\n\t\tp.abra_uloz_nazev_pobocky,\n\t\tp.abra_uloz_pobocka,\n\t\tp.abra_uloz_prepravni_sluzba,\n\t\tp.zone_id,\n\t\tp.balikobot_url,\n\t\tp.balikobot_package_data,\n\t\tp.order_firstname,\n\t\tp.order_lastname,\n\t\tp.order_phone,\n\t\tp.order_email,\n\t\tp.pmstate_id,\n\t\tp.responsibleuser_id,\n\t\tp.responsiblerole_id,\n\t\tp.abra_zasilk_pobocka,\n\t\tp.abra_zasilk_adresa_pobocky,\n\t\tp.abra_email_sent,\n\t\tp.abra_paid,\n\t\tp.abra_paiddate,\n\t\tp.abra_billofdelivery_id,\n\t\tp.source,\n\t\tp.store_id,\n\t\tp.date_created,\n   COALESCE(messunrdcnt.cnt, 0) AS mess_unrd_count,\n   appordproc.id as order_process_id,\n   appordproc.partner_id as order_process_partner_id,\n   appordproc.status as order_process_status,\n   appordproc.date_started as order_process_date_started,\n   appordproc.date_finished as order_process_date_finished,\n   appordproc.date_updated as order_process_date_updated,\n   appordproc.username as order_process_partner_username,\n   appordproc.firstname as order_process_partner_firstname,\n   appordproc.lastname as order_process_partner_lastname,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(fsub.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\tSELECT\n\t\t\t\t\t\t\t   soa.id as \"id\",\n\t\t\t\t\t\t\t   soa.uid as \"uid\",\n\t\t\t\t\t\t\t   soa.order_id as \"orderId\",\n\t\t\t\t\t\t\t   soa.type as \"type\",\n\t\t\t\t\t\t\t   soa.action as \"action\",\n\t\t\t\t\t\t\t   soa.status as \"status\",\n\t\t\t\t\t\t\t   soa.data as \"data\",\n\t\t\t\t\t\t\t   soa.object_id as \"objectId\",\n\t\t\t\t\t\t\t   soa.object_id_str as \"objectIdStr\",\n\t\t\t\t\t\t\t   soa.date_created as \"dateCreated\"\n\t\t\t\t\t\tFROM\n\t\t\t\t\t\t\t abra.order_actions soa\n\t\t\t\t\t\tWHERE\n\t\t\t\t\t\t\t\tsoa.order_id = p.id\n        \t\t\t\t\t) fsub\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS order_actions\n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT \n       pm.order_id,\n       COUNT(*) AS cnt\n     FROM \n       adm.partner_message pm\n     WHERE \n       pm.read IS NULL\n     GROUP BY\n       pm.order_id\n   ) messunrdcnt ON (messunrdcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT \n       op.id,\n       op.order_id,\n       op.partner_id,\n       op.status,\n       op.date_started,\n       op.date_finished,\n       op.date_updated,\n       prt.username,\n       prt.firstname,\n       prt.lastname\n     FROM \n       app.order_process op \n       LEFT OUTER JOIN adm.partners prt ON (op.partner_id = prt.id) \n   ) appordproc ON (appordproc.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n\t) \n\t) foo \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderWithInfosOrderProcessMapper.class)
    public List<OrderWithInfosOrderProcessDomain> findByMaskApp(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14, @Bind(value="offset") int var15, @Bind(value="limit") int var16, @Define(value="order") String var17, @Define(value="sort") String var18);

    @SqlQuery(value="SELECT \n foo.* \n\tFROM (\n SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.accountingtype,\n\t\tp.address_id,\n\t\tp.amount,\n\t\tp.amountwithoutvat,\n\t\tp.bankaccount_id,\n\t\tp.capacity,\n\t\tp.capacityunit,\n\t\tp.classid,\n\t\tp.closed,\n\t\tp.coef,\n\t\tp.confirmed,\n\t\tp.constsymbol_id,\n\t\tp.date_correctedat,\n\t\tp.correctedby_id,\n\t\tp.country_id,\n\t\tp.date_createdat,\n\t\tp.createdby_id,\n\t\tp.currency_id,\n\t\tp.currrate,\n\t\tp.currrateinfo,\n\t\tp.dealercategory_id,\n\t\tp.dealerdiscount,\n\t\tp.dealerdiscountkind,\n\t\tp.description,\n\t\tp.dirty,\n\t\tp.discountcalckind,\n\t\tp.displayname,\n\t\tp.date_docdate,\n\t\tp.docqueue_id,\n\t\tp.documentdiscount,\n\t\tp.donotrecalculateunitprice,\n\t\tp.externalnumber,\n\t\tp.financialdiscount,\n\t\tp.firm_id,\n\t\tp.firmoffice_id,\n\t\tp.frozendiscounts,\n\t\tp.intrastatdeliveryterm_id,\n\t\tp.intrastattransactiontype_id,\n\t\tp.intrastattransportationtype_id,\n\t\tp.isaccounted,\n\t\tp.isaccountedlatervat,\n\t\tp.isavailablefordelivery,\n\t\tp.isfinancialdiscount,\n\t\tp.isreversechargedeclared,\n\t\tp.isrowdiscount,\n\t\tp.localamount,\n\t\tp.localamountwithoutvat,\n\t\tp.localcoef,\n\t\tp.localrefcurrency_id,\n\t\tp.localroundingamount,\n\t\tp.localvatamount,\n\t\tp.localzone_id,\n\t\tp.margin,\n\t\tp.newrelateddocument_id,\n\t\tp.newrelatedtype,\n\t\tp.objversion,\n\t\tp.onlywholeorder,\n\t\tp.ordnumber,\n\t\tp.paymenttype_id,\n\t\tp.period_id,\n\t\tp.person_id,\n\t\tp.priceprecision,\n\t\tp.pricesbyref,\n\t\tp.priceswithvat,\n\t\tp.quantitydiscountkind,\n\t\tp.refcurrency_id,\n\t\tp.refcurrrate,\n\t\tp.revided_id,\n\t\tp.revision,\n\t\tp.revisionauthor_id,\n\t\tp.date_revisiondate,\n\t\tp.revisiondescription,\n\t\tp.roundingamount,\n\t\tp.storeprice,\n\t\tp.totaldiscountamount,\n\t\tp.totalrounding,\n\t\tp.tradetype,\n\t\tp.tradetypedescription,\n\t\tp.transportationtype_id,\n\t\tp.vatamount,\n\t\tp.vatcountry_id,\n\t\tp.vatdocument,\n\t\tp.vatfromaboveprecision,\n\t\tp.vatfromabovetype,\n\t\tp.vatrounding,\n\t\tp.weight,\n\t\tp.weightunit,\n\t\tp.abra_address1_id,\n\t\tp.abra_address2_id,\n\t\tp.abra_contacted,\n\t\tp.abra_endeddate,\n\t\tp.abra_params,\n\t\tp.abra_pd_bb_branches,\n\t\tp.abra_pd_bb_modul,\n\t\tp.abra_pd_bb_services,\n\t\tp.abra_pd_status,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.abra_storno,\n\t\tp.abra_uloz_nazev_pobocky,\n\t\tp.abra_uloz_pobocka,\n\t\tp.abra_uloz_prepravni_sluzba,\n\t\tp.zone_id,\n\t\tp.balikobot_url,\n\t\tp.balikobot_package_data,\n\t\tp.order_firstname,\n\t\tp.order_lastname,\n\t\tp.order_phone,\n\t\tp.order_email,\n\t\tp.pmstate_id,\n\t\tp.responsibleuser_id,\n\t\tp.responsiblerole_id,\n\t\tp.abra_zasilk_pobocka,\n\t\tp.abra_zasilk_adresa_pobocky,\n\t\tp.abra_email_sent,\n\t\tp.abra_paid,\n\t\tp.abra_paiddate,\n\t\tp.abra_billofdelivery_id,\n\t\tp.source,\n\t\tp.store_id,\n\t\tp.date_created,\n   COALESCE(messunrdcnt.cnt, 0) AS mess_unrd_count,\n   COALESCE(prntthermoordcnt.cnt, 0) AS prnt_therm_ord_count,\n   COALESCE(balordcnt.cnt, 0) AS balikobot_order_count,\n   COALESCE(subordcnt.cnt, 0) AS subscription_order_count,\n   COALESCE(subsubordcnt.cnt, 0) AS subscription_sub_order_count,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(fsubord.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\tSELECT\n           \t  osub.id AS \"id\",\n           \t\tosub.uid AS \"uid\",\n           \t\tosub.source_order_id AS \"sourceOrderId\",\n           \t\tosub.order_id AS \"orderId\",\n           \t\tosub.index AS \"index\",\n           \t\tosub.frequency AS \"frequency\",\n           \t\tosub.externalnumber AS \"externalnumber\",\n           \t\tosub.opened AS \"opened\",\n           \t\tosub.ordered_again AS \"orderedAgain\",\n           \t\tosub.ordered_again_cnt AS \"orderedAgainCnt\",\n           \t\tosub.send_on AS \"sendOn\",\n           \t\tosub.firm AS \"firm\",\n           \t\tosub.city AS \"city\",\n           \t\tosub.house_number AS \"houseNumber\",\n           \t\tosub.street AS \"street\",\n           \t\tosub.postcode AS \"postcode\",\n           \t\tosub.country AS \"country\",\n           \t\tosub.country_code AS \"countryCode\",\n           \t\tosub.email AS \"email\",\n           \t\tosub.phone AS \"phone\",\n           \t\tosub.phone2 AS \"phone2\",\n           \t\tosub.data_box AS \"dataBox\",\n           \t\tosub.display_name AS \"displayName\",\n           \t\tosub.gps AS \"gps\",\n           \t\tosub.location AS \"location\",\n           \t\tosub.recipient AS \"recipient\",\n           \t\tosub.short_address AS \"shortAddress\",\n           \t\tosub.zip AS \"zip\",\n           \t\tosub.note AS \"note\",\n           \t\tosub.date_created AS \"dateCreated\"\n            FROM \n           \t\tabra.order_subscription osub\n\t\t\t\t\t\tWHERE\n\t\t\t\t\t\t\t\tosub.order_id = p.id\n        \t\t\t\t\t) fsubord\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS order_subscriptions\n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       pm.order_id,\n       COUNT(*) AS cnt\n     FROM\n       adm.partner_message pm\n     WHERE\n       pm.read IS NULL\n     GROUP BY\n       pm.order_id\n   ) messunrdcnt ON (messunrdcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       pa.document_id,\n       COUNT(*) AS cnt\n     FROM\n       system.printer_action pa\n     WHERE\n       pa.type = 'PRINT_THERMO' \n       AND \n       pa.document_type = 'BALIKOBOT_PACKAGE' \n     GROUP BY\n       pa.document_id\n   ) prntthermoordcnt ON (prntthermoordcnt.document_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       bo.order_id,\n       COUNT(*) AS cnt\n     FROM\n       balikobot.balikobot_order bo\n     GROUP BY\n       bo.order_id\n   ) balordcnt ON (balordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.order_id\n   ) subordcnt ON (subordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.source_order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.source_order_id\n   ) subsubordcnt ON (subsubordcnt.source_order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.source LIKE 'BEERSHOP%' \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n\t) \n\t) foo \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderWithInfosMapper.class)
    public List<OrderWithInfosDomain> findByMaskBShop(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14, @Bind(value="offset") int var15, @Bind(value="limit") int var16, @Define(value="order") String var17, @Define(value="sort") String var18);

    @SqlQuery(value="SELECT \n foo.* \n\tFROM (\n SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.accountingtype,\n\t\tp.address_id,\n\t\tp.amount,\n\t\tp.amountwithoutvat,\n\t\tp.bankaccount_id,\n\t\tp.capacity,\n\t\tp.capacityunit,\n\t\tp.classid,\n\t\tp.closed,\n\t\tp.coef,\n\t\tp.confirmed,\n\t\tp.constsymbol_id,\n\t\tp.date_correctedat,\n\t\tp.correctedby_id,\n\t\tp.country_id,\n\t\tp.date_createdat,\n\t\tp.createdby_id,\n\t\tp.currency_id,\n\t\tFLOOR(p.currrate) as currrate,\n\t\tp.currrateinfo,\n\t\tp.dealercategory_id,\n\t\tp.dealerdiscount,\n\t\tp.dealerdiscountkind,\n\t\tp.description,\n\t\tp.dirty,\n\t\tp.discountcalckind,\n\t\tp.displayname,\n\t\tp.date_docdate,\n\t\tp.docqueue_id,\n\t\tp.documentdiscount,\n\t\tp.donotrecalculateunitprice,\n\t\tp.externalnumber,\n\t\tp.financialdiscount,\n\t\tp.firm_id,\n\t\tp.firmoffice_id,\n\t\tp.frozendiscounts,\n\t\tp.intrastatdeliveryterm_id,\n\t\tp.intrastattransactiontype_id,\n\t\tp.intrastattransportationtype_id,\n\t\tp.isaccounted,\n\t\tp.isaccountedlatervat,\n\t\tp.isavailablefordelivery,\n\t\tp.isfinancialdiscount,\n\t\tp.isreversechargedeclared,\n\t\tp.isrowdiscount,\n\t\tp.localamount,\n\t\tp.localamountwithoutvat,\n\t\tp.localcoef,\n\t\tp.localrefcurrency_id,\n\t\tp.localroundingamount,\n\t\tp.localvatamount,\n\t\tp.localzone_id,\n\t\tp.margin,\n\t\tp.newrelateddocument_id,\n\t\tp.newrelatedtype,\n\t\tp.objversion,\n\t\tp.onlywholeorder,\n\t\tp.ordnumber,\n\t\tp.paymenttype_id,\n\t\tp.period_id,\n\t\tp.person_id,\n\t\tp.priceprecision,\n\t\tp.pricesbyref,\n\t\tp.priceswithvat,\n\t\tp.quantitydiscountkind,\n\t\tp.refcurrency_id,\n\t\tp.refcurrrate,\n\t\tp.revided_id,\n\t\tp.revision,\n\t\tp.revisionauthor_id,\n\t\tp.date_revisiondate,\n\t\tp.revisiondescription,\n\t\tp.roundingamount,\n\t\tp.storeprice,\n\t\tp.totaldiscountamount,\n\t\tp.totalrounding,\n\t\tp.tradetype,\n\t\tp.tradetypedescription,\n\t\tp.transportationtype_id,\n\t\tp.vatamount,\n\t\tp.vatcountry_id,\n\t\tp.vatdocument,\n\t\tp.vatfromaboveprecision,\n\t\tp.vatfromabovetype,\n\t\tp.vatrounding,\n\t\tp.weight,\n\t\tp.weightunit,\n\t\tp.abra_address1_id,\n\t\tp.abra_address2_id,\n\t\tp.abra_contacted,\n\t\tp.abra_endeddate,\n\t\tp.abra_params,\n\t\tp.abra_pd_bb_branches,\n\t\tp.abra_pd_bb_modul,\n\t\tp.abra_pd_bb_services,\n\t\tp.abra_pd_status,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.abra_storno,\n\t\tp.abra_uloz_nazev_pobocky,\n\t\tp.abra_uloz_pobocka,\n\t\tp.abra_uloz_prepravni_sluzba,\n\t\tp.zone_id,\n\t\tp.balikobot_url,\n\t\tp.balikobot_package_data,\n\t\tp.order_firstname,\n\t\tp.order_lastname,\n\t\tp.order_phone,\n\t\tp.order_email,\n\t\tp.pmstate_id,\n\t\tp.responsibleuser_id,\n\t\tp.responsiblerole_id,\n\t\tp.abra_zasilk_pobocka,\n\t\tp.abra_zasilk_adresa_pobocky,\n\t\tp.abra_email_sent,\n\t\tp.abra_paid,\n\t\tp.abra_paiddate,\n\t\tp.abra_billofdelivery_id,\n\t\tp.source,\n\t\tp.store_id,\n\t\tp.date_created,\n   COALESCE(messunrdcnt.cnt, 0) AS mess_unrd_count,\n   COALESCE(prntthermoordcnt.cnt, 0) AS prnt_therm_ord_count,\n   COALESCE(balordcnt.cnt, 0) AS balikobot_order_count,\n   COALESCE(subordcnt.cnt, 0) AS subscription_order_count,\n   COALESCE(subsubordcnt.cnt, 0) AS subscription_sub_order_count,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(fsubord.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\tSELECT\n           \t  osub.id AS \"id\",\n           \t\tosub.uid AS \"uid\",\n           \t\tosub.source_order_id AS \"sourceOrderId\",\n           \t\tosub.order_id AS \"orderId\",\n           \t\tosub.index AS \"index\",\n           \t\tosub.frequency AS \"frequency\",\n           \t\tosub.externalnumber AS \"externalnumber\",\n           \t\tosub.opened AS \"opened\",\n           \t\tosub.ordered_again AS \"orderedAgain\",\n           \t\tosub.ordered_again_cnt AS \"orderedAgainCnt\",\n           \t\tosub.send_on AS \"sendOn\",\n           \t\tosub.firm AS \"firm\",\n           \t\tosub.city AS \"city\",\n           \t\tosub.house_number AS \"houseNumber\",\n           \t\tosub.street AS \"street\",\n           \t\tosub.postcode AS \"postcode\",\n           \t\tosub.country AS \"country\",\n           \t\tosub.country_code AS \"countryCode\",\n           \t\tosub.email AS \"email\",\n           \t\tosub.phone AS \"phone\",\n           \t\tosub.phone2 AS \"phone2\",\n           \t\tosub.data_box AS \"dataBox\",\n           \t\tosub.display_name AS \"displayName\",\n           \t\tosub.gps AS \"gps\",\n           \t\tosub.location AS \"location\",\n           \t\tosub.recipient AS \"recipient\",\n           \t\tosub.short_address AS \"shortAddress\",\n           \t\tosub.zip AS \"zip\",\n           \t\tosub.note AS \"note\",\n           \t\tosub.date_created AS \"dateCreated\"\n            FROM \n           \t\tabra.order_subscription osub\n\t\t\t\t\t\tWHERE\n\t\t\t\t\t\t\t\tosub.order_id = p.id\n        \t\t\t\t\t) fsubord\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS order_subscriptions\n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       pm.order_id,\n       COUNT(*) AS cnt\n     FROM\n       adm.partner_message pm\n     WHERE\n       pm.read IS NULL\n     GROUP BY\n       pm.order_id\n   ) messunrdcnt ON (messunrdcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       pa.document_id,\n       COUNT(*) AS cnt\n     FROM\n       system.printer_action pa\n     WHERE\n       pa.type = 'PRINT_THERMO' \n       AND \n       pa.document_type = 'BALIKOBOT_PACKAGE' \n     GROUP BY\n       pa.document_id\n   ) prntthermoordcnt ON (prntthermoordcnt.document_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       bo.order_id,\n       COUNT(*) AS cnt\n     FROM\n       balikobot.balikobot_order bo\n     GROUP BY\n       bo.order_id\n   ) balordcnt ON (balordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.order_id\n   ) subordcnt ON (subordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.source_order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.source_order_id\n   ) subsubordcnt ON (subsubordcnt.source_order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.source LIKE 'BEERSHOP%' \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n\t) \n\t) foo \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderWithInfosMapper.class)
    public List<OrderWithInfosDomain> findByMaskBShopApp(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14, @Bind(value="offset") int var15, @Bind(value="limit") int var16, @Define(value="order") String var17, @Define(value="sort") String var18);

    @SqlQuery(value="SELECT \n foo.* \n\tFROM (\n SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.accountingtype,\n\t\tp.address_id,\n\t\tp.amount,\n\t\tp.amountwithoutvat,\n\t\tp.bankaccount_id,\n\t\tp.capacity,\n\t\tp.capacityunit,\n\t\tp.classid,\n\t\tp.closed,\n\t\tp.coef,\n\t\tp.confirmed,\n\t\tp.constsymbol_id,\n\t\tp.date_correctedat,\n\t\tp.correctedby_id,\n\t\tp.country_id,\n\t\tp.date_createdat,\n\t\tp.createdby_id,\n\t\tp.currency_id,\n\t\tp.currrate,\n\t\tp.currrateinfo,\n\t\tp.dealercategory_id,\n\t\tp.dealerdiscount,\n\t\tp.dealerdiscountkind,\n\t\tp.description,\n\t\tp.dirty,\n\t\tp.discountcalckind,\n\t\tp.displayname,\n\t\tp.date_docdate,\n\t\tp.docqueue_id,\n\t\tp.documentdiscount,\n\t\tp.donotrecalculateunitprice,\n\t\tp.externalnumber,\n\t\tp.financialdiscount,\n\t\tp.firm_id,\n\t\tp.firmoffice_id,\n\t\tp.frozendiscounts,\n\t\tp.intrastatdeliveryterm_id,\n\t\tp.intrastattransactiontype_id,\n\t\tp.intrastattransportationtype_id,\n\t\tp.isaccounted,\n\t\tp.isaccountedlatervat,\n\t\tp.isavailablefordelivery,\n\t\tp.isfinancialdiscount,\n\t\tp.isreversechargedeclared,\n\t\tp.isrowdiscount,\n\t\tp.localamount,\n\t\tp.localamountwithoutvat,\n\t\tp.localcoef,\n\t\tp.localrefcurrency_id,\n\t\tp.localroundingamount,\n\t\tp.localvatamount,\n\t\tp.localzone_id,\n\t\tp.margin,\n\t\tp.newrelateddocument_id,\n\t\tp.newrelatedtype,\n\t\tp.objversion,\n\t\tp.onlywholeorder,\n\t\tp.ordnumber,\n\t\tp.paymenttype_id,\n\t\tp.period_id,\n\t\tp.person_id,\n\t\tp.priceprecision,\n\t\tp.pricesbyref,\n\t\tp.priceswithvat,\n\t\tp.quantitydiscountkind,\n\t\tp.refcurrency_id,\n\t\tp.refcurrrate,\n\t\tp.revided_id,\n\t\tp.revision,\n\t\tp.revisionauthor_id,\n\t\tp.date_revisiondate,\n\t\tp.revisiondescription,\n\t\tp.roundingamount,\n\t\tp.storeprice,\n\t\tp.totaldiscountamount,\n\t\tp.totalrounding,\n\t\tp.tradetype,\n\t\tp.tradetypedescription,\n\t\tp.transportationtype_id,\n\t\tp.vatamount,\n\t\tp.vatcountry_id,\n\t\tp.vatdocument,\n\t\tp.vatfromaboveprecision,\n\t\tp.vatfromabovetype,\n\t\tp.vatrounding,\n\t\tp.weight,\n\t\tp.weightunit,\n\t\tp.abra_address1_id,\n\t\tp.abra_address2_id,\n\t\tp.abra_contacted,\n\t\tp.abra_endeddate,\n\t\tp.abra_params,\n\t\tp.abra_pd_bb_branches,\n\t\tp.abra_pd_bb_modul,\n\t\tp.abra_pd_bb_services,\n\t\tp.abra_pd_status,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.abra_storno,\n\t\tp.abra_uloz_nazev_pobocky,\n\t\tp.abra_uloz_pobocka,\n\t\tp.abra_uloz_prepravni_sluzba,\n\t\tp.zone_id,\n\t\tp.balikobot_url,\n\t\tp.balikobot_package_data,\n\t\tp.order_firstname,\n\t\tp.order_lastname,\n\t\tp.order_phone,\n\t\tp.order_email,\n\t\tp.pmstate_id,\n\t\tp.responsibleuser_id,\n\t\tp.responsiblerole_id,\n\t\tp.abra_zasilk_pobocka,\n\t\tp.abra_zasilk_adresa_pobocky,\n\t\tp.abra_email_sent,\n\t\tp.abra_paid,\n\t\tp.abra_paiddate,\n\t\tp.abra_billofdelivery_id,\n\t\tp.source,\n\t\tp.store_id,\n\t\tp.date_created,\n   COALESCE(messunrdcnt.cnt, 0) AS mess_unrd_count,\n   COALESCE(prntthermoordcnt.cnt, 0) AS prnt_therm_ord_count,\n   COALESCE(balordcnt.cnt, 0) AS balikobot_order_count,\n   COALESCE(subordcnt.cnt, 0) AS subscription_order_count,\n   COALESCE(subsubordcnt.cnt, 0) AS subscription_sub_order_count,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(fsubord.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\tSELECT\n           \t  osub.id AS \"id\",\n           \t\tosub.uid AS \"uid\",\n           \t\tosub.source_order_id AS \"sourceOrderId\",\n           \t\tosub.order_id AS \"orderId\",\n           \t\tosub.index AS \"index\",\n           \t\tosub.frequency AS \"frequency\",\n           \t\tosub.externalnumber AS \"externalnumber\",\n           \t\tosub.opened AS \"opened\",\n           \t\tosub.ordered_again AS \"orderedAgain\",\n           \t\tosub.ordered_again_cnt AS \"orderedAgainCnt\",\n           \t\tosub.send_on AS \"sendOn\",\n           \t\tosub.firm AS \"firm\",\n           \t\tosub.city AS \"city\",\n           \t\tosub.house_number AS \"houseNumber\",\n           \t\tosub.street AS \"street\",\n           \t\tosub.postcode AS \"postcode\",\n           \t\tosub.country AS \"country\",\n           \t\tosub.country_code AS \"countryCode\",\n           \t\tosub.email AS \"email\",\n           \t\tosub.phone AS \"phone\",\n           \t\tosub.phone2 AS \"phone2\",\n           \t\tosub.data_box AS \"dataBox\",\n           \t\tosub.display_name AS \"displayName\",\n           \t\tosub.gps AS \"gps\",\n           \t\tosub.location AS \"location\",\n           \t\tosub.recipient AS \"recipient\",\n           \t\tosub.short_address AS \"shortAddress\",\n           \t\tosub.zip AS \"zip\",\n           \t\tosub.note AS \"note\",\n           \t\tosub.date_created AS \"dateCreated\"\n            FROM \n           \t\tabra.order_subscription osub\n\t\t\t\t\t\tWHERE\n\t\t\t\t\t\t\t\tosub.order_id = p.id\n        \t\t\t\t\t) fsubord\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS order_subscriptions\n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       pm.order_id,\n       COUNT(*) AS cnt\n     FROM\n       adm.partner_message pm\n     WHERE\n       pm.read IS NULL\n     GROUP BY\n       pm.order_id\n   ) messunrdcnt ON (messunrdcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       pa.document_id,\n       COUNT(*) AS cnt\n     FROM\n       system.printer_action pa\n     WHERE\n       pa.type = 'PRINT_THERMO' \n       AND \n       pa.document_type = 'BALIKOBOT_PACKAGE' \n     GROUP BY\n       pa.document_id\n   ) prntthermoordcnt ON (prntthermoordcnt.document_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       bo.order_id,\n       COUNT(*) AS cnt\n     FROM\n       balikobot.balikobot_order bo\n     GROUP BY\n       bo.order_id\n   ) balordcnt ON (balordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.order_id\n   ) subordcnt ON (subordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.source_order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.source_order_id\n   ) subsubordcnt ON (subsubordcnt.source_order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.source LIKE 'DELIKATESY%' \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n\t) \n\t) foo \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderWithInfosMapper.class)
    public List<OrderWithInfosDomain> findByMaskShop(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14, @Bind(value="offset") int var15, @Bind(value="limit") int var16, @Define(value="order") String var17, @Define(value="sort") String var18);

    @SqlQuery(value="SELECT \n foo.* \n\tFROM (\n SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.accountingtype,\n\t\tp.address_id,\n\t\tp.amount,\n\t\tp.amountwithoutvat,\n\t\tp.bankaccount_id,\n\t\tp.capacity,\n\t\tp.capacityunit,\n\t\tp.classid,\n\t\tp.closed,\n\t\tp.coef,\n\t\tp.confirmed,\n\t\tp.constsymbol_id,\n\t\tp.date_correctedat,\n\t\tp.correctedby_id,\n\t\tp.country_id,\n\t\tp.date_createdat,\n\t\tp.createdby_id,\n\t\tp.currency_id,\n\t\tFLOOR(p.currrate) as currrate,\n\t\tp.currrateinfo,\n\t\tp.dealercategory_id,\n\t\tp.dealerdiscount,\n\t\tp.dealerdiscountkind,\n\t\tp.description,\n\t\tp.dirty,\n\t\tp.discountcalckind,\n\t\tp.displayname,\n\t\tp.date_docdate,\n\t\tp.docqueue_id,\n\t\tp.documentdiscount,\n\t\tp.donotrecalculateunitprice,\n\t\tp.externalnumber,\n\t\tp.financialdiscount,\n\t\tp.firm_id,\n\t\tp.firmoffice_id,\n\t\tp.frozendiscounts,\n\t\tp.intrastatdeliveryterm_id,\n\t\tp.intrastattransactiontype_id,\n\t\tp.intrastattransportationtype_id,\n\t\tp.isaccounted,\n\t\tp.isaccountedlatervat,\n\t\tp.isavailablefordelivery,\n\t\tp.isfinancialdiscount,\n\t\tp.isreversechargedeclared,\n\t\tp.isrowdiscount,\n\t\tp.localamount,\n\t\tp.localamountwithoutvat,\n\t\tp.localcoef,\n\t\tp.localrefcurrency_id,\n\t\tp.localroundingamount,\n\t\tp.localvatamount,\n\t\tp.localzone_id,\n\t\tp.margin,\n\t\tp.newrelateddocument_id,\n\t\tp.newrelatedtype,\n\t\tp.objversion,\n\t\tp.onlywholeorder,\n\t\tp.ordnumber,\n\t\tp.paymenttype_id,\n\t\tp.period_id,\n\t\tp.person_id,\n\t\tp.priceprecision,\n\t\tp.pricesbyref,\n\t\tp.priceswithvat,\n\t\tp.quantitydiscountkind,\n\t\tp.refcurrency_id,\n\t\tp.refcurrrate,\n\t\tp.revided_id,\n\t\tp.revision,\n\t\tp.revisionauthor_id,\n\t\tp.date_revisiondate,\n\t\tp.revisiondescription,\n\t\tp.roundingamount,\n\t\tp.storeprice,\n\t\tp.totaldiscountamount,\n\t\tp.totalrounding,\n\t\tp.tradetype,\n\t\tp.tradetypedescription,\n\t\tp.transportationtype_id,\n\t\tp.vatamount,\n\t\tp.vatcountry_id,\n\t\tp.vatdocument,\n\t\tp.vatfromaboveprecision,\n\t\tp.vatfromabovetype,\n\t\tp.vatrounding,\n\t\tp.weight,\n\t\tp.weightunit,\n\t\tp.abra_address1_id,\n\t\tp.abra_address2_id,\n\t\tp.abra_contacted,\n\t\tp.abra_endeddate,\n\t\tp.abra_params,\n\t\tp.abra_pd_bb_branches,\n\t\tp.abra_pd_bb_modul,\n\t\tp.abra_pd_bb_services,\n\t\tp.abra_pd_status,\n\t\tp.abra_stav_objednavky_id,\n\t\tp.abra_storno,\n\t\tp.abra_uloz_nazev_pobocky,\n\t\tp.abra_uloz_pobocka,\n\t\tp.abra_uloz_prepravni_sluzba,\n\t\tp.zone_id,\n\t\tp.balikobot_url,\n\t\tp.balikobot_package_data,\n\t\tp.order_firstname,\n\t\tp.order_lastname,\n\t\tp.order_phone,\n\t\tp.order_email,\n\t\tp.pmstate_id,\n\t\tp.responsibleuser_id,\n\t\tp.responsiblerole_id,\n\t\tp.abra_zasilk_pobocka,\n\t\tp.abra_zasilk_adresa_pobocky,\n\t\tp.abra_email_sent,\n\t\tp.abra_paid,\n\t\tp.abra_paiddate,\n\t\tp.abra_billofdelivery_id,\n\t\tp.source,\n\t\tp.store_id,\n\t\tp.date_created,\n   COALESCE(messunrdcnt.cnt, 0) AS mess_unrd_count,\n   COALESCE(prntthermoordcnt.cnt, 0) AS prnt_therm_ord_count,\n   COALESCE(balordcnt.cnt, 0) AS balikobot_order_count,\n   COALESCE(subordcnt.cnt, 0) AS subscription_order_count,\n   COALESCE(subsubordcnt.cnt, 0) AS subscription_sub_order_count,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(fsubord.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\tSELECT\n           \t  osub.id AS \"id\",\n           \t\tosub.uid AS \"uid\",\n           \t\tosub.source_order_id AS \"sourceOrderId\",\n           \t\tosub.order_id AS \"orderId\",\n           \t\tosub.index AS \"index\",\n           \t\tosub.frequency AS \"frequency\",\n           \t\tosub.externalnumber AS \"externalnumber\",\n           \t\tosub.opened AS \"opened\",\n           \t\tosub.ordered_again AS \"orderedAgain\",\n           \t\tosub.ordered_again_cnt AS \"orderedAgainCnt\",\n           \t\tosub.send_on AS \"sendOn\",\n           \t\tosub.firm AS \"firm\",\n           \t\tosub.city AS \"city\",\n           \t\tosub.house_number AS \"houseNumber\",\n           \t\tosub.street AS \"street\",\n           \t\tosub.postcode AS \"postcode\",\n           \t\tosub.country AS \"country\",\n           \t\tosub.country_code AS \"countryCode\",\n           \t\tosub.email AS \"email\",\n           \t\tosub.phone AS \"phone\",\n           \t\tosub.phone2 AS \"phone2\",\n           \t\tosub.data_box AS \"dataBox\",\n           \t\tosub.display_name AS \"displayName\",\n           \t\tosub.gps AS \"gps\",\n           \t\tosub.location AS \"location\",\n           \t\tosub.recipient AS \"recipient\",\n           \t\tosub.short_address AS \"shortAddress\",\n           \t\tosub.zip AS \"zip\",\n           \t\tosub.note AS \"note\",\n           \t\tosub.date_created AS \"dateCreated\"\n            FROM \n           \t\tabra.order_subscription osub\n\t\t\t\t\t\tWHERE\n\t\t\t\t\t\t\t\tosub.order_id = p.id\n        \t\t\t\t\t) fsubord\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS order_subscriptions\n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       pm.order_id,\n       COUNT(*) AS cnt\n     FROM\n       adm.partner_message pm\n     WHERE\n       pm.read IS NULL\n     GROUP BY\n       pm.order_id\n   ) messunrdcnt ON (messunrdcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       pa.document_id,\n       COUNT(*) AS cnt\n     FROM\n       system.printer_action pa\n     WHERE\n       pa.type = 'PRINT_THERMO' \n       AND \n       pa.document_type = 'BALIKOBOT_PACKAGE' \n     GROUP BY\n       pa.document_id\n   ) prntthermoordcnt ON (prntthermoordcnt.document_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       bo.order_id,\n       COUNT(*) AS cnt\n     FROM\n       balikobot.balikobot_order bo\n     GROUP BY\n       bo.order_id\n   ) balordcnt ON (balordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.order_id\n   ) subordcnt ON (subordcnt.order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       os.source_order_id,\n       COUNT(*) AS cnt\n     FROM\n       abra.order_subscription os\n     GROUP BY\n       os.source_order_id\n   ) subsubordcnt ON (subsubordcnt.source_order_id = p.id)\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.source LIKE 'DELIKATESY%' \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n\t) \n\t) foo \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderWithInfosMapper.class)
    public List<OrderWithInfosDomain> findByMaskShopApp(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14, @Bind(value="offset") int var15, @Bind(value="limit") int var16, @Define(value="order") String var17, @Define(value="sort") String var18);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.date_created >= NOW() - '12 MONTHS'::INTERVAL \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n )\n")
    public long findByMaskCount(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.source LIKE 'BEERSHOP%' \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(p.order_firstname::text) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n )\n")
    public long findByMaskBShopCount(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.orders p\n   LEFT OUTER JOIN (\n     SELECT\n       oi.order_id,\n       oi.cnt_rows,\n       oi.sum_quantity\n     FROM\n       abra.view_orders_find_all_oiscnt oi\n   ) oiscnt ON (oiscnt.order_id = p.id)\n\tWHERE \n\t\tp.source LIKE 'DELIKATESY%' \n\tAND  \n\t\t(CASE WHEN :transportationTypeId = 'ALL' THEN TRUE ELSE (CASE WHEN :transportationTypeId = 'LIST' THEN p.transportationtype_id IN (<transportations>) ELSE (p.transportationtype_id = :transportationTypeId) END) END) \n\tAND  \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND  \n\t\t(CASE WHEN :nullQuantity = 'ALL' THEN TRUE ELSE ( p.id IN ( SELECT oi1.order_id FROM abra.order_items oi1 INNER JOIN abra.store_cards sc1 ON (sc1.abra_id = oi1.storecard_id) WHERE sc1.abra_exportnullquantity = (CASE WHEN :nullQuantity = 'true' THEN true ELSE false END) GROUP BY oi1.order_id ) ) END) \n\tAND  \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \tAND  \n   p.amount >= :priceGte AND p.amount <= :priceLte \n\tAND  \n   COALESCE(oiscnt.sum_quantity, 0) > :countItemsGte AND COALESCE(oiscnt.sum_quantity, 0) < :countItemsLte \n\tAND  \n\t\t(CASE WHEN :findPlu = 'ALL' THEN TRUE ELSE (p.id IN ( SELECT oip.order_id FROM abra.order_items oip INNER JOIN abra.store_cards oisc ON (oip.storecard_id = oisc.abra_id) WHERE oip.date_created >= NOW() - '12 MONTHS'::INTERVAL AND oip.storecard_id IS NOT NULL AND oisc.code IN (<plus>) GROUP BY oip.order_id )) END) \n\tAND ( \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tunaccent(p.displayname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_firstname::text) ~* :mask \n\tOR \n\t\tunaccent(p.order_lastname::text) ~* :mask \n\tOR \n\t\tLOWER(unaccent(unaccent(p.order_firstname::text)) || '%' || unaccent(p.order_lastname::text)) LIKE LOWER( :names ) \n\tOR \n\t\tLOWER(p.abra_params::text) LIKE LOWER('%Jm%no: %' || :mask || '%') \n\tOR \n\t\tLOWER(p.balikobot_package_data::text) LIKE LOWER('%' || :mask || '%') \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.abra_params::text ~* :mask \n\tOR \n\t\tp.id IN ( SELECT oi.order_id FROM abra.order_items oi INNER JOIN abra.store_cards sc ON (sc.abra_id = oi.storecard_id) WHERE sc.plu::TEXT ~* :mask OR sc.name::TEXT ~* :mask GROUP BY oi.order_id ) \n )\n")
    public long findByMaskShopCount(@Bind(value="mask") String var1, @Bind(value="names") String var2, @Bind(value="transportationTypeId") String var3, @BindList(value="transportations") List<String> var4, @Bind(value="stavObjednavkyId") String var5, @Bind(value="nullQuantity") String var6, @Bind(value="createdGte") BigDecimal var7, @Bind(value="createdLte") BigDecimal var8, @Bind(value="priceGte") Long var9, @Bind(value="priceLte") Long var10, @Bind(value="countItemsGte") Long var11, @Bind(value="countItemsLte") Long var12, @Bind(value="findPlu") String var13, @BindList(value="plus") List<String> var14);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.orders p\n\tWHERE \n\t\t(CASE WHEN :stavObjednavkyId = 'ALL' THEN TRUE ELSE (CASE WHEN :stavObjednavkyId = 'NULL' THEN (p.abra_stav_objednavky_id IS NULL) ELSE (p.abra_stav_objednavky_id = :stavObjednavkyId) END) END) \n\tAND \n\t\tp.date_created >= (NOW() - '24 hours'::interval) \n")
    public long getCountByStavObjednavkyIdAndTime(@Bind(value="stavObjednavkyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p ORDER BY p.id DESC LIMIT 1000")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListBy1000Newest();

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p WHERE p.date_created >= NOW() - '1 week'::INTERVAL ORDER BY p.id DESC")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByOneWeek();

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p WHERE p.date_created >= NOW() - '1 week'::INTERVAL AND ( p.balikobot_url IS NULL OR p.balikobot_url = '' ) ORDER BY p.id DESC")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByOneWeekNoBalikobot();

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created, \t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(pmfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t\t\t\t\t\t\t\t\tpm.uid,\n\t\t\t\t\t\t\t\t\tpm.partner_message_id,\n\t\t\t\t\t\t\t\t\tnull AS parent_message_uid,\n\t\t\t\t\t\t\t\t\tpm.order_id,\n\t\t\t\t\t\t\t\t\tp.uid AS order_uid,\n\t\t\t\t\t\t\t\t\tpm.author_partner_id,\n\t\t\t\t\t\t\t\t\tadm_partners.uid AS author_uid,\n\t\t\t\t\t\t\t\t\tpm.partner_id,\n\t\t\t\t\t\t\t\t\tadm_partners1.uid AS partner_uid,\n\t\t\t\t\t\t\t\t\tpm.subject,\n\t\t\t\t\t\t\t\t\tpm.message,\n\t\t\t\t\t\t\t\t\tpm.image,\n\t\t\t\t\t\t\t\t\tpm.read,\n\t\t\t\t\t\t\t\t\tpm.date_created\n\t\t\t\t\t\t\t FROM \n\t\t\t\t\t\t\t\t\tadm.partner_message pm\n\t\t\t\t\t\t\t\t\tLEFT OUTER JOIN adm.partners adm_partners ON (pm.author_partner_id = adm_partners.id)\n\t\t\t\t\t\t\t\t\tLEFT OUTER JOIN adm.partners adm_partners1 ON (pm.partner_id = adm_partners1.id)\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tpm.order_id = p.id\n\t\t\t\t\t\t\tORDER BY \n\t\t\t\t\t\t\t\t\tpm.date_created ASC\n        \t\t\t\t\t) pmfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS messages,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(oslfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t\t\t\t\t\t\t\t  osl.id,\n\t\t\t\t\t\t\t\t\tosl.uid,\n\t\t\t\t\t\t\t\t\tosl.order_id,\n\t\t\t\t\t\t\t\t\tp.uid AS order_uid,\n\t\t\t\t\t\t\t\t\tosl.status,\n\t\t\t\t\t\t\t\t\tosl.status_text,\n\t\t\t\t\t\t\t\t\tosl.system,\n\t\t\t\t\t\t\t\t\tosl.confirmed,\n\t\t\t\t\t\t\t\t\tosl.date_created\n\t\t\t\t\t\t\t FROM \n\t\t\t\t\t\t\t\t\tabra.order_status_log osl\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tosl.order_id = p.id\n\t\t\t\t\t\t\tORDER BY \n\t\t\t\t\t\t\t\t\tosl.date_created ASC\n        \t\t\t\t\t) oslfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS statusLogs,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(oifoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t\t\t\t\t\t\t\t  oi.id,\n\t\t\t\t\t\t\t\t\toi.uid,\n\t\t\t\t\t\t\t\t\toi.order_id,\n\t\t\t\t\t\t\t\t\tp.uid AS order_uid,\n\t\t\t\t\t\t\t\t\toi.abra_id,\n\t\t\t\t\t\t\t\t\toi.busorder_id,\n\t\t\t\t\t\t\t\t\toi.busproject_id,\n\t\t\t\t\t\t\t\t\toi.bustransaction_id,\n\t\t\t\t\t\t\t\t\toi.capacity,\n\t\t\t\t\t\t\t\t\toi.capacityunit,\n\t\t\t\t\t\t\t\t\toi.classid,\n\t\t\t\t\t\t\t\t\toi.dealerdiscount,\n\t\t\t\t\t\t\t\t\toi.dealerdiscountexcluded,\n\t\t\t\t\t\t\t\t\toi.deliveredquantity,\n\t\t\t\t\t\t\t\t\toi.deliveredquantitystr,\n\t\t\t\t\t\t\t\t\toi.deliveredunitquantity,\n\t\t\t\t\t\t\t\t\toi.date_deliverydate,\n\t\t\t\t\t\t\t\t\toi.deliveryterm,\n\t\t\t\t\t\t\t\t\toi.demandstatus,\n\t\t\t\t\t\t\t\t\toi.discountsexcluded,\n\t\t\t\t\t\t\t\t\toi.displayname,\n\t\t\t\t\t\t\t\t\toi.division_id,\n\t\t\t\t\t\t\t\t\toi.documentdiscountexcluded,\n\t\t\t\t\t\t\t\t\toi.drcarticle_id,\n\t\t\t\t\t\t\t\t\toi.drcquantity,\n\t\t\t\t\t\t\t\t\toi.drcqunit,\n\t\t\t\t\t\t\t\t\toi.eslindicator_id,\n\t\t\t\t\t\t\t\t\toi.eslstatus,\n\t\t\t\t\t\t\t\t\toi.externalnumber,\n\t\t\t\t\t\t\t\t\toi.financialdiscountexcluded,\n\t\t\t\t\t\t\t\t\toi.incometype_id,\n\t\t\t\t\t\t\t\t\toi.individualdiscountexcluded,\n\t\t\t\t\t\t\t\t\toi.intrastatamount,\n\t\t\t\t\t\t\t\t\toi.intrastatoutputstatistic_id,\n\t\t\t\t\t\t\t\t\toi.intrastatregion_id,\n\t\t\t\t\t\t\t\t\toi.intrastatstatus,\n\t\t\t\t\t\t\t\t\toi.isanydiscount,\n\t\t\t\t\t\t\t\t\toi.localintrastatamount,\n\t\t\t\t\t\t\t\t\toi.localtamount,\n\t\t\t\t\t\t\t\t\toi.localtamountwithoutvat,\n\t\t\t\t\t\t\t\t\toi.mossservice_id,\n\t\t\t\t\t\t\t\t\toi.objversion,\n\t\t\t\t\t\t\t\t\toi.parent_id,\n\t\t\t\t\t\t\t\t\toi.posindex,\n\t\t\t\t\t\t\t\t\toi.price_id,\n\t\t\t\t\t\t\t\t\toi.provide_id,\n\t\t\t\t\t\t\t\t\toi.providerow_id,\n\t\t\t\t\t\t\t\t\toi.providerowdisplayname,\n\t\t\t\t\t\t\t\t\toi.quantity,\n\t\t\t\t\t\t\t\t\toi.quantitydiscount,\n\t\t\t\t\t\t\t\t\toi.quantitydiscountexcluded,\n\t\t\t\t\t\t\t\t\toi.qunit,\n\t\t\t\t\t\t\t\t\toi.reservation_id,\n\t\t\t\t\t\t\t\t\toi.revided_id,\n\t\t\t\t\t\t\t\t\toi.revision,\n\t\t\t\t\t\t\t\t\toi.revisionauthor_id,\n\t\t\t\t\t\t\t\t\toi.date_revisiondate,\n\t\t\t\t\t\t\t\t\toi.revisiondescription,\n\t\t\t\t\t\t\t\t\toi.rowdiscount,\n\t\t\t\t\t\t\t\t\toi.rowmargin,\n\t\t\t\t\t\t\t\t\toi.rowstoreprice,\n\t\t\t\t\t\t\t\t\toi.rowtype,\n\t\t\t\t\t\t\t\t\toi.splitintrastat,\n\t\t\t\t\t\t\t\t\toi.statisticamount,\n\t\t\t\t\t\t\t\t\toi.store_id,\n\t\t\t\t\t\t\t\t\toi.storecard_id,\n\t\t\t\t\t\t\t\t\toi.storedquantity,\n\t\t\t\t\t\t\t\t\toi.storedunitquantity,\n\t\t\t\t\t\t\t\t\toi.tamount,\n\t\t\t\t\t\t\t\t\toi.tamountwithoutvat,\n\t\t\t\t\t\t\t\t\toi.text,\n\t\t\t\t\t\t\t\t\toi.toesl,\n\t\t\t\t\t\t\t\t\toi.tointrastat,\n\t\t\t\t\t\t\t\t\toi.totaldiscountfactor,\n\t\t\t\t\t\t\t\t\toi.totalpercentualdiscount,\n\t\t\t\t\t\t\t\t\toi.totalprice,\n\t\t\t\t\t\t\t\t\toi.unitprice,\n\t\t\t\t\t\t\t\t\toi.unitquantity,\n\t\t\t\t\t\t\t\t\toi.unitrate,\n\t\t\t\t\t\t\t\t\toi.vatmode,\n\t\t\t\t\t\t\t\t\toi.vatrate,\n\t\t\t\t\t\t\t\t\toi.vatrate_id,\n\t\t\t\t\t\t\t\t\toi.weight,\n\t\t\t\t\t\t\t\t\toi.weightunit,\n\t\t\t\t\t\t\t\t\toi.abra_params,\n\t\t\t\t\t\t\t\t\toi.date_created\n\t\t\t\t\t\t\t FROM \n\t\t\t\t\t\t\t\t\tabra.order_items oi\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\toi.order_id = p.id\n\t\t\t\t\t\t\tORDER BY \n\t\t\t\t\t\t\t\t\toi.rowtype DESC\n        \t\t\t\t\t) oifoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS rows\n FROM abra.orders p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrdersFullMapper.class)
    public OrdersDomain findFullById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.accountingtype = :accountingtype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAccountingtype(@Bind(value="accountingtype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.accountingtype = :accountingtype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAccountingtype(@Bind(value="accountingtype") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.accountingtype = :accountingtype")
    public long findListByAccountingtypeCount(@Bind(value="accountingtype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.accountingtype = :accountingtype ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAccountingtype(@Bind(value="accountingtype") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.address_id = :addressId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAddressId(@Bind(value="addressId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.address_id = :addressId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAddressId(@Bind(value="addressId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.address_id = :addressId")
    public long findListByAddressIdCount(@Bind(value="addressId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.address_id = :addressId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAddressId(@Bind(value="addressId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAmount(@Bind(value="amount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAmount(@Bind(value="amount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.amount = :amount")
    public long findListByAmountCount(@Bind(value="amount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.amount = :amount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAmount(@Bind(value="amount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.amountwithoutvat = :amountwithoutvat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAmountwithoutvat(@Bind(value="amountwithoutvat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.amountwithoutvat = :amountwithoutvat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAmountwithoutvat(@Bind(value="amountwithoutvat") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.amountwithoutvat = :amountwithoutvat")
    public long findListByAmountwithoutvatCount(@Bind(value="amountwithoutvat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.amountwithoutvat = :amountwithoutvat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAmountwithoutvat(@Bind(value="amountwithoutvat") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.bankaccount_id = :bankaccountId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByBankaccountId(@Bind(value="bankaccountId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.bankaccount_id = :bankaccountId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByBankaccountId(@Bind(value="bankaccountId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.bankaccount_id = :bankaccountId")
    public long findListByBankaccountIdCount(@Bind(value="bankaccountId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.bankaccount_id = :bankaccountId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByBankaccountId(@Bind(value="bankaccountId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.capacity = :capacity")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCapacity(@Bind(value="capacity") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.capacity = :capacity")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCapacity(@Bind(value="capacity") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.capacity = :capacity")
    public long findListByCapacityCount(@Bind(value="capacity") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.capacity = :capacity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCapacity(@Bind(value="capacity") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.capacityunit = :capacityunit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCapacityunit(@Bind(value="capacityunit") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.capacityunit = :capacityunit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCapacityunit(@Bind(value="capacityunit") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.capacityunit = :capacityunit")
    public long findListByCapacityunitCount(@Bind(value="capacityunit") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.capacityunit = :capacityunit ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCapacityunit(@Bind(value="capacityunit") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.classid = :classid")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByClassid(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.classid = :classid")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByClassid(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.classid = :classid")
    public long findListByClassidCount(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.classid = :classid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByClassid(@Bind(value="classid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.closed = :closed")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByClosed(@Bind(value="closed") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.closed = :closed")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByClosed(@Bind(value="closed") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.closed = :closed")
    public long findListByClosedCount(@Bind(value="closed") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.closed = :closed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByClosed(@Bind(value="closed") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.coef = :coef")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCoef(@Bind(value="coef") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.coef = :coef")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCoef(@Bind(value="coef") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.coef = :coef")
    public long findListByCoefCount(@Bind(value="coef") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.coef = :coef ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCoef(@Bind(value="coef") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.confirmed = :confirmed")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByConfirmed(@Bind(value="confirmed") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.confirmed = :confirmed")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByConfirmed(@Bind(value="confirmed") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.confirmed = :confirmed")
    public long findListByConfirmedCount(@Bind(value="confirmed") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.confirmed = :confirmed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByConfirmed(@Bind(value="confirmed") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.constsymbol_id = :constsymbolId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByConstsymbolId(@Bind(value="constsymbolId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.constsymbol_id = :constsymbolId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByConstsymbolId(@Bind(value="constsymbolId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.constsymbol_id = :constsymbolId")
    public long findListByConstsymbolIdCount(@Bind(value="constsymbolId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.constsymbol_id = :constsymbolId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByConstsymbolId(@Bind(value="constsymbolId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_correctedat = :dateCorrectedat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDateCorrectedat(@Bind(value="dateCorrectedat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_correctedat = :dateCorrectedat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateCorrectedat(@Bind(value="dateCorrectedat") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.date_correctedat = :dateCorrectedat")
    public long findListByDateCorrectedatCount(@Bind(value="dateCorrectedat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_correctedat = :dateCorrectedat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateCorrectedat(@Bind(value="dateCorrectedat") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.correctedby_id = :correctedbyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCorrectedbyId(@Bind(value="correctedbyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.correctedby_id = :correctedbyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCorrectedbyId(@Bind(value="correctedbyId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.correctedby_id = :correctedbyId")
    public long findListByCorrectedbyIdCount(@Bind(value="correctedbyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.correctedby_id = :correctedbyId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCorrectedbyId(@Bind(value="correctedbyId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.country_id = :countryId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCountryId(@Bind(value="countryId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.country_id = :countryId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCountryId(@Bind(value="countryId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.country_id = :countryId")
    public long findListByCountryIdCount(@Bind(value="countryId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.country_id = :countryId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCountryId(@Bind(value="countryId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_createdat = :dateCreatedat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDateCreatedat(@Bind(value="dateCreatedat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_createdat = :dateCreatedat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateCreatedat(@Bind(value="dateCreatedat") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.date_createdat = :dateCreatedat")
    public long findListByDateCreatedatCount(@Bind(value="dateCreatedat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_createdat = :dateCreatedat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateCreatedat(@Bind(value="dateCreatedat") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.createdby_id = :createdbyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCreatedbyId(@Bind(value="createdbyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.createdby_id = :createdbyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCreatedbyId(@Bind(value="createdbyId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.createdby_id = :createdbyId")
    public long findListByCreatedbyIdCount(@Bind(value="createdbyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.createdby_id = :createdbyId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCreatedbyId(@Bind(value="createdbyId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currency_id = :currencyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCurrencyId(@Bind(value="currencyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currency_id = :currencyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCurrencyId(@Bind(value="currencyId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.currency_id = :currencyId")
    public long findListByCurrencyIdCount(@Bind(value="currencyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currency_id = :currencyId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCurrencyId(@Bind(value="currencyId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currrate = :currrate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCurrrate(@Bind(value="currrate") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currrate = :currrate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCurrrate(@Bind(value="currrate") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.currrate = :currrate")
    public long findListByCurrrateCount(@Bind(value="currrate") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currrate = :currrate ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCurrrate(@Bind(value="currrate") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currrateinfo = :currrateinfo")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByCurrrateinfo(@Bind(value="currrateinfo") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currrateinfo = :currrateinfo")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCurrrateinfo(@Bind(value="currrateinfo") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.currrateinfo = :currrateinfo")
    public long findListByCurrrateinfoCount(@Bind(value="currrateinfo") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.currrateinfo = :currrateinfo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByCurrrateinfo(@Bind(value="currrateinfo") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealercategory_id = :dealercategoryId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDealercategoryId(@Bind(value="dealercategoryId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealercategory_id = :dealercategoryId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDealercategoryId(@Bind(value="dealercategoryId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.dealercategory_id = :dealercategoryId")
    public long findListByDealercategoryIdCount(@Bind(value="dealercategoryId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealercategory_id = :dealercategoryId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDealercategoryId(@Bind(value="dealercategoryId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealerdiscount = :dealerdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDealerdiscount(@Bind(value="dealerdiscount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealerdiscount = :dealerdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDealerdiscount(@Bind(value="dealerdiscount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.dealerdiscount = :dealerdiscount")
    public long findListByDealerdiscountCount(@Bind(value="dealerdiscount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealerdiscount = :dealerdiscount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDealerdiscount(@Bind(value="dealerdiscount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealerdiscountkind = :dealerdiscountkind")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDealerdiscountkind(@Bind(value="dealerdiscountkind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealerdiscountkind = :dealerdiscountkind")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDealerdiscountkind(@Bind(value="dealerdiscountkind") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.dealerdiscountkind = :dealerdiscountkind")
    public long findListByDealerdiscountkindCount(@Bind(value="dealerdiscountkind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dealerdiscountkind = :dealerdiscountkind ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDealerdiscountkind(@Bind(value="dealerdiscountkind") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.description = :description")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.description = :description")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dirty = :dirty")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDirty(@Bind(value="dirty") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dirty = :dirty")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDirty(@Bind(value="dirty") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.dirty = :dirty")
    public long findListByDirtyCount(@Bind(value="dirty") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.dirty = :dirty ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDirty(@Bind(value="dirty") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.discountcalckind = :discountcalckind")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDiscountcalckind(@Bind(value="discountcalckind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.discountcalckind = :discountcalckind")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDiscountcalckind(@Bind(value="discountcalckind") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.discountcalckind = :discountcalckind")
    public long findListByDiscountcalckindCount(@Bind(value="discountcalckind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.discountcalckind = :discountcalckind ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDiscountcalckind(@Bind(value="discountcalckind") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.displayname = :displayname")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDisplayname(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.displayname = :displayname")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDisplayname(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.displayname = :displayname")
    public long findListByDisplaynameCount(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.displayname = :displayname ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDisplayname(@Bind(value="displayname") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_docdate = :dateDocdate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDateDocdate(@Bind(value="dateDocdate") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_docdate = :dateDocdate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateDocdate(@Bind(value="dateDocdate") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.date_docdate = :dateDocdate")
    public long findListByDateDocdateCount(@Bind(value="dateDocdate") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_docdate = :dateDocdate ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateDocdate(@Bind(value="dateDocdate") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.docqueue_id = :docqueueId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDocqueueId(@Bind(value="docqueueId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.docqueue_id = :docqueueId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDocqueueId(@Bind(value="docqueueId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.docqueue_id = :docqueueId")
    public long findListByDocqueueIdCount(@Bind(value="docqueueId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.docqueue_id = :docqueueId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDocqueueId(@Bind(value="docqueueId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.documentdiscount = :documentdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDocumentdiscount(@Bind(value="documentdiscount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.documentdiscount = :documentdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDocumentdiscount(@Bind(value="documentdiscount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.documentdiscount = :documentdiscount")
    public long findListByDocumentdiscountCount(@Bind(value="documentdiscount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.documentdiscount = :documentdiscount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDocumentdiscount(@Bind(value="documentdiscount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.donotrecalculateunitprice = :donotrecalculateunitprice")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDonotrecalculateunitprice(@Bind(value="donotrecalculateunitprice") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.donotrecalculateunitprice = :donotrecalculateunitprice")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDonotrecalculateunitprice(@Bind(value="donotrecalculateunitprice") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.donotrecalculateunitprice = :donotrecalculateunitprice")
    public long findListByDonotrecalculateunitpriceCount(@Bind(value="donotrecalculateunitprice") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.donotrecalculateunitprice = :donotrecalculateunitprice ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDonotrecalculateunitprice(@Bind(value="donotrecalculateunitprice") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.externalnumber = :externalnumber")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByExternalnumber(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.externalnumber = :externalnumber")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByExternalnumber(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.externalnumber = :externalnumber")
    public long findListByExternalnumberCount(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.externalnumber = :externalnumber ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByExternalnumber(@Bind(value="externalnumber") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.financialdiscount = :financialdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByFinancialdiscount(@Bind(value="financialdiscount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.financialdiscount = :financialdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFinancialdiscount(@Bind(value="financialdiscount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.financialdiscount = :financialdiscount")
    public long findListByFinancialdiscountCount(@Bind(value="financialdiscount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.financialdiscount = :financialdiscount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFinancialdiscount(@Bind(value="financialdiscount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.firm_id = :firmId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByFirmId(@Bind(value="firmId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.firm_id = :firmId ORDER BY p.id DESC LIMIT 1")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByFirmIdLast(@Bind(value="firmId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.firm_id = :firmId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFirmId(@Bind(value="firmId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.firm_id = :firmId")
    public long findListByFirmIdCount(@Bind(value="firmId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.firm_id = :firmId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFirmId(@Bind(value="firmId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.firmoffice_id = :firmofficeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByFirmofficeId(@Bind(value="firmofficeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.firmoffice_id = :firmofficeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFirmofficeId(@Bind(value="firmofficeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.firmoffice_id = :firmofficeId")
    public long findListByFirmofficeIdCount(@Bind(value="firmofficeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.firmoffice_id = :firmofficeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFirmofficeId(@Bind(value="firmofficeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.frozendiscounts = :frozendiscounts")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByFrozendiscounts(@Bind(value="frozendiscounts") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.frozendiscounts = :frozendiscounts")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFrozendiscounts(@Bind(value="frozendiscounts") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.frozendiscounts = :frozendiscounts")
    public long findListByFrozendiscountsCount(@Bind(value="frozendiscounts") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.frozendiscounts = :frozendiscounts ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByFrozendiscounts(@Bind(value="frozendiscounts") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastatdeliveryterm_id = :intrastatdeliverytermId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIntrastatdeliverytermId(@Bind(value="intrastatdeliverytermId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastatdeliveryterm_id = :intrastatdeliverytermId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIntrastatdeliverytermId(@Bind(value="intrastatdeliverytermId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.intrastatdeliveryterm_id = :intrastatdeliverytermId")
    public long findListByIntrastatdeliverytermIdCount(@Bind(value="intrastatdeliverytermId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastatdeliveryterm_id = :intrastatdeliverytermId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIntrastatdeliverytermId(@Bind(value="intrastatdeliverytermId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastattransactiontype_id = :intrastattransactiontypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIntrastattransactiontypeId(@Bind(value="intrastattransactiontypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastattransactiontype_id = :intrastattransactiontypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIntrastattransactiontypeId(@Bind(value="intrastattransactiontypeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.intrastattransactiontype_id = :intrastattransactiontypeId")
    public long findListByIntrastattransactiontypeIdCount(@Bind(value="intrastattransactiontypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastattransactiontype_id = :intrastattransactiontypeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIntrastattransactiontypeId(@Bind(value="intrastattransactiontypeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastattransportationtype_id = :intrastattransportationtypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIntrastattransportationtypeId(@Bind(value="intrastattransportationtypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastattransportationtype_id = :intrastattransportationtypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIntrastattransportationtypeId(@Bind(value="intrastattransportationtypeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.intrastattransportationtype_id = :intrastattransportationtypeId")
    public long findListByIntrastattransportationtypeIdCount(@Bind(value="intrastattransportationtypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.intrastattransportationtype_id = :intrastattransportationtypeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIntrastattransportationtypeId(@Bind(value="intrastattransportationtypeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isaccounted = :isaccounted")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIsaccounted(@Bind(value="isaccounted") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isaccounted = :isaccounted")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsaccounted(@Bind(value="isaccounted") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.isaccounted = :isaccounted")
    public long findListByIsaccountedCount(@Bind(value="isaccounted") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isaccounted = :isaccounted ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsaccounted(@Bind(value="isaccounted") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isaccountedlatervat = :isaccountedlatervat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIsaccountedlatervat(@Bind(value="isaccountedlatervat") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isaccountedlatervat = :isaccountedlatervat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsaccountedlatervat(@Bind(value="isaccountedlatervat") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.isaccountedlatervat = :isaccountedlatervat")
    public long findListByIsaccountedlatervatCount(@Bind(value="isaccountedlatervat") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isaccountedlatervat = :isaccountedlatervat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsaccountedlatervat(@Bind(value="isaccountedlatervat") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isavailablefordelivery = :isavailablefordelivery")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIsavailablefordelivery(@Bind(value="isavailablefordelivery") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isavailablefordelivery = :isavailablefordelivery")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsavailablefordelivery(@Bind(value="isavailablefordelivery") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.isavailablefordelivery = :isavailablefordelivery")
    public long findListByIsavailablefordeliveryCount(@Bind(value="isavailablefordelivery") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isavailablefordelivery = :isavailablefordelivery ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsavailablefordelivery(@Bind(value="isavailablefordelivery") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isfinancialdiscount = :isfinancialdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIsfinancialdiscount(@Bind(value="isfinancialdiscount") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isfinancialdiscount = :isfinancialdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsfinancialdiscount(@Bind(value="isfinancialdiscount") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.isfinancialdiscount = :isfinancialdiscount")
    public long findListByIsfinancialdiscountCount(@Bind(value="isfinancialdiscount") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isfinancialdiscount = :isfinancialdiscount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsfinancialdiscount(@Bind(value="isfinancialdiscount") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isreversechargedeclared = :isreversechargedeclared")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIsreversechargedeclared(@Bind(value="isreversechargedeclared") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isreversechargedeclared = :isreversechargedeclared")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsreversechargedeclared(@Bind(value="isreversechargedeclared") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.isreversechargedeclared = :isreversechargedeclared")
    public long findListByIsreversechargedeclaredCount(@Bind(value="isreversechargedeclared") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isreversechargedeclared = :isreversechargedeclared ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsreversechargedeclared(@Bind(value="isreversechargedeclared") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isrowdiscount = :isrowdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByIsrowdiscount(@Bind(value="isrowdiscount") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isrowdiscount = :isrowdiscount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsrowdiscount(@Bind(value="isrowdiscount") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.isrowdiscount = :isrowdiscount")
    public long findListByIsrowdiscountCount(@Bind(value="isrowdiscount") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.isrowdiscount = :isrowdiscount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByIsrowdiscount(@Bind(value="isrowdiscount") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localamount = :localamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByLocalamount(@Bind(value="localamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localamount = :localamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalamount(@Bind(value="localamount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.localamount = :localamount")
    public long findListByLocalamountCount(@Bind(value="localamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localamount = :localamount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalamount(@Bind(value="localamount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localamountwithoutvat = :localamountwithoutvat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByLocalamountwithoutvat(@Bind(value="localamountwithoutvat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localamountwithoutvat = :localamountwithoutvat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalamountwithoutvat(@Bind(value="localamountwithoutvat") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.localamountwithoutvat = :localamountwithoutvat")
    public long findListByLocalamountwithoutvatCount(@Bind(value="localamountwithoutvat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localamountwithoutvat = :localamountwithoutvat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalamountwithoutvat(@Bind(value="localamountwithoutvat") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localcoef = :localcoef")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByLocalcoef(@Bind(value="localcoef") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localcoef = :localcoef")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalcoef(@Bind(value="localcoef") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.localcoef = :localcoef")
    public long findListByLocalcoefCount(@Bind(value="localcoef") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localcoef = :localcoef ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalcoef(@Bind(value="localcoef") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localrefcurrency_id = :localrefcurrencyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByLocalrefcurrencyId(@Bind(value="localrefcurrencyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localrefcurrency_id = :localrefcurrencyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalrefcurrencyId(@Bind(value="localrefcurrencyId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.localrefcurrency_id = :localrefcurrencyId")
    public long findListByLocalrefcurrencyIdCount(@Bind(value="localrefcurrencyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localrefcurrency_id = :localrefcurrencyId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalrefcurrencyId(@Bind(value="localrefcurrencyId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localroundingamount = :localroundingamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByLocalroundingamount(@Bind(value="localroundingamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localroundingamount = :localroundingamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalroundingamount(@Bind(value="localroundingamount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.localroundingamount = :localroundingamount")
    public long findListByLocalroundingamountCount(@Bind(value="localroundingamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localroundingamount = :localroundingamount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalroundingamount(@Bind(value="localroundingamount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localvatamount = :localvatamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByLocalvatamount(@Bind(value="localvatamount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localvatamount = :localvatamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalvatamount(@Bind(value="localvatamount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.localvatamount = :localvatamount")
    public long findListByLocalvatamountCount(@Bind(value="localvatamount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localvatamount = :localvatamount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalvatamount(@Bind(value="localvatamount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localzone_id = :localzoneId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByLocalzoneId(@Bind(value="localzoneId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localzone_id = :localzoneId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalzoneId(@Bind(value="localzoneId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.localzone_id = :localzoneId")
    public long findListByLocalzoneIdCount(@Bind(value="localzoneId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.localzone_id = :localzoneId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByLocalzoneId(@Bind(value="localzoneId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.margin = :margin")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByMargin(@Bind(value="margin") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.margin = :margin")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByMargin(@Bind(value="margin") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.margin = :margin")
    public long findListByMarginCount(@Bind(value="margin") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.margin = :margin ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByMargin(@Bind(value="margin") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.newrelateddocument_id = :newrelateddocumentId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByNewrelateddocumentId(@Bind(value="newrelateddocumentId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.newrelateddocument_id = :newrelateddocumentId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByNewrelateddocumentId(@Bind(value="newrelateddocumentId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.newrelateddocument_id = :newrelateddocumentId")
    public long findListByNewrelateddocumentIdCount(@Bind(value="newrelateddocumentId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.newrelateddocument_id = :newrelateddocumentId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByNewrelateddocumentId(@Bind(value="newrelateddocumentId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.newrelatedtype = :newrelatedtype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByNewrelatedtype(@Bind(value="newrelatedtype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.newrelatedtype = :newrelatedtype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByNewrelatedtype(@Bind(value="newrelatedtype") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.newrelatedtype = :newrelatedtype")
    public long findListByNewrelatedtypeCount(@Bind(value="newrelatedtype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.newrelatedtype = :newrelatedtype ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByNewrelatedtype(@Bind(value="newrelatedtype") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.objversion = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.objversion = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.onlywholeorder = :onlywholeorder")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByOnlywholeorder(@Bind(value="onlywholeorder") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.onlywholeorder = :onlywholeorder")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByOnlywholeorder(@Bind(value="onlywholeorder") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.onlywholeorder = :onlywholeorder")
    public long findListByOnlywholeorderCount(@Bind(value="onlywholeorder") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.onlywholeorder = :onlywholeorder ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByOnlywholeorder(@Bind(value="onlywholeorder") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.ordnumber = :ordnumber")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByOrdnumber(@Bind(value="ordnumber") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.ordnumber = :ordnumber")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByOrdnumber(@Bind(value="ordnumber") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.ordnumber = :ordnumber")
    public long findListByOrdnumberCount(@Bind(value="ordnumber") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.ordnumber = :ordnumber ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByOrdnumber(@Bind(value="ordnumber") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.paymenttype_id = :paymenttypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByPaymenttypeId(@Bind(value="paymenttypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.paymenttype_id = :paymenttypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPaymenttypeId(@Bind(value="paymenttypeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.paymenttype_id = :paymenttypeId")
    public long findListByPaymenttypeIdCount(@Bind(value="paymenttypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.paymenttype_id = :paymenttypeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPaymenttypeId(@Bind(value="paymenttypeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.period_id = :periodId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByPeriodId(@Bind(value="periodId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.period_id = :periodId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPeriodId(@Bind(value="periodId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.period_id = :periodId")
    public long findListByPeriodIdCount(@Bind(value="periodId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.period_id = :periodId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPeriodId(@Bind(value="periodId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.person_id = :personId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByPersonId(@Bind(value="personId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.person_id = :personId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPersonId(@Bind(value="personId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.person_id = :personId")
    public long findListByPersonIdCount(@Bind(value="personId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.person_id = :personId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPersonId(@Bind(value="personId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.priceprecision = :priceprecision")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByPriceprecision(@Bind(value="priceprecision") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.priceprecision = :priceprecision")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPriceprecision(@Bind(value="priceprecision") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.priceprecision = :priceprecision")
    public long findListByPriceprecisionCount(@Bind(value="priceprecision") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.priceprecision = :priceprecision ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPriceprecision(@Bind(value="priceprecision") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.pricesbyref = :pricesbyref")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByPricesbyref(@Bind(value="pricesbyref") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.pricesbyref = :pricesbyref")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPricesbyref(@Bind(value="pricesbyref") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.pricesbyref = :pricesbyref")
    public long findListByPricesbyrefCount(@Bind(value="pricesbyref") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.pricesbyref = :pricesbyref ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPricesbyref(@Bind(value="pricesbyref") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.priceswithvat = :priceswithvat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByPriceswithvat(@Bind(value="priceswithvat") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.priceswithvat = :priceswithvat")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPriceswithvat(@Bind(value="priceswithvat") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.priceswithvat = :priceswithvat")
    public long findListByPriceswithvatCount(@Bind(value="priceswithvat") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.priceswithvat = :priceswithvat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByPriceswithvat(@Bind(value="priceswithvat") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.quantitydiscountkind = :quantitydiscountkind")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByQuantitydiscountkind(@Bind(value="quantitydiscountkind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.quantitydiscountkind = :quantitydiscountkind")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByQuantitydiscountkind(@Bind(value="quantitydiscountkind") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.quantitydiscountkind = :quantitydiscountkind")
    public long findListByQuantitydiscountkindCount(@Bind(value="quantitydiscountkind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.quantitydiscountkind = :quantitydiscountkind ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByQuantitydiscountkind(@Bind(value="quantitydiscountkind") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.refcurrency_id = :refcurrencyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByRefcurrencyId(@Bind(value="refcurrencyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.refcurrency_id = :refcurrencyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRefcurrencyId(@Bind(value="refcurrencyId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.refcurrency_id = :refcurrencyId")
    public long findListByRefcurrencyIdCount(@Bind(value="refcurrencyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.refcurrency_id = :refcurrencyId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRefcurrencyId(@Bind(value="refcurrencyId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.refcurrrate = :refcurrrate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByRefcurrrate(@Bind(value="refcurrrate") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.refcurrrate = :refcurrrate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRefcurrrate(@Bind(value="refcurrrate") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.refcurrrate = :refcurrrate")
    public long findListByRefcurrrateCount(@Bind(value="refcurrrate") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.refcurrrate = :refcurrrate ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRefcurrrate(@Bind(value="refcurrrate") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revided_id = :revidedId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByRevidedId(@Bind(value="revidedId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revided_id = :revidedId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevidedId(@Bind(value="revidedId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.revided_id = :revidedId")
    public long findListByRevidedIdCount(@Bind(value="revidedId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revided_id = :revidedId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevidedId(@Bind(value="revidedId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revision = :revision")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByRevision(@Bind(value="revision") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revision = :revision")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevision(@Bind(value="revision") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.revision = :revision")
    public long findListByRevisionCount(@Bind(value="revision") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revision = :revision ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevision(@Bind(value="revision") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revisionauthor_id = :revisionauthorId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByRevisionauthorId(@Bind(value="revisionauthorId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revisionauthor_id = :revisionauthorId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevisionauthorId(@Bind(value="revisionauthorId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.revisionauthor_id = :revisionauthorId")
    public long findListByRevisionauthorIdCount(@Bind(value="revisionauthorId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revisionauthor_id = :revisionauthorId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevisionauthorId(@Bind(value="revisionauthorId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_revisiondate = :dateRevisiondate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDateRevisiondate(@Bind(value="dateRevisiondate") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_revisiondate = :dateRevisiondate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateRevisiondate(@Bind(value="dateRevisiondate") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.date_revisiondate = :dateRevisiondate")
    public long findListByDateRevisiondateCount(@Bind(value="dateRevisiondate") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_revisiondate = :dateRevisiondate ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateRevisiondate(@Bind(value="dateRevisiondate") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revisiondescription = :revisiondescription")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByRevisiondescription(@Bind(value="revisiondescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revisiondescription = :revisiondescription")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevisiondescription(@Bind(value="revisiondescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.revisiondescription = :revisiondescription")
    public long findListByRevisiondescriptionCount(@Bind(value="revisiondescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.revisiondescription = :revisiondescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRevisiondescription(@Bind(value="revisiondescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.roundingamount = :roundingamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByRoundingamount(@Bind(value="roundingamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.roundingamount = :roundingamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRoundingamount(@Bind(value="roundingamount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.roundingamount = :roundingamount")
    public long findListByRoundingamountCount(@Bind(value="roundingamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.roundingamount = :roundingamount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByRoundingamount(@Bind(value="roundingamount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.storeprice = :storeprice")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByStoreprice(@Bind(value="storeprice") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.storeprice = :storeprice")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByStoreprice(@Bind(value="storeprice") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.storeprice = :storeprice")
    public long findListByStorepriceCount(@Bind(value="storeprice") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.storeprice = :storeprice ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByStoreprice(@Bind(value="storeprice") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.totaldiscountamount = :totaldiscountamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByTotaldiscountamount(@Bind(value="totaldiscountamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.totaldiscountamount = :totaldiscountamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTotaldiscountamount(@Bind(value="totaldiscountamount") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.totaldiscountamount = :totaldiscountamount")
    public long findListByTotaldiscountamountCount(@Bind(value="totaldiscountamount") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.totaldiscountamount = :totaldiscountamount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTotaldiscountamount(@Bind(value="totaldiscountamount") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.totalrounding = :totalrounding")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByTotalrounding(@Bind(value="totalrounding") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.totalrounding = :totalrounding")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTotalrounding(@Bind(value="totalrounding") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.totalrounding = :totalrounding")
    public long findListByTotalroundingCount(@Bind(value="totalrounding") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.totalrounding = :totalrounding ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTotalrounding(@Bind(value="totalrounding") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.tradetype = :tradetype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByTradetype(@Bind(value="tradetype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.tradetype = :tradetype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTradetype(@Bind(value="tradetype") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.tradetype = :tradetype")
    public long findListByTradetypeCount(@Bind(value="tradetype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.tradetype = :tradetype ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTradetype(@Bind(value="tradetype") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.tradetypedescription = :tradetypedescription")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByTradetypedescription(@Bind(value="tradetypedescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.tradetypedescription = :tradetypedescription")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTradetypedescription(@Bind(value="tradetypedescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.tradetypedescription = :tradetypedescription")
    public long findListByTradetypedescriptionCount(@Bind(value="tradetypedescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.tradetypedescription = :tradetypedescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTradetypedescription(@Bind(value="tradetypedescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.transportationtype_id = :transportationtypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByTransportationtypeId(@Bind(value="transportationtypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.transportationtype_id = :transportationtypeId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTransportationtypeId(@Bind(value="transportationtypeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.transportationtype_id = :transportationtypeId")
    public long findListByTransportationtypeIdCount(@Bind(value="transportationtypeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.transportationtype_id = :transportationtypeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByTransportationtypeId(@Bind(value="transportationtypeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatamount = :vatamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByVatamount(@Bind(value="vatamount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatamount = :vatamount")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatamount(@Bind(value="vatamount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.vatamount = :vatamount")
    public long findListByVatamountCount(@Bind(value="vatamount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatamount = :vatamount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatamount(@Bind(value="vatamount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatcountry_id = :vatcountryId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByVatcountryId(@Bind(value="vatcountryId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatcountry_id = :vatcountryId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatcountryId(@Bind(value="vatcountryId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.vatcountry_id = :vatcountryId")
    public long findListByVatcountryIdCount(@Bind(value="vatcountryId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatcountry_id = :vatcountryId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatcountryId(@Bind(value="vatcountryId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatdocument = :vatdocument")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByVatdocument(@Bind(value="vatdocument") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatdocument = :vatdocument")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatdocument(@Bind(value="vatdocument") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.vatdocument = :vatdocument")
    public long findListByVatdocumentCount(@Bind(value="vatdocument") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatdocument = :vatdocument ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatdocument(@Bind(value="vatdocument") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatfromaboveprecision = :vatfromaboveprecision")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByVatfromaboveprecision(@Bind(value="vatfromaboveprecision") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatfromaboveprecision = :vatfromaboveprecision")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatfromaboveprecision(@Bind(value="vatfromaboveprecision") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.vatfromaboveprecision = :vatfromaboveprecision")
    public long findListByVatfromaboveprecisionCount(@Bind(value="vatfromaboveprecision") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatfromaboveprecision = :vatfromaboveprecision ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatfromaboveprecision(@Bind(value="vatfromaboveprecision") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatfromabovetype = :vatfromabovetype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByVatfromabovetype(@Bind(value="vatfromabovetype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatfromabovetype = :vatfromabovetype")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatfromabovetype(@Bind(value="vatfromabovetype") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.vatfromabovetype = :vatfromabovetype")
    public long findListByVatfromabovetypeCount(@Bind(value="vatfromabovetype") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatfromabovetype = :vatfromabovetype ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatfromabovetype(@Bind(value="vatfromabovetype") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatrounding = :vatrounding")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByVatrounding(@Bind(value="vatrounding") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatrounding = :vatrounding")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatrounding(@Bind(value="vatrounding") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.vatrounding = :vatrounding")
    public long findListByVatroundingCount(@Bind(value="vatrounding") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.vatrounding = :vatrounding ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByVatrounding(@Bind(value="vatrounding") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.weight = :weight")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByWeight(@Bind(value="weight") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.weight = :weight")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByWeight(@Bind(value="weight") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.weight = :weight")
    public long findListByWeightCount(@Bind(value="weight") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.weight = :weight ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByWeight(@Bind(value="weight") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.weightunit = :weightunit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByWeightunit(@Bind(value="weightunit") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.weightunit = :weightunit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByWeightunit(@Bind(value="weightunit") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.weightunit = :weightunit")
    public long findListByWeightunitCount(@Bind(value="weightunit") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.weightunit = :weightunit ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByWeightunit(@Bind(value="weightunit") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_address1_id = :abraAddress1Id")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraAddress1Id(@Bind(value="abraAddress1Id") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_address1_id = :abraAddress1Id")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraAddress1Id(@Bind(value="abraAddress1Id") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_address1_id = :abraAddress1Id")
    public long findListByAbraAddress1IdCount(@Bind(value="abraAddress1Id") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_address1_id = :abraAddress1Id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraAddress1Id(@Bind(value="abraAddress1Id") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_address2_id = :abraAddress2Id")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraAddress2Id(@Bind(value="abraAddress2Id") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_address2_id = :abraAddress2Id")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraAddress2Id(@Bind(value="abraAddress2Id") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_address2_id = :abraAddress2Id")
    public long findListByAbraAddress2IdCount(@Bind(value="abraAddress2Id") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_address2_id = :abraAddress2Id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraAddress2Id(@Bind(value="abraAddress2Id") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_contacted = :abraContacted")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraContacted(@Bind(value="abraContacted") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_contacted = :abraContacted")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraContacted(@Bind(value="abraContacted") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_contacted = :abraContacted")
    public long findListByAbraContactedCount(@Bind(value="abraContacted") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_contacted = :abraContacted ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraContacted(@Bind(value="abraContacted") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_endeddate = :abraEndeddate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraEndeddate(@Bind(value="abraEndeddate") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_endeddate = :abraEndeddate")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraEndeddate(@Bind(value="abraEndeddate") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_endeddate = :abraEndeddate")
    public long findListByAbraEndeddateCount(@Bind(value="abraEndeddate") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_endeddate = :abraEndeddate ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraEndeddate(@Bind(value="abraEndeddate") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_params = :abraParams")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraParams(@Bind(value="abraParams") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_params = :abraParams")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraParams(@Bind(value="abraParams") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_params = :abraParams")
    public long findListByAbraParamsCount(@Bind(value="abraParams") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_params = :abraParams ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraParams(@Bind(value="abraParams") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_branches = :abraPdBbBranches")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraPdBbBranches(@Bind(value="abraPdBbBranches") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_branches = :abraPdBbBranches")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdBbBranches(@Bind(value="abraPdBbBranches") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_pd_bb_branches = :abraPdBbBranches")
    public long findListByAbraPdBbBranchesCount(@Bind(value="abraPdBbBranches") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_branches = :abraPdBbBranches ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdBbBranches(@Bind(value="abraPdBbBranches") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_modul = :abraPdBbModul")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraPdBbModul(@Bind(value="abraPdBbModul") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_modul = :abraPdBbModul")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdBbModul(@Bind(value="abraPdBbModul") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_pd_bb_modul = :abraPdBbModul")
    public long findListByAbraPdBbModulCount(@Bind(value="abraPdBbModul") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_modul = :abraPdBbModul ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdBbModul(@Bind(value="abraPdBbModul") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_services = :abraPdBbServices")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraPdBbServices(@Bind(value="abraPdBbServices") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_services = :abraPdBbServices")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdBbServices(@Bind(value="abraPdBbServices") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_pd_bb_services = :abraPdBbServices")
    public long findListByAbraPdBbServicesCount(@Bind(value="abraPdBbServices") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_bb_services = :abraPdBbServices ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdBbServices(@Bind(value="abraPdBbServices") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_status = :abraPdStatus")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraPdStatus(@Bind(value="abraPdStatus") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_status = :abraPdStatus")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdStatus(@Bind(value="abraPdStatus") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_pd_status = :abraPdStatus")
    public long findListByAbraPdStatusCount(@Bind(value="abraPdStatus") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_pd_status = :abraPdStatus ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraPdStatus(@Bind(value="abraPdStatus") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraStavObjednavkyId(@Bind(value="abraStavObjednavkyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraStavObjednavkyId(@Bind(value="abraStavObjednavkyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE (p.abra_stav_objednavky_id IS NULL OR p.abra_stav_objednavky_id IN (SELECT abra_id FROM abra.stav_objednavky WHERE check_for = 'BALIKOBOT')) AND (p.balikobot_package_data IS NOT NULL AND p.balikobot_package_data != '')")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraStavObjednavkyIdNullOr2();

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId")
    public long findListByAbraStavObjednavkyIdCount(@Bind(value="abraStavObjednavkyId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_stav_objednavky_id = :abraStavObjednavkyId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraStavObjednavkyId(@Bind(value="abraStavObjednavkyId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_storno = :abraStorno")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraStorno(@Bind(value="abraStorno") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_storno = :abraStorno")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraStorno(@Bind(value="abraStorno") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_storno = :abraStorno")
    public long findListByAbraStornoCount(@Bind(value="abraStorno") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_storno = :abraStorno ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraStorno(@Bind(value="abraStorno") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_nazev_pobocky = :abraUlozNazevPobocky")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraUlozNazevPobocky(@Bind(value="abraUlozNazevPobocky") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_nazev_pobocky = :abraUlozNazevPobocky")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraUlozNazevPobocky(@Bind(value="abraUlozNazevPobocky") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_uloz_nazev_pobocky = :abraUlozNazevPobocky")
    public long findListByAbraUlozNazevPobockyCount(@Bind(value="abraUlozNazevPobocky") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_nazev_pobocky = :abraUlozNazevPobocky ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraUlozNazevPobocky(@Bind(value="abraUlozNazevPobocky") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_pobocka = :abraUlozPobocka")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraUlozPobocka(@Bind(value="abraUlozPobocka") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_pobocka = :abraUlozPobocka")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraUlozPobocka(@Bind(value="abraUlozPobocka") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_uloz_pobocka = :abraUlozPobocka")
    public long findListByAbraUlozPobockaCount(@Bind(value="abraUlozPobocka") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_pobocka = :abraUlozPobocka ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraUlozPobocka(@Bind(value="abraUlozPobocka") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_prepravni_sluzba = :abraUlozPrepravniSluzba")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByAbraUlozPrepravniSluzba(@Bind(value="abraUlozPrepravniSluzba") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_prepravni_sluzba = :abraUlozPrepravniSluzba")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraUlozPrepravniSluzba(@Bind(value="abraUlozPrepravniSluzba") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.abra_uloz_prepravni_sluzba = :abraUlozPrepravniSluzba")
    public long findListByAbraUlozPrepravniSluzbaCount(@Bind(value="abraUlozPrepravniSluzba") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.abra_uloz_prepravni_sluzba = :abraUlozPrepravniSluzba ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByAbraUlozPrepravniSluzba(@Bind(value="abraUlozPrepravniSluzba") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.zone_id = :zoneId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByZoneId(@Bind(value="zoneId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.zone_id = :zoneId")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByZoneId(@Bind(value="zoneId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.zone_id = :zoneId")
    public long findListByZoneIdCount(@Bind(value="zoneId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.zone_id = :zoneId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByZoneId(@Bind(value="zoneId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrdersMapper.class)
    public OrdersDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.orders p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.accountingtype, p.address_id, p.amount, p.amountwithoutvat, p.bankaccount_id, p.capacity, p.capacityunit, p.classid, p.closed, p.coef, p.confirmed, p.constsymbol_id, p.date_correctedat, p.correctedby_id, p.country_id, p.date_createdat, p.createdby_id, p.currency_id, p.currrate, p.currrateinfo, p.dealercategory_id, p.dealerdiscount, p.dealerdiscountkind, p.description, p.dirty, p.discountcalckind, p.displayname, p.date_docdate, p.docqueue_id, p.documentdiscount, p.donotrecalculateunitprice, p.externalnumber, p.financialdiscount, p.firm_id, p.firmoffice_id, p.frozendiscounts, p.intrastatdeliveryterm_id, p.intrastattransactiontype_id, p.intrastattransportationtype_id, p.isaccounted, p.isaccountedlatervat, p.isavailablefordelivery, p.isfinancialdiscount, p.isreversechargedeclared, p.isrowdiscount, p.localamount, p.localamountwithoutvat, p.localcoef, p.localrefcurrency_id, p.localroundingamount, p.localvatamount, p.localzone_id, p.margin, p.newrelateddocument_id, p.newrelatedtype, p.objversion, p.onlywholeorder, p.ordnumber, p.paymenttype_id, p.period_id, p.person_id, p.priceprecision, p.pricesbyref, p.priceswithvat, p.quantitydiscountkind, p.refcurrency_id, p.refcurrrate, p.revided_id, p.revision, p.revisionauthor_id, p.date_revisiondate, p.revisiondescription, p.roundingamount, p.storeprice, p.totaldiscountamount, p.totalrounding, p.tradetype, p.tradetypedescription, p.transportationtype_id, p.vatamount, p.vatcountry_id, p.vatdocument, p.vatfromaboveprecision, p.vatfromabovetype, p.vatrounding, p.weight, p.weightunit, p.abra_address1_id, p.abra_address2_id, p.abra_contacted, p.abra_endeddate, p.abra_params, p.abra_pd_bb_branches, p.abra_pd_bb_modul, p.abra_pd_bb_services, p.abra_pd_status, p.abra_stav_objednavky_id, p.abra_storno, p.abra_uloz_nazev_pobocky, p.abra_uloz_pobocka, p.abra_uloz_prepravni_sluzba, p.zone_id, p.balikobot_url, p.balikobot_package_data, p.order_firstname, p.order_lastname, p.order_phone, p.order_email, p.updated, p.pmstate_id, p.responsibleuser_id, p.responsiblerole_id, p.abra_zasilk_pobocka, p.abra_zasilk_adresa_pobocky, p.abra_email_sent, p.abra_paid, p.abra_paiddate, p.abra_billofdelivery_id, p.source, p.store_id, p.date_created FROM abra.orders p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrdersMapper.class)
    public List<OrdersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Bind(value="order") String var4);

    @SqlUpdate(value="INSERT INTO abra.orders (id, uid, abra_id, accountingtype, address_id, amount, amountwithoutvat, bankaccount_id, capacity, capacityunit, classid, closed, coef, confirmed, constsymbol_id, date_correctedat, correctedby_id, country_id, date_createdat, createdby_id, currency_id, currrate, currrateinfo, dealercategory_id, dealerdiscount, dealerdiscountkind, description, dirty, discountcalckind, displayname, date_docdate, docqueue_id, documentdiscount, donotrecalculateunitprice, externalnumber, financialdiscount, firm_id, firmoffice_id, frozendiscounts, intrastatdeliveryterm_id, intrastattransactiontype_id, intrastattransportationtype_id, isaccounted, isaccountedlatervat, isavailablefordelivery, isfinancialdiscount, isreversechargedeclared, isrowdiscount, localamount, localamountwithoutvat, localcoef, localrefcurrency_id, localroundingamount, localvatamount, localzone_id, margin, newrelateddocument_id, newrelatedtype, objversion, onlywholeorder, ordnumber, paymenttype_id, period_id, person_id, priceprecision, pricesbyref, priceswithvat, quantitydiscountkind, refcurrency_id, refcurrrate, revided_id, revision, revisionauthor_id, date_revisiondate, revisiondescription, roundingamount, storeprice, totaldiscountamount, totalrounding, tradetype, tradetypedescription, transportationtype_id, vatamount, vatcountry_id, vatdocument, vatfromaboveprecision, vatfromabovetype, vatrounding, weight, weightunit, abra_address1_id, abra_address2_id, abra_contacted, abra_endeddate, abra_params, abra_pd_bb_branches, abra_pd_bb_modul, abra_pd_bb_services, abra_pd_status, abra_stav_objednavky_id, abra_storno, abra_uloz_nazev_pobocky, abra_uloz_pobocka, abra_uloz_prepravni_sluzba, zone_id, date_created) VALUES (:id, :uid, :abraId, :accountingtype, :addressId, :amount, :amountwithoutvat, :bankaccountId, :capacity, :capacityunit, :classid, :closed, :coef, :confirmed, :constsymbolId, :dateCorrectedat, :correctedbyId, :countryId, :dateCreatedat, :createdbyId, :currencyId, :currrate, :currrateinfo, :dealercategoryId, :dealerdiscount, :dealerdiscountkind, :description, :dirty, :discountcalckind, :displayname, :dateDocdate, :docqueueId, :documentdiscount, :donotrecalculateunitprice, :externalnumber, :financialdiscount, :firmId, :firmofficeId, :frozendiscounts, :intrastatdeliverytermId, :intrastattransactiontypeId, :intrastattransportationtypeId, :isaccounted, :isaccountedlatervat, :isavailablefordelivery, :isfinancialdiscount, :isreversechargedeclared, :isrowdiscount, :localamount, :localamountwithoutvat, :localcoef, :localrefcurrencyId, :localroundingamount, :localvatamount, :localzoneId, :margin, :newrelateddocumentId, :newrelatedtype, :objversion, :onlywholeorder, :ordnumber, :paymenttypeId, :periodId, :personId, :priceprecision, :pricesbyref, :priceswithvat, :quantitydiscountkind, :refcurrencyId, :refcurrrate, :revidedId, :revision, :revisionauthorId, :dateRevisiondate, :revisiondescription, :roundingamount, :storeprice, :totaldiscountamount, :totalrounding, :tradetype, :tradetypedescription, :transportationtypeId, :vatamount, :vatcountryId, :vatdocument, :vatfromaboveprecision, :vatfromabovetype, :vatrounding, :weight, :weightunit, :abraAddress1Id, :abraAddress2Id, :abraContacted, :abraEndeddate, :abraParams, :abraPdBbBranches, :abraPdBbModul, :abraPdBbServices, :abraPdStatus, :abraStavObjednavkyId, :abraStorno, :abraUlozNazevPobocky, :abraUlozPobocka, :abraUlozPrepravniSluzba, :zoneId, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="abraId") String var3, @Bind(value="accountingtype") Integer var4, @Bind(value="addressId") String var5, @Bind(value="amount") Integer var6, @Bind(value="amountwithoutvat") Double var7, @Bind(value="bankaccountId") String var8, @Bind(value="capacity") Integer var9, @Bind(value="capacityunit") Integer var10, @Bind(value="classid") String var11, @Bind(value="closed") Boolean var12, @Bind(value="coef") Integer var13, @Bind(value="confirmed") Boolean var14, @Bind(value="constsymbolId") String var15, @Bind(value="dateCorrectedat") Date var16, @Bind(value="correctedbyId") String var17, @Bind(value="countryId") String var18, @Bind(value="dateCreatedat") Date var19, @Bind(value="createdbyId") String var20, @Bind(value="currencyId") String var21, @Bind(value="currrate") Integer var22, @Bind(value="currrateinfo") String var23, @Bind(value="dealercategoryId") String var24, @Bind(value="dealerdiscount") Integer var25, @Bind(value="dealerdiscountkind") Integer var26, @Bind(value="description") String var27, @Bind(value="dirty") Boolean var28, @Bind(value="discountcalckind") Integer var29, @Bind(value="displayname") String var30, @Bind(value="dateDocdate") Date var31, @Bind(value="docqueueId") String var32, @Bind(value="documentdiscount") Integer var33, @Bind(value="donotrecalculateunitprice") Boolean var34, @Bind(value="externalnumber") String var35, @Bind(value="financialdiscount") Integer var36, @Bind(value="firmId") String var37, @Bind(value="firmofficeId") String var38, @Bind(value="frozendiscounts") Boolean var39, @Bind(value="intrastatdeliverytermId") String var40, @Bind(value="intrastattransactiontypeId") String var41, @Bind(value="intrastattransportationtypeId") String var42, @Bind(value="isaccounted") Boolean var43, @Bind(value="isaccountedlatervat") Boolean var44, @Bind(value="isavailablefordelivery") Boolean var45, @Bind(value="isfinancialdiscount") Boolean var46, @Bind(value="isreversechargedeclared") Boolean var47, @Bind(value="isrowdiscount") Boolean var48, @Bind(value="localamount") Integer var49, @Bind(value="localamountwithoutvat") Double var50, @Bind(value="localcoef") Integer var51, @Bind(value="localrefcurrencyId") String var52, @Bind(value="localroundingamount") Integer var53, @Bind(value="localvatamount") Double var54, @Bind(value="localzoneId") String var55, @Bind(value="margin") Double var56, @Bind(value="newrelateddocumentId") String var57, @Bind(value="newrelatedtype") Integer var58, @Bind(value="objversion") Integer var59, @Bind(value="onlywholeorder") Boolean var60, @Bind(value="ordnumber") Integer var61, @Bind(value="paymenttypeId") String var62, @Bind(value="periodId") String var63, @Bind(value="personId") String var64, @Bind(value="priceprecision") Integer var65, @Bind(value="pricesbyref") Boolean var66, @Bind(value="priceswithvat") Boolean var67, @Bind(value="quantitydiscountkind") Integer var68, @Bind(value="refcurrencyId") String var69, @Bind(value="refcurrrate") Integer var70, @Bind(value="revidedId") String var71, @Bind(value="revision") Integer var72, @Bind(value="revisionauthorId") String var73, @Bind(value="dateRevisiondate") Date var74, @Bind(value="revisiondescription") String var75, @Bind(value="roundingamount") Integer var76, @Bind(value="storeprice") Double var77, @Bind(value="totaldiscountamount") Integer var78, @Bind(value="totalrounding") Integer var79, @Bind(value="tradetype") Integer var80, @Bind(value="tradetypedescription") String var81, @Bind(value="transportationtypeId") String var82, @Bind(value="vatamount") Double var83, @Bind(value="vatcountryId") String var84, @Bind(value="vatdocument") Boolean var85, @Bind(value="vatfromaboveprecision") Integer var86, @Bind(value="vatfromabovetype") Integer var87, @Bind(value="vatrounding") Integer var88, @Bind(value="weight") Double var89, @Bind(value="weightunit") Integer var90, @Bind(value="abraAddress1Id") String var91, @Bind(value="abraAddress2Id") String var92, @Bind(value="abraContacted") Boolean var93, @Bind(value="abraEndeddate") Date var94, @Bind(value="abraParams") String var95, @Bind(value="abraPdBbBranches") String var96, @Bind(value="abraPdBbModul") String var97, @Bind(value="abraPdBbServices") String var98, @Bind(value="abraPdStatus") Integer var99, @Bind(value="abraStavObjednavkyId") String var100, @Bind(value="abraStorno") Boolean var101, @Bind(value="abraUlozNazevPobocky") String var102, @Bind(value="abraUlozPobocka") String var103, @Bind(value="abraUlozPrepravniSluzba") String var104, @Bind(value="zoneId") String var105, @Bind(value="dateCreated") Date var106);

    @SqlUpdate(value="INSERT INTO abra.orders (abra_id, accountingtype, address_id, amount, amountwithoutvat, bankaccount_id, capacity, capacityunit, classid, closed, coef, confirmed, constsymbol_id, date_correctedat, correctedby_id, country_id, date_createdat, createdby_id, currency_id, currrate, currrateinfo, dealercategory_id, dealerdiscount, dealerdiscountkind, description, dirty, discountcalckind, displayname, date_docdate, docqueue_id, documentdiscount, donotrecalculateunitprice, externalnumber, financialdiscount, firm_id, firmoffice_id, frozendiscounts, intrastatdeliveryterm_id, intrastattransactiontype_id, intrastattransportationtype_id, isaccounted, isaccountedlatervat, isavailablefordelivery, isfinancialdiscount, isreversechargedeclared, isrowdiscount, localamount, localamountwithoutvat, localcoef, localrefcurrency_id, localroundingamount, localvatamount, localzone_id, margin, newrelateddocument_id, newrelatedtype, objversion, onlywholeorder, ordnumber, paymenttype_id, period_id, person_id, priceprecision, pricesbyref, priceswithvat, quantitydiscountkind, refcurrency_id, refcurrrate, revided_id, revision, revisionauthor_id, date_revisiondate, revisiondescription, roundingamount, storeprice, totaldiscountamount, totalrounding, tradetype, tradetypedescription, transportationtype_id, vatamount, vatcountry_id, vatdocument, vatfromaboveprecision, vatfromabovetype, vatrounding, weight, weightunit, abra_address1_id, abra_address2_id, abra_contacted, abra_endeddate, abra_params, abra_pd_bb_branches, abra_pd_bb_modul, abra_pd_bb_services, abra_pd_status, abra_stav_objednavky_id, abra_storno, abra_uloz_nazev_pobocky, abra_uloz_pobocka, abra_uloz_prepravni_sluzba, zone_id, date_created, balikobot_url, balikobot_package_data, source, store_id, abra_paid, abra_paiddate, abra_billofdelivery_id, order_firstname, order_lastname, order_phone, order_email) VALUES (:e.abraId, :e.accountingtype, :e.addressId, :e.amount, :e.amountwithoutvat, :e.bankaccountId, :e.capacity, :e.capacityunit, :e.classid, :e.closed, :e.coef, :e.confirmed, :e.constsymbolId, :e.dateCorrectedat, :e.correctedbyId, :e.countryId, :e.dateCreatedat, :e.createdbyId, :e.currencyId, :e.currrate, :e.currrateinfo, :e.dealercategoryId, :e.dealerdiscount, :e.dealerdiscountkind, :e.description, :e.dirty, :e.discountcalckind, :e.displayname, :e.dateDocdate, :e.docqueueId, :e.documentdiscount, :e.donotrecalculateunitprice, :e.externalnumber, :e.financialdiscount, :e.firmId, :e.firmofficeId, :e.frozendiscounts, :e.intrastatdeliverytermId, :e.intrastattransactiontypeId, :e.intrastattransportationtypeId, :e.isaccounted, :e.isaccountedlatervat, :e.isavailablefordelivery, :e.isfinancialdiscount, :e.isreversechargedeclared, :e.isrowdiscount, :e.localamount, :e.localamountwithoutvat, :e.localcoef, :e.localrefcurrencyId, :e.localroundingamount, :e.localvatamount, :e.localzoneId, :e.margin, :e.newrelateddocumentId, :e.newrelatedtype, :e.objversion, :e.onlywholeorder, :e.ordnumber, :e.paymenttypeId, :e.periodId, :e.personId, :e.priceprecision, :e.pricesbyref, :e.priceswithvat, :e.quantitydiscountkind, :e.refcurrencyId, :e.refcurrrate, :e.revidedId, :e.revision, :e.revisionauthorId, :e.dateRevisiondate, :e.revisiondescription, :e.roundingamount, :e.storeprice, :e.totaldiscountamount, :e.totalrounding, :e.tradetype, :e.tradetypedescription, :e.transportationtypeId, :e.vatamount, :e.vatcountryId, :e.vatdocument, :e.vatfromaboveprecision, :e.vatfromabovetype, :e.vatrounding, :e.weight, :e.weightunit, :e.abraAddress1Id, :e.abraAddress2Id, :e.abraContacted, :e.abraEndeddate, :e.abraParams, :e.abraPdBbBranches, :e.abraPdBbModul, :e.abraPdBbServices, :e.abraPdStatus, :e.abraStavObjednavkyId, :e.abraStorno, :e.abraUlozNazevPobocky, :e.abraUlozPobocka, :e.abraUlozPrepravniSluzba, :e.zoneId, :e.dateCreated, :e.balikobotUrl, :e.balikobotPackageData, :e.source, :e.storeId, :e.abraPaid, :e.abraPaiddate, :e.abraBillOfDeliveryId, :e.orderFirstname, :e.orderLastname, :e.orderPhone, :e.orderEmail)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrdersDomain var1);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrdersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.orders SET order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname WHERE id = :byId")
    public int updateOrderNamesById(@BindBean(value="e") OrdersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.orders SET order_phone = :e.orderPhone WHERE id = :byId")
    public int updateOrderPhoneById(@BindBean(value="e") OrdersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.orders SET order_email = :e.orderEmail WHERE id = :byId")
    public int updateOrderEmailById(@BindBean(value="e") OrdersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.orders SET abra_stav_objednavky_id = :abraStavObjednavkyId WHERE id = :byId")
    public int updateAbraStavObjednavkyIdById(@Bind(value="abraStavObjednavkyId") String var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrdersDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") OrdersDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE accountingtype = :byAccountingtype")
    public int updateByAccountingtype(@BindBean(value="e") OrdersDomain var1, @Bind(value="byAccountingtype") Integer var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE address_id = :byAddressId")
    public int updateByAddressId(@BindBean(value="e") OrdersDomain var1, @Bind(value="byAddressId") String var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE amount = :byAmount")
    public int updateByAmount(@BindBean(value="e") OrdersDomain var1, @Bind(value="byAmount") Integer var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE amountwithoutvat = :byAmountwithoutvat")
    public int updateByAmountwithoutvat(@BindBean(value="e") OrdersDomain var1, @Bind(value="byAmountwithoutvat") Double var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE bankaccount_id = :byBankaccountId")
    public int updateByBankaccountId(@BindBean(value="e") OrdersDomain var1, @Bind(value="byBankaccountId") String var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE capacity = :byCapacity")
    public int updateByCapacity(@BindBean(value="e") OrdersDomain var1, @Bind(value="byCapacity") Integer var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE capacityunit = :byCapacityunit")
    public int updateByCapacityunit(@BindBean(value="e") OrdersDomain var1, @Bind(value="byCapacityunit") Integer var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE classid = :byClassid")
    public int updateByClassid(@BindBean(value="e") OrdersDomain var1, @Bind(value="byClassid") String var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE closed = :byClosed")
    public int updateByClosed(@BindBean(value="e") OrdersDomain var1, @Bind(value="byClosed") Boolean var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE coef = :byCoef")
    public int updateByCoef(@BindBean(value="e") OrdersDomain var1, @Bind(value="byCoef") Integer var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE confirmed = :byConfirmed")
    public int updateByConfirmed(@BindBean(value="e") OrdersDomain var1, @Bind(value="byConfirmed") Boolean var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCreated WHERE constsymbol_id = :byConstsymbolId")
    public int updateByConstsymbolId(@BindBean(value="e") OrdersDomain var1, @Bind(value="byConstsymbolId") String var2);

    @SqlUpdate(value="UPDATE abra.orders SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, accountingtype = :e.accountingtype, address_id = :e.addressId, amount = :e.amount, amountwithoutvat = :e.amountwithoutvat, bankaccount_id = :e.bankaccountId, capacity = :e.capacity, capacityunit = :e.capacityunit, classid = :e.classid, closed = :e.closed, coef = :e.coef, confirmed = :e.confirmed, constsymbol_id = :e.constsymbolId, date_correctedat = :e.dateCorrectedat, correctedby_id = :e.correctedbyId, country_id = :e.countryId, date_createdat = :e.dateCreatedat, createdby_id = :e.createdbyId, currency_id = :e.currencyId, currrate = :e.currrate, currrateinfo = :e.currrateinfo, dealercategory_id = :e.dealercategoryId, dealerdiscount = :e.dealerdiscount, dealerdiscountkind = :e.dealerdiscountkind, description = :e.description, dirty = :e.dirty, discountcalckind = :e.discountcalckind, displayname = :e.displayname, date_docdate = :e.dateDocdate, docqueue_id = :e.docqueueId, documentdiscount = :e.documentdiscount, donotrecalculateunitprice = :e.donotrecalculateunitprice, externalnumber = :e.externalnumber, financialdiscount = :e.financialdiscount, firm_id = :e.firmId, firmoffice_id = :e.firmofficeId, frozendiscounts = :e.frozendiscounts, intrastatdeliveryterm_id = :e.intrastatdeliverytermId, intrastattransactiontype_id = :e.intrastattransactiontypeId, intrastattransportationtype_id = :e.intrastattransportationtypeId, isaccounted = :e.isaccounted, isaccountedlatervat = :e.isaccountedlatervat, isavailablefordelivery = :e.isavailablefordelivery, isfinancialdiscount = :e.isfinancialdiscount, isreversechargedeclared = :e.isreversechargedeclared, isrowdiscount = :e.isrowdiscount, localamount = :e.localamount, localamountwithoutvat = :e.localamountwithoutvat, localcoef = :e.localcoef, localrefcurrency_id = :e.localrefcurrencyId, localroundingamount = :e.localroundingamount, localvatamount = :e.localvatamount, localzone_id = :e.localzoneId, margin = :e.margin, newrelateddocument_id = :e.newrelateddocumentId, newrelatedtype = :e.newrelatedtype, objversion = :e.objversion, onlywholeorder = :e.onlywholeorder, ordnumber = :e.ordnumber, paymenttype_id = :e.paymenttypeId, period_id = :e.periodId, person_id = :e.personId, priceprecision = :e.priceprecision, pricesbyref = :e.pricesbyref, priceswithvat = :e.priceswithvat, quantitydiscountkind = :e.quantitydiscountkind, refcurrency_id = :e.refcurrencyId, refcurrrate = :e.refcurrrate, revided_id = :e.revidedId, revision = :e.revision, revisionauthor_id = :e.revisionauthorId, date_revisiondate = :e.dateRevisiondate, revisiondescription = :e.revisiondescription, roundingamount = :e.roundingamount, storeprice = :e.storeprice, totaldiscountamount = :e.totaldiscountamount, totalrounding = :e.totalrounding, tradetype = :e.tradetype, tradetypedescription = :e.tradetypedescription, transportationtype_id = :e.transportationtypeId, vatamount = :e.vatamount, vatcountry_id = :e.vatcountryId, vatdocument = :e.vatdocument, vatfromaboveprecision = :e.vatfromaboveprecision, vatfromabovetype = :e.vatfromabovetype, vatrounding = :e.vatrounding, weight = :e.weight, weightunit = :e.weightunit, abra_address1_id = :e.abraAddress1Id, abra_address2_id = :e.abraAddress2Id, abra_contacted = :e.abraContacted, abra_endeddate = :e.abraEndeddate, abra_params = :e.abraParams, abra_pd_bb_branches = :e.abraPdBbBranches, abra_pd_bb_modul = :e.abraPdBbModul, abra_pd_bb_services = :e.abraPdBbServices, abra_pd_status = :e.abraPdStatus, abra_stav_objednavky_id = :e.abraStavObjednavkyId, abra_storno = :e.abraStorno, abra_uloz_nazev_pobocky = :e.abraUlozNazevPobocky, abra_uloz_pobocka = :e.abraUlozPobocka, abra_uloz_prepravni_sluzba = :e.abraUlozPrepravniSluzba, zone_id = :e.zoneId, balikobot_url = :e.balikobotUrl, balikobot_package_data = :e.balikobotPackageData, order_firstname = :e.orderFirstname, order_lastname = :e.orderLastname, order_phone = :e.orderPhone, order_email = :e.orderEmail, updated = :e.updated, pmstate_id = :e.pmstateId, responsibleuser_id = :e.responsibleuserId, responsiblerole_id = :e.responsibleroleId, abra_zasilk_pobocka = :e.abraZasilkPobocka, abra_zasilk_adresa_pobocky = :e.abraZasilkAdresaPobocky,abra_email_sent = :e.abraEmailSent, abra_paid = :e.abraPaid, abra_paiddate = :e.abraPaiddate, abra_billofdelivery_id = :e.abraBillOfDeliveryId, store_id = :e.storeId, date_created = :e.dateCr