/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrderStatusLogMapper;
import cz.airtoy.airshop.domains.OrderStatusLogDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrderStatusLogDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.order_id,\n\t\tabra_orders.uid AS order_uid,\n\t\tp.status,\n\t\tp.status_text,\n\t\tp.system,\n\t\tp.confirmed,\n\t\tp.date_created\n FROM \n\t\tabra.order_status_log p\n\tLEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id)\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.status_text::text ~* :mask \n\tOR \n\t\tp.system::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.order_status_log p\n\tLEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id)\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.status_text::text ~* :mask \n\tOR \n\t\tp.system::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.id = :id")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.id = :id")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.order_id = :orderId AND p.status = :status")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findByOrderIdStatus(@Bind(value="orderId") Long var1, @Bind(value="status") String var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.order_id = :orderId ORDER BY p.id DESC LIMIT 1")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findByOrderIdLast(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p INNER JOIN abra.view_stav_objednavky abra_stav_objednavky ON (p.status = abra_stav_objednavky.abra_id) WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p INNER JOIN abra.view_stav_objednavky abra_stav_objednavky ON (p.status = abra_stav_objednavky.abra_id) LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p LEFT OUTER JOIN abra.view_stav_objednavky abra_stav_objednavky ON (p.status = abra_stav_objednavky.abra_id) WHERE p.order_id = :orderId AND p.system = :system")
    public long findListByOrderIdSystemCount(@Bind(value="orderId") Long var1, @Bind(value="system") String var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.view_stav_objednavky abra_stav_objednavky ON (p.status = abra_stav_objednavky.abra_id) LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.order_id = :orderId AND p.system = :system ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByOrderIdSystem(@Bind(value="orderId") Long var1, @Bind(value="system") String var2, @Bind(value="offset") int var3, @Bind(value="limit") int var4, @Define(value="order") String var5, @Define(value="sort") String var6);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status = :status")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status = :status")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status_text = :statusText")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findByStatusText(@Bind(value="statusText") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status_text = :statusText")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByStatusText(@Bind(value="statusText") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status_text = :statusText")
    public long findListByStatusTextCount(@Bind(value="statusText") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.status_text = :statusText ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByStatusText(@Bind(value="statusText") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.system = :system")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findBySystem(@Bind(value="system") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.system = :system")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListBySystem(@Bind(value="system") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.system = :system")
    public long findListBySystemCount(@Bind(value="system") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.system = :system ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListBySystem(@Bind(value="system") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public OrderStatusLogDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, abra_orders.uid AS order_uid, p.status, p.status_text, p.system, p.confirmed, p.date_created FROM abra.order_status_log p LEFT OUTER JOIN abra.orders abra_orders ON (p.order_id = abra_orders.id) WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderStatusLogMapper.class)
    public List<OrderStatusLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.order_status_log (id, uid, order_id, status, status_text, system, date_created) VALUES (:id, :uid, :orderId, :status, :statusText, :system, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="orderId") Long var3, @Bind(value="status") String var4, @Bind(value="statusText") String var5, @Bind(value="system") String var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO abra.order_status_log (order_id, status, status_text, system, date_created) VALUES (:e.orderId, :e.status, :e.statusText, :e.system, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrderStatusLogDomain var1);

    @SqlUpdate(value="UPDATE abra.order_status_log SET id = :e.id, uid = :e.uid, order_id = :e.orderId, status = :e.status, status_text = :e.statusText, system = :e.system, confirmed = :e.confirmed, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrderStatusLogDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_status_log SET id = :e.id, uid = :e.uid, order_id = :e.orderId, status = :e.status, status_text = :e.statusText, system = :e.system, confirmed = :e.confirmed, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrderStatusLogDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.order_status_log SET id = :e.id, uid = :e.uid, order_id = :e.orderId, status = :e.status, status_text = :e.statusText, system = :e.system, confirmed = :e.confirmed, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") OrderStatusLogDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_status_log SET id = :e.id, uid = :e.uid, order_id = :e.orderId, status = :e.status, status_text = :e.statusText, system = :e.system, confirmed = :e.confirmed, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") OrderStatusLogDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE abra.order_status_log SET id = :e.id, uid = :e.uid, order_id = :e.orderId, status = :e.status, status_text = :e.statusText, system = :e.system, confirmed = :e.confirmed, date_created = :e.dateCreated WHERE status_text = :byStatusText")
    public int updateByStatusText(@BindBean(value="e") OrderStatusLogDomain var1, @Bind(value="byStatusText") String var2);

    @SqlUpdate(value="UPDATE abra.order_status_log SET id = :e.id, uid = :e.uid, order_id = :e.orderId, status = :e.status, status_text = :e.statusText, system = :e.system, confirmed = :e.confirmed, date_created = :e.dateCreated WHERE system = :bySystem")
    public int updateBySystem(@BindBean(value="e") OrderStatusLogDomain var1, @Bind(value="bySystem") String var2);

    @SqlUpdate(value="UPDATE abra.order_status_log SET id = :e.id, uid = :e.uid, order_id = :e.orderId, status = :e.status, status_text = :e.statusText, system = :e.system, confirmed = :e.confirmed, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") OrderStatusLogDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.order_status_log WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_status_log WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_status_log WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_status_log WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_status_log WHERE status_text = :statusText")
    public int deleteByStatusText(@Bind(value="statusText") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_status_log WHERE system = :system")
    public int deleteBySystem(@Bind(value="system") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_status_log WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

