/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.email;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.email.TemplateTagsMapper;
import cz.airtoy.airshop.domains.email.TemplateTagsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TemplateTagsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.template_id,\n\t\tp.tag_name,\n\t\tp.date_created\n FROM \n\t\temail.template_tags p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.template_id::text ~* :mask \n\tOR \n\t\tp.tag_name::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\temail.template_tags p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.template_id::text ~* :mask \n\tOR \n\t\tp.tag_name::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  ")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.id = :id")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public TemplateTagsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.id = :id")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_tags p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public TemplateTagsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_tags p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.template_id = :templateId")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public TemplateTagsDomain findByTemplateId(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.template_id = :templateId")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByTemplateId(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_tags p  WHERE p.template_id = :templateId")
    public long findListByTemplateIdCount(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.template_id = :templateId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByTemplateId(@Bind(value="templateId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.tag_name = :tagName")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public TemplateTagsDomain findByTagName(@Bind(value="tagName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.tag_name = :tagName")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByTagName(@Bind(value="tagName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_tags p  WHERE p.tag_name = :tagName")
    public long findListByTagNameCount(@Bind(value="tagName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.tag_name = :tagName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByTagName(@Bind(value="tagName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public TemplateTagsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_tags p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.tag_name, p.date_created FROM email.template_tags p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateTagsMapper.class)
    public List<TemplateTagsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO email.template_tags (id, uid, template_id, tag_name, date_created) VALUES (:id, :uid, :templateId, :tagName, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="templateId") Long var3, @Bind(value="tagName") String var4, @Bind(value="dateCreated") Date var5);

    @SqlUpdate(value="INSERT INTO email.template_tags (template_id, tag_name, date_created) VALUES (:e.templateId, :e.tagName, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TemplateTagsDomain var1);

    @SqlUpdate(value="UPDATE email.template_tags SET id = :e.id, uid = :e.uid, template_id = :e.templateId, tag_name = :e.tagName, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TemplateTagsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE email.template_tags SET id = :e.id, uid = :e.uid, template_id = :e.templateId, tag_name = :e.tagName, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TemplateTagsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE email.template_tags SET id = :e.id, uid = :e.uid, template_id = :e.templateId, tag_name = :e.tagName, date_created = :e.dateCreated WHERE template_id = :byTemplateId")
    public int updateByTemplateId(@BindBean(value="e") TemplateTagsDomain var1, @Bind(value="byTemplateId") Long var2);

    @SqlUpdate(value="UPDATE email.template_tags SET id = :e.id, uid = :e.uid, template_id = :e.templateId, tag_name = :e.tagName, date_created = :e.dateCreated WHERE tag_name = :byTagName")
    public int updateByTagName(@BindBean(value="e") TemplateTagsDomain var1, @Bind(value="byTagName") String var2);

    @SqlUpdate(value="UPDATE email.template_tags SET id = :e.id, uid = :e.uid, template_id = :e.templateId, tag_name = :e.tagName, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TemplateTagsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM email.template_tags WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM email.template_tags WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM email.template_tags WHERE template_id = :templateId")
    public int deleteByTemplateId(@Bind(value="templateId") Long var1);

    @SqlUpdate(value="DELETE FROM email.template_tags WHERE tag_name = :tagName")
    public int deleteByTagName(@Bind(value="tagName") String var1);

    @SqlUpdate(value="DELETE FROM email.template_tags WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

