/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.abra;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.abra.AbraStoremenuMapper;
import cz.airtoy.airshop.domains.abra.AbraStoremenuDomain;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface AbraStoremenuDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.ID,\n\t\tp.POSINDEX,\n\t\tp.HIDDEN,\n\t\tp.PARENT_ID,\n\t\tp.TEXT,\n\t\tp.OBJVERSION\n FROM \n\t\tSTOREMENU p\n\t\n\t\tWHERE \n\t\tp.ID::text ~* :mask \n\tOR \n\t\tp.POSINDEX::text ~* :mask \n\tOR \n\t\tp.HIDDEN::text ~* :mask \n\tOR \n\t\tp.PARENT_ID::text ~* :mask \n\tOR \n\t\tp.TEXT::text ~* :mask \n\tOR \n\t\tp.OBJVERSION::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tSTOREMENU p\n\t\n\t\tWHERE \n\t\tp.ID::text ~* :mask \n\tOR \n\t\tp.POSINDEX::text ~* :mask \n\tOR \n\t\tp.HIDDEN::text ~* :mask \n\tOR \n\t\tp.PARENT_ID::text ~* :mask \n\tOR \n\t\tp.TEXT::text ~* :mask \n\tOR \n\t\tp.OBJVERSION::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  ")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListAll();

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.ID = :id")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public AbraStoremenuDomain findById(@Bind(value="id") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.ID = :id")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListById(@Bind(value="id") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREMENU p  WHERE p.ID = :id")
    public long findListByIdCount(@Bind(value="id") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.ID = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListById(@Bind(value="id") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.POSINDEX = :posindex")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public AbraStoremenuDomain findByPosindex(@Bind(value="posindex") Integer var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.POSINDEX = :posindex")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByPosindex(@Bind(value="posindex") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREMENU p  WHERE p.POSINDEX = :posindex")
    public long findListByPosindexCount(@Bind(value="posindex") Integer var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.POSINDEX = :posindex ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByPosindex(@Bind(value="posindex") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.HIDDEN = :hidden")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public AbraStoremenuDomain findByHidden(@Bind(value="hidden") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.HIDDEN = :hidden")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByHidden(@Bind(value="hidden") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREMENU p  WHERE p.HIDDEN = :hidden")
    public long findListByHiddenCount(@Bind(value="hidden") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.HIDDEN = :hidden ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByHidden(@Bind(value="hidden") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.PARENT_ID = :parentId")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public AbraStoremenuDomain findByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.PARENT_ID = :parentId")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREMENU p  WHERE p.PARENT_ID = :parentId")
    public long findListByParentIdCount(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.PARENT_ID = :parentId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByParentId(@Bind(value="parentId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.TEXT = :text")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public AbraStoremenuDomain findByText(@Bind(value="text") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.TEXT = :text")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByText(@Bind(value="text") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREMENU p  WHERE p.TEXT = :text")
    public long findListByTextCount(@Bind(value="text") String var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.TEXT = :text ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByText(@Bind(value="text") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.OBJVERSION = :objversion")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public AbraStoremenuDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.OBJVERSION = :objversion")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREMENU p  WHERE p.OBJVERSION = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.ID, p.POSINDEX, p.HIDDEN, p.PARENT_ID, p.TEXT, p.OBJVERSION FROM STOREMENU p  WHERE p.OBJVERSION = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoremenuMapper.class)
    public List<AbraStoremenuDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO STOREMENU (ID, POSINDEX, HIDDEN, PARENT_ID, TEXT, OBJVERSION) VALUES (:id, :posindex, :hidden, :parentId, :text, :objversion)")
    @GetGeneratedKeys
    public int insert(@Bind(value="id") String var1, @Bind(value="posindex") Integer var2, @Bind(value="hidden") String var3, @Bind(value="parentId") String var4, @Bind(value="text") String var5, @Bind(value="objversion") Integer var6);

    @SqlUpdate(value="INSERT INTO STOREMENU (ID, POSINDEX, HIDDEN, PARENT_ID, TEXT, OBJVERSION) VALUES (:e.id, :e.posindex, :e.hidden, :e.parentId, :e.text, :e.objversion)")
    @GetGeneratedKeys
    public int insert(@BindBean(value="e") AbraStoremenuDomain var1);

    @SqlUpdate(value="UPDATE STOREMENU SET ID = :e.id, POSINDEX = :e.posindex, HIDDEN = :e.hidden, PARENT_ID = :e.parentId, TEXT = :e.text, OBJVERSION = :e.objversion WHERE ID = :byId")
    public int updateById(@BindBean(value="e") AbraStoremenuDomain var1, @Bind(value="byId") String var2);

    @SqlUpdate(value="UPDATE STOREMENU SET ID = :e.id, POSINDEX = :e.posindex, HIDDEN = :e.hidden, PARENT_ID = :e.parentId, TEXT = :e.text, OBJVERSION = :e.objversion WHERE POSINDEX = :byPosindex")
    public int updateByPosindex(@BindBean(value="e") AbraStoremenuDomain var1, @Bind(value="byPosindex") Integer var2);

    @SqlUpdate(value="UPDATE STOREMENU SET ID = :e.id, POSINDEX = :e.posindex, HIDDEN = :e.hidden, PARENT_ID = :e.parentId, TEXT = :e.text, OBJVERSION = :e.objversion WHERE HIDDEN = :byHidden")
    public int updateByHidden(@BindBean(value="e") AbraStoremenuDomain var1, @Bind(value="byHidden") String var2);

    @SqlUpdate(value="UPDATE STOREMENU SET ID = :e.id, POSINDEX = :e.posindex, HIDDEN = :e.hidden, PARENT_ID = :e.parentId, TEXT = :e.text, OBJVERSION = :e.objversion WHERE PARENT_ID = :byParentId")
    public int updateByParentId(@BindBean(value="e") AbraStoremenuDomain var1, @Bind(value="byParentId") String var2);

    @SqlUpdate(value="UPDATE STOREMENU SET ID = :e.id, POSINDEX = :e.posindex, HIDDEN = :e.hidden, PARENT_ID = :e.parentId, TEXT = :e.text, OBJVERSION = :e.objversion WHERE TEXT = :byText")
    public int updateByText(@BindBean(value="e") AbraStoremenuDomain var1, @Bind(value="byText") String var2);

    @SqlUpdate(value="UPDATE STOREMENU SET ID = :e.id, POSINDEX = :e.posindex, HIDDEN = :e.hidden, PARENT_ID = :e.parentId, TEXT = :e.text, OBJVERSION = :e.objversion WHERE OBJVERSION = :byObjversion")
    public int updateByObjversion(@BindBean(value="e") AbraStoremenuDomain var1, @Bind(value="byObjversion") Integer var2);

    @SqlUpdate(value="DELETE FROM STOREMENU WHERE ID = :id")
    public int deleteById(@Bind(value="id") String var1);

    @SqlUpdate(value="DELETE FROM STOREMENU WHERE POSINDEX = :posindex")
    public int deleteByPosindex(@Bind(value="posindex") Integer var1);

    @SqlUpdate(value="DELETE FROM STOREMENU WHERE HIDDEN = :hidden")
    public int deleteByHidden(@Bind(value="hidden") String var1);

    @SqlUpdate(value="DELETE FROM STOREMENU WHERE PARENT_ID = :parentId")
    public int deleteByParentId(@Bind(value="parentId") String var1);

    @SqlUpdate(value="DELETE FROM STOREMENU WHERE TEXT = :text")
    public int deleteByText(@Bind(value="text") String var1);

    @SqlUpdate(value="DELETE FROM STOREMENU WHERE OBJVERSION = :objversion")
    public int deleteByObjversion(@Bind(value="objversion") Integer var1);
}

