/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.mappers.data.full;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import cz.airtoy.airshop.dao.mappers.common.BaseMapper;
import cz.airtoy.airshop.dao.mappers.data.TargetCommodityMapper;
import cz.airtoy.airshop.domains.data.TargetCommodityDomain;
import cz.airtoy.airshop.domains.data.TargetCommodityVariantDomain;
import cz.airtoy.airshop.domains.data.full.TargetCategoryFullDomain;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetCommodityFullMapper
extends BaseMapper
implements RowMapper<TargetCommodityDomain> {
    private static final Logger log = LoggerFactory.getLogger(TargetCommodityFullMapper.class);

    public TargetCommodityDomain map(ResultSet resultSet, StatementContext ctx) throws SQLException {
        TargetCommodityDomain d = new TargetCommodityDomain();
        TargetCommodityMapper.process(resultSet, d);
        d.setManufacturer(TargetCommodityFullMapper.getString(resultSet, "manufacturer"));
        TargetCommodityFullMapper.addVariants(resultSet, d);
        TargetCommodityFullMapper.addCategories(resultSet, d);
        d.setAbraAlkohol(TargetCommodityFullMapper.getDouble(resultSet, "abra_alkohol"));
        d.setAbraPlato(TargetCommodityFullMapper.getDouble(resultSet, "abra_plato"));
        d.setAbraObjemlitry(TargetCommodityFullMapper.getDouble(resultSet, "abra_objemlitry"));
        return d;
    }

    public static void addVariants(ResultSet resultSet, TargetCommodityDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String variants = TargetCommodityFullMapper.getString(resultSet, "variants");
            if (variants != null && !variants.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(variants, new TypeToken<List<TargetCommodityVariantDomain>>(){}.getType())) != null) {
                d.setVariants(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }

    public static void addCategories(ResultSet resultSet, TargetCommodityDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String categories = TargetCommodityFullMapper.getString(resultSet, "categories");
            if (categories != null && !categories.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(categories, new TypeToken<List<TargetCategoryFullDomain>>(){}.getType())) != null) {
                d.setCategories(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }
}

