/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.upgates;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.upgates.WarehouseStoreCardsPricesMapper;
import cz.airtoy.airshop.domains.upgates.WarehouseStoreCardsPricesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface WarehouseStoreCardsPricesDbiDao
extends BaseDao {
    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET date_synced = NULL, date_changed = NOW(), ident = NULL, message = NULL WHERE store_cards_code = :byStorecardCode")
    public int updateForceSyncByStorecardCode(@Bind(value="byStorecardCode") String var1);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.pricelist_id,\n\t\tp.price_definitions_id,\n\t\tp.store_cards_id,\n\t\tp.currency_code,\n\t\tp.store_cards_code,\n\t\tp.objversion,\n\t\tp.qunit,\n\t\tp.unitrate,\n\t\tp.amount,\n\t\tp.date_synced,\n\t\tp.date_changed,\n\t\tp.date_updated,\n\t\tp.date_created,\n\t\tp.version,\n\t\tp.ident,\n\t\tp.message\n FROM \n\t\tupgates.warehouse_store_cards_prices p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.pricelist_id::text ~* :mask \n\tOR \n\t\tp.price_definitions_id::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.currency_code::text ~* :mask \n\tOR \n\t\tp.store_cards_code::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.qunit::text ~* :mask \n\tOR \n\t\tp.unitrate::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.date_synced::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.message::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tupgates.warehouse_store_cards_prices p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.pricelist_id::text ~* :mask \n\tOR \n\t\tp.price_definitions_id::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.currency_code::text ~* :mask \n\tOR \n\t\tp.store_cards_code::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.qunit::text ~* :mask \n\tOR \n\t\tp.unitrate::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.date_synced::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.message::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  ")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.id = :id")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.id = :id")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.pricelist_id = :pricelistId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByPricelistId(@Bind(value="pricelistId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.pricelist_id = :pricelistId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByPricelistId(@Bind(value="pricelistId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.pricelist_id = :pricelistId")
    public long findListByPricelistIdCount(@Bind(value="pricelistId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.pricelist_id = :pricelistId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByPricelistId(@Bind(value="pricelistId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.price_definitions_id = :priceDefinitionsId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByPriceDefinitionsId(@Bind(value="priceDefinitionsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.price_definitions_id = :priceDefinitionsId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByPriceDefinitionsId(@Bind(value="priceDefinitionsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.price_definitions_id = :priceDefinitionsId")
    public long findListByPriceDefinitionsIdCount(@Bind(value="priceDefinitionsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.price_definitions_id = :priceDefinitionsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByPriceDefinitionsId(@Bind(value="priceDefinitionsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.currency_code = :currencyCode")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByCurrencyCode(@Bind(value="currencyCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.currency_code = :currencyCode")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByCurrencyCode(@Bind(value="currencyCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.currency_code = :currencyCode")
    public long findListByCurrencyCodeCount(@Bind(value="currencyCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.currency_code = :currencyCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByCurrencyCode(@Bind(value="currencyCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_code = :storeCardsCode")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByStoreCardsCode(@Bind(value="storeCardsCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_code = :storeCardsCode")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByStoreCardsCode(@Bind(value="storeCardsCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_code = :storeCardsCode")
    public long findListByStoreCardsCodeCount(@Bind(value="storeCardsCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.store_cards_code = :storeCardsCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByStoreCardsCode(@Bind(value="storeCardsCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.objversion = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.objversion = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.qunit = :qunit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByQunit(@Bind(value="qunit") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.qunit = :qunit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByQunit(@Bind(value="qunit") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.qunit = :qunit")
    public long findListByQunitCount(@Bind(value="qunit") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.qunit = :qunit ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByQunit(@Bind(value="qunit") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.unitrate = :unitrate")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByUnitrate(@Bind(value="unitrate") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.unitrate = :unitrate")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByUnitrate(@Bind(value="unitrate") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.unitrate = :unitrate")
    public long findListByUnitrateCount(@Bind(value="unitrate") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.unitrate = :unitrate ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByUnitrate(@Bind(value="unitrate") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.amount = :amount")
    public long findListByAmountCount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.amount = :amount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByAmount(@Bind(value="amount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_synced = :dateSynced")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_synced = :dateSynced")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.date_synced = :dateSynced")
    public long findListByDateSyncedCount(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_synced = :dateSynced ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateSynced(@Bind(value="dateSynced") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.version = :version")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.version = :version")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.version = :version")
    public long findListByVersionCount(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.version = :version ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByVersion(@Bind(value="version") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.message = :message")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public WarehouseStoreCardsPricesDomain findByMessage(@Bind(value="message") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.message = :message")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByMessage(@Bind(value="message") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_prices p  WHERE p.message = :message")
    public long findListByMessageCount(@Bind(value="message") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.pricelist_id, p.price_definitions_id, p.store_cards_id, p.currency_code, p.store_cards_code, p.objversion, p.qunit, p.unitrate, p.amount, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident, p.message FROM upgates.warehouse_store_cards_prices p  WHERE p.message = :message ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsPricesMapper.class)
    public List<WarehouseStoreCardsPricesDomain> findListByMessage(@Bind(value="message") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO upgates.warehouse_store_cards_prices (id, uid, abra_id, pricelist_id, price_definitions_id, store_cards_id, currency_code, store_cards_code, objversion, qunit, unitrate, amount, date_synced, date_changed, date_updated, date_created, version, ident, message) VALUES (:id, :uid, :abraId, :pricelistId, :priceDefinitionsId, :storeCardsId, :currencyCode, :storeCardsCode, :objversion, :qunit, :unitrate, :amount, :dateSynced, :dateChanged, :dateUpdated, :dateCreated, :version, :ident, :message)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="abraId") String var3, @Bind(value="pricelistId") Long var4, @Bind(value="priceDefinitionsId") Long var5, @Bind(value="storeCardsId") Long var6, @Bind(value="currencyCode") String var7, @Bind(value="storeCardsCode") String var8, @Bind(value="objversion") Integer var9, @Bind(value="qunit") String var10, @Bind(value="unitrate") Double var11, @Bind(value="amount") Double var12, @Bind(value="dateSynced") Date var13, @Bind(value="dateChanged") Date var14, @Bind(value="dateUpdated") Date var15, @Bind(value="dateCreated") Date var16, @Bind(value="version") Integer var17, @Bind(value="ident") String var18, @Bind(value="message") String var19);

    @SqlUpdate(value="INSERT INTO upgates.warehouse_store_cards_prices (abra_id, pricelist_id, price_definitions_id, store_cards_id, currency_code, store_cards_code, objversion, qunit, unitrate, amount, date_synced, date_changed, date_updated, date_created, version, ident, message) VALUES (:e.abraId, :e.pricelistId, :e.priceDefinitionsId, :e.storeCardsId, :e.currencyCode, :e.storeCardsCode, :e.objversion, :e.qunit, :e.unitrate, :e.amount, :e.dateSynced, :e.dateChanged, :e.dateUpdated, :e.dateCreated, :e.version, :e.ident, :e.message)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE id = :byId")
    public int updateById(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE pricelist_id = :byPricelistId")
    public int updateByPricelistId(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byPricelistId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE price_definitions_id = :byPriceDefinitionsId")
    public int updateByPriceDefinitionsId(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byPriceDefinitionsId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE currency_code = :byCurrencyCode")
    public int updateByCurrencyCode(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byCurrencyCode") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE store_cards_code = :byStoreCardsCode")
    public int updateByStoreCardsCode(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byStoreCardsCode") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE objversion = :byObjversion")
    public int updateByObjversion(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byObjversion") Integer var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE qunit = :byQunit")
    public int updateByQunit(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byQunit") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE unitrate = :byUnitrate")
    public int updateByUnitrate(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byUnitrate") Double var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE amount = :byAmount")
    public int updateByAmount(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byAmount") Double var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE date_synced = :byDateSynced")
    public int updateByDateSynced(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byDateSynced") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE version = :byVersion")
    public int updateByVersion(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byVersion") Integer var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_prices SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, pricelist_id = :e.pricelistId, price_definitions_id = :e.priceDefinitionsId, store_cards_id = :e.storeCardsId, currency_code = :e.currencyCode, store_cards_code = :e.storeCardsCode, objversion = :e.objversion, qunit = :e.qunit, unitrate = :e.unitrate, amount = :e.amount, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident, message = :e.message WHERE message = :byMessage")
    public int updateByMessage(@BindBean(value="e") WarehouseStoreCardsPricesDomain var1, @Bind(value="byMessage") String var2);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE pricelist_id = :pricelistId")
    public int deleteByPricelistId(@Bind(value="pricelistId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE price_definitions_id = :priceDefinitionsId")
    public int deleteByPriceDefinitionsId(@Bind(value="priceDefinitionsId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE currency_code = :currencyCode")
    public int deleteByCurrencyCode(@Bind(value="currencyCode") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE store_cards_code = :storeCardsCode")
    public int deleteByStoreCardsCode(@Bind(value="storeCardsCode") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE objversion = :objversion")
    public int deleteByObjversion(@Bind(value="objversion") Integer var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE qunit = :qunit")
    public int deleteByQunit(@Bind(value="qunit") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE unitrate = :unitrate")
    public int deleteByUnitrate(@Bind(value="unitrate") Double var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE amount = :amount")
    public int deleteByAmount(@Bind(value="amount") Double var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE date_synced = :dateSynced")
    public int deleteByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE version = :version")
    public int deleteByVersion(@Bind(value="version") Integer var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_prices WHERE message = :message")
    public int deleteByMessage(@Bind(value="message") String var1);
}

