/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.system;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.system.WebsitesMapper;
import cz.airtoy.airshop.domains.system.WebsitesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface WebsitesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.title,\n\t\tp.parser,\n\t\tp.website,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tsystem.websites p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.parser::text ~* :mask \n\tOR \n\t\tp.website::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.websites p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.parser::text ~* :mask \n\tOR \n\t\tp.website::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  ")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.id = :id")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.id = :id")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.title = :title")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findByTitle(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.title = :title")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByTitle(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.title = :title")
    public long findListByTitleCount(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.title = :title ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByTitle(@Bind(value="title") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.parser = :parser")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findByParser(@Bind(value="parser") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.parser = :parser")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByParser(@Bind(value="parser") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.parser = :parser")
    public long findListByParserCount(@Bind(value="parser") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.parser = :parser ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByParser(@Bind(value="parser") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.website = :website")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findByWebsite(@Bind(value="website") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.website = :website")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByWebsite(@Bind(value="website") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.website = :website")
    public long findListByWebsiteCount(@Bind(value="website") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.website = :website ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByWebsite(@Bind(value="website") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.note = :note")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.note = :note")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public WebsitesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.websites p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.parser, p.website, p.date_changed, p.user_changed, p.note, p.date_created FROM system.websites p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WebsitesMapper.class)
    public List<WebsitesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.websites (id, title, parser, website, date_changed, user_changed, note, date_created) VALUES (:id, :title, :parser, :website, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="title") String var2, @Bind(value="parser") String var3, @Bind(value="website") String var4, @Bind(value="dateChanged") Date var5, @Bind(value="userChanged") String var6, @Bind(value="note") String var7, @Bind(value="dateCreated") Date var8);

    @SqlUpdate(value="INSERT INTO system.websites (title, parser, website, date_changed, user_changed, note, date_created) VALUES (:e.title, :e.parser, :e.website, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") WebsitesDomain var1);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE title = :byTitle")
    public int updateByTitle(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byTitle") String var2);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE parser = :byParser")
    public int updateByParser(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byParser") String var2);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE website = :byWebsite")
    public int updateByWebsite(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byWebsite") String var2);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE system.websites SET id = :e.id, title = :e.title, parser = :e.parser, website = :e.website, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") WebsitesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.websites WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.websites WHERE title = :title")
    public int deleteByTitle(@Bind(value="title") String var1);

    @SqlUpdate(value="DELETE FROM system.websites WHERE parser = :parser")
    public int deleteByParser(@Bind(value="parser") String var1);

    @SqlUpdate(value="DELETE FROM system.websites WHERE website = :website")
    public int deleteByWebsite(@Bind(value="website") String var1);

    @SqlUpdate(value="DELETE FROM system.websites WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM system.websites WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM system.websites WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM system.websites WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

