/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.CommodityPropertyMapper;
import cz.airtoy.airshop.domains.data.CommodityPropertyDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface CommodityPropertyDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.commodity_id,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.value,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.commodity_property p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.commodity_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.commodity_property p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.commodity_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.commodity_id = :commodityId AND p.language_name = :languageName")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByCommodityIdLanguageName(@Bind(value="commodityId") Long var1, @Bind(value="languageName") String var2);

    @SqlUpdate(value="DELETE FROM data.commodity_property p WHERE p.commodity_id = :commodityId AND p.language_name = :languageName AND p.date_updated IS NULL ")
    public int deleteByCommodityIdLanguageNameDateUpdatedIsNull(@Bind(value="commodityId") Long var1, @Bind(value="languageName") String var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  ")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.commodity_id = :commodityId")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.commodity_id = :commodityId")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.commodity_id = :commodityId")
    public long findListByCommodityIdCount(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.commodity_id = :commodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByCommodityId(@Bind(value="commodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.name = :name")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.name = :name")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.value = :value")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.value = :value")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.value = :value")
    public long findListByValueCount(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.value = :value ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByValue(@Bind(value="value") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.note = :note")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.note = :note")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public CommodityPropertyDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_property p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.commodity_property p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityPropertyMapper.class)
    public List<CommodityPropertyDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.commodity_property (id, uid, commodity_id, language_name, name, value, date_updated, note, date_created) VALUES (:id, :uid, :commodityId, :languageName, :name, :value, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="commodityId") Long var3, @Bind(value="languageName") String var4, @Bind(value="name") String var5, @Bind(value="value") String var6, @Bind(value="dateUpdated") Date var7, @Bind(value="note") String var8, @Bind(value="dateCreated") Date var9);

    @SqlUpdate(value="INSERT INTO data.commodity_property (commodity_id, language_name, name, value, date_updated, note, date_created) VALUES (:e.commodityId, :e.languageName, :e.name, :e.value, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") CommodityPropertyDomain var1);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE commodity_id = :byCommodityId")
    public int updateByCommodityId(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byCommodityId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE value = :byValue")
    public int updateByValue(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byValue") String var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.commodity_property SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") CommodityPropertyDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE commodity_id = :commodityId")
    public int deleteByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE value = :value")
    public int deleteByValue(@Bind(value="value") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_property WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

