/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.abra;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.abra.AbraStoreeansMapper;
import cz.airtoy.airshop.domains.abra.AbraStoreeansDomain;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface AbraStoreeansDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.ID,\n\t\tp.OBJVERSION,\n\t\tp.PARENT_ID,\n\t\tp.EAN\n FROM \n\t\tSTOREEANS p\n\t\n\t\tWHERE \n\t\tp.ID::text ~* :mask \n\tOR \n\t\tp.OBJVERSION::text ~* :mask \n\tOR \n\t\tp.PARENT_ID::text ~* :mask \n\tOR \n\t\tp.EAN::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tSTOREEANS p\n\t\n\t\tWHERE \n\t\tp.ID::text ~* :mask \n\tOR \n\t\tp.OBJVERSION::text ~* :mask \n\tOR \n\t\tp.PARENT_ID::text ~* :mask \n\tOR \n\t\tp.EAN::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findAll();

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.ID = :id")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public AbraStoreeansDomain findById(@Bind(value="id") String var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.ID = :id")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListById(@Bind(value="id") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREEANS p  WHERE p.ID = :id")
    public long findListByIdCount(@Bind(value="id") String var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.ID = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListById(@Bind(value="id") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.OBJVERSION = :objversion")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public AbraStoreeansDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.OBJVERSION = :objversion")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREEANS p  WHERE p.OBJVERSION = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.OBJVERSION = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.PARENT_ID = :parentId")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public AbraStoreeansDomain findByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.PARENT_ID = :parentId")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREEANS p  WHERE p.PARENT_ID = :parentId")
    public long findListByParentIdCount(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.PARENT_ID = :parentId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListByParentId(@Bind(value="parentId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.EAN = :ean")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public AbraStoreeansDomain findByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.EAN = :ean")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM STOREEANS p  WHERE p.EAN = :ean")
    public long findListByEanCount(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.ID, p.OBJVERSION, p.PARENT_ID, p.EAN FROM STOREEANS p  WHERE p.EAN = :ean ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraStoreeansMapper.class)
    public List<AbraStoreeansDomain> findListByEan(@Bind(value="ean") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO STOREEANS (ID, OBJVERSION, PARENT_ID, EAN) VALUES (:id, :objversion, :parentId, :ean)")
    @GetGeneratedKeys
    public int insert(@Bind(value="id") String var1, @Bind(value="objversion") Integer var2, @Bind(value="parentId") String var3, @Bind(value="ean") String var4);

    @SqlUpdate(value="INSERT INTO STOREEANS (ID, OBJVERSION, PARENT_ID, EAN) VALUES (:e.id, :e.objversion, :e.parentId, :e.ean)")
    @GetGeneratedKeys
    public int insert(@BindBean(value="e") AbraStoreeansDomain var1);

    @SqlUpdate(value="UPDATE STOREEANS SET ID = :e.id, OBJVERSION = :e.objversion, PARENT_ID = :e.parentId, EAN = :e.ean WHERE ID = :byId")
    public int updateById(@BindBean(value="e") AbraStoreeansDomain var1, @Bind(value="byId") String var2);

    @SqlUpdate(value="UPDATE STOREEANS SET ID = :e.id, OBJVERSION = :e.objversion, PARENT_ID = :e.parentId, EAN = :e.ean WHERE OBJVERSION = :byObjversion")
    public int updateByObjversion(@BindBean(value="e") AbraStoreeansDomain var1, @Bind(value="byObjversion") Integer var2);

    @SqlUpdate(value="UPDATE STOREEANS SET ID = :e.id, OBJVERSION = :e.objversion, PARENT_ID = :e.parentId, EAN = :e.ean WHERE PARENT_ID = :byParentId")
    public int updateByParentId(@BindBean(value="e") AbraStoreeansDomain var1, @Bind(value="byParentId") String var2);

    @SqlUpdate(value="UPDATE STOREEANS SET ID = :e.id, OBJVERSION = :e.objversion, PARENT_ID = :e.parentId, EAN = :e.ean WHERE EAN = :byEan")
    public int updateByEan(@BindBean(value="e") AbraStoreeansDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="DELETE FROM STOREEANS WHERE ID = :id")
    public int deleteById(@Bind(value="id") String var1);

    @SqlUpdate(value="DELETE FROM STOREEANS WHERE OBJVERSION = :objversion")
    public int deleteByObjversion(@Bind(value="objversion") Integer var1);

    @SqlUpdate(value="DELETE FROM STOREEANS WHERE PARENT_ID = :parentId")
    public int deleteByParentId(@Bind(value="parentId") String var1);

    @SqlUpdate(value="DELETE FROM STOREEANS WHERE EAN = :ean")
    public int deleteByEan(@Bind(value="ean") String var1);
}

